/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v6_0_0;

import com.liferay.document.library.kernel.store.DLStoreUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.upgrade.util.UpgradeColumn;
import com.liferay.portal.kernel.upgrade.util.UpgradeTable;
import com.liferay.portal.kernel.upgrade.util.UpgradeTableFactoryUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.upgrade.v6_0_0.util.DLFileEntryNameUpgradeColumnImpl;
import com.liferay.portal.upgrade.v6_0_0.util.DLFileEntryTable;
import com.liferay.portal.upgrade.v6_0_0.util.DLFileEntryTitleUpgradeColumnImpl;
import com.liferay.portal.upgrade.v6_0_0.util.DLFileEntryVersionUpgradeColumnImpl;
import com.liferay.portal.upgrade.v6_0_0.util.DLFileRankTable;
import com.liferay.portal.upgrade.v6_0_0.util.DLFileShortcutTable;
import com.liferay.portal.upgrade.v6_0_0.util.DLFileVersionTable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;

public class UpgradeDocumentLibrary
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(UpgradeDocumentLibrary.class);

    protected void addFileVersion(long groupId, long companyId, long userId, String userName, long folderId, String name, double version, int size) throws Exception {
        Timestamp now = new Timestamp(System.currentTimeMillis());
        StringBundler sb = new StringBundler(5);
        sb.append("insert into DLFileVersion (fileVersionId, groupId, ");
        sb.append("companyId, userId, userName, createDate, folderId, ");
        sb.append("name, version, size_, status, statusByUserId, ");
        sb.append("statusByUserName, statusDate) values (?, ?, ?, ?, ?, ");
        sb.append("?, ?, ?, ?, ?, ?, ?, ?, ?)");
        String sql = sb.toString();
        try (PreparedStatement ps = this.connection.prepareStatement(sql);){
            ps.setLong(1, this.increment());
            ps.setLong(2, groupId);
            ps.setLong(3, companyId);
            ps.setLong(4, userId);
            ps.setString(5, userName);
            ps.setTimestamp(6, now);
            ps.setLong(7, folderId);
            ps.setString(8, name);
            ps.setDouble(9, version);
            ps.setInt(10, size);
            ps.setInt(11, 0);
            ps.setLong(12, userId);
            ps.setString(13, userName);
            ps.setTimestamp(14, now);
            ps.executeUpdate();
        }
    }

    protected void doUpgrade() throws Exception {
        this.updateFileEntries();
        this.synchronizeFileVersions();
        this.updateDLFileEntryTable();
        this.upgradeTable("DLFileRank", DLFileRankTable.TABLE_COLUMNS, "create table DLFileRank (fileRankId LONG not null primary key,groupId LONG,companyId LONG,userId LONG,createDate DATE null,folderId LONG,name VARCHAR(255) null)", DLFileRankTable.TABLE_SQL_ADD_INDEXES, new UpgradeColumn[]{new DLFileEntryNameUpgradeColumnImpl("name")});
        this.upgradeTable("DLFileShortcut", DLFileShortcutTable.TABLE_COLUMNS, "create table DLFileShortcut (uuid_ VARCHAR(75) null,fileShortcutId LONG not null primary key,groupId LONG,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,folderId LONG,toFolderId LONG,toName VARCHAR(255) null,status INTEGER,statusByUserId LONG,statusByUserName VARCHAR(75) null,statusDate DATE null)", DLFileShortcutTable.TABLE_SQL_ADD_INDEXES, new UpgradeColumn[]{new DLFileEntryNameUpgradeColumnImpl("toName")});
        this.upgradeTable("DLFileVersion", DLFileVersionTable.TABLE_COLUMNS, "create table DLFileVersion (fileVersionId LONG not null primary key,groupId LONG,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,folderId LONG,name VARCHAR(255) null,description STRING null,version VARCHAR(75) null,size_ INTEGER,status INTEGER,statusByUserId LONG,statusByUserName VARCHAR(75) null,statusDate DATE null)", DLFileVersionTable.TABLE_SQL_ADD_INDEXES, new UpgradeColumn[]{new DLFileEntryNameUpgradeColumnImpl("name"), new DLFileEntryVersionUpgradeColumnImpl("version")});
    }

    protected void synchronizeFileVersions() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            StringBundler sb = new StringBundler(5);
            sb.append("select * from DLFileEntry dlFileEntry where version ");
            sb.append("not in (select version from DLFileVersion ");
            sb.append("dlFileVersion where (dlFileVersion.folderId = ");
            sb.append("dlFileEntry.folderId) and (dlFileVersion.name = ");
            sb.append("dlFileEntry.name))");
            String sql = sb.toString();
            try (PreparedStatement ps = this.connection.prepareStatement(sql);
                 ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    long companyId = rs.getLong("companyId");
                    long groupId = rs.getLong("groupId");
                    long userId = rs.getLong("userId");
                    String userName = rs.getString("userName");
                    long folderId = rs.getLong("folderId");
                    String name = rs.getString("name");
                    double version = rs.getDouble("version");
                    int size = rs.getInt("size_");
                    this.addFileVersion(groupId, companyId, userId, userName, folderId, name, version, size);
                }
            }
        }
    }

    protected void updateDLFileEntryTable() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            DLFileEntryNameUpgradeColumnImpl nameColumn = new DLFileEntryNameUpgradeColumnImpl("name");
            DLFileEntryTitleUpgradeColumnImpl titleColumn = new DLFileEntryTitleUpgradeColumnImpl((UpgradeColumn)nameColumn, "title");
            DLFileEntryVersionUpgradeColumnImpl versionColumn = new DLFileEntryVersionUpgradeColumnImpl("version");
            UpgradeTable upgradeTable = UpgradeTableFactoryUtil.getUpgradeTable((String)"DLFileEntry", (Object[][])DLFileEntryTable.TABLE_COLUMNS, (UpgradeColumn[])new UpgradeColumn[]{nameColumn, titleColumn, versionColumn});
            upgradeTable.setAllowUniqueIndexes(true);
            upgradeTable.setCreateSQL("create table DLFileEntry (uuid_ VARCHAR(75) null,fileEntryId LONG not null primary key,groupId LONG,companyId LONG,userId LONG,userName VARCHAR(75) null,versionUserId LONG,versionUserName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,folderId LONG,name VARCHAR(255) null,title VARCHAR(255) null,description STRING null,version VARCHAR(75) null,pendingVersion VARCHAR(75) null,size_ INTEGER,readCount INTEGER,extraSettings TEXT null)");
            upgradeTable.setIndexesSQL(DLFileEntryTable.TABLE_SQL_ADD_INDEXES);
            upgradeTable.updateTable();
        }
    }

    protected void updateFileEntries() throws Exception {
        block41: {
            try (LoggingTimer loggingTimer = new LoggingTimer();
                 PreparedStatement ps = this.connection.prepareStatement("select * from DLFileEntry");){
                ResultSet rs = ps.executeQuery();
                Throwable throwable = null;
                block29: while (true) {
                    try {
                        while (rs.next()) {
                            String newName;
                            long companyId = rs.getLong("companyId");
                            long groupId = rs.getLong("groupId");
                            long folderId = rs.getLong("folderId");
                            String name = rs.getString("name");
                            long repositoryId = folderId;
                            if (repositoryId == 0L) {
                                repositoryId = groupId;
                            }
                            if ((newName = DLFileEntryNameUpgradeColumnImpl.getNewName(name)).equals(name)) continue;
                            try {
                                DLStoreUtil.updateFile((long)companyId, (long)repositoryId, (String)name, (String)newName);
                                continue block29;
                            }
                            catch (Exception e) {
                                if (!_log.isWarnEnabled()) continue;
                                _log.warn((Object)("Unable to update file for " + name), (Throwable)e);
                            }
                        }
                        break block41;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                finally {
                    if (rs != null) {
                        if (throwable != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                        } else {
                            rs.close();
                        }
                    }
                }
            }
        }
    }
}

