/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.template;

import com.liferay.portal.kernel.cache.MultiVMPoolUtil;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.SingleVMPoolUtil;
import com.liferay.portal.kernel.io.unsync.UnsyncStringWriter;
import com.liferay.portal.kernel.template.StringTemplateResource;
import com.liferay.portal.kernel.template.TemplateException;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.template.TemplateResourceLoader;
import com.liferay.portal.kernel.template.URLTemplateResource;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.template.AbstractTemplate;
import com.liferay.portal.template.CacheTemplateResource;
import com.liferay.portal.template.TemplateContextHelper;
import java.io.Serializable;
import java.io.Writer;
import java.util.Map;

public abstract class AbstractSingleResourceTemplate
extends AbstractTemplate {
    protected TemplateResource templateResource;

    public AbstractSingleResourceTemplate(TemplateResource templateResource, TemplateResource errorTemplateResource, Map<String, Object> context, TemplateContextHelper templateContextHelper, String templateManagerName, long interval) {
        super(errorTemplateResource, context, templateContextHelper, templateManagerName);
        if (templateResource == null) {
            throw new IllegalArgumentException("Template resource is null");
        }
        this.templateResource = templateResource;
        if (interval != 0L) {
            this.cacheTemplateResource(templateManagerName);
        }
    }

    public void doProcessTemplate(Writer writer) throws Exception {
        UnsyncStringWriter unsyncStringWriter = new UnsyncStringWriter();
        this.put("writer", (Object)unsyncStringWriter);
        this.processTemplate(this.templateResource, (Writer)unsyncStringWriter);
        StringBundler sb = unsyncStringWriter.getStringBundler();
        sb.writeTo(writer);
    }

    public void processTemplate(Writer writer) throws TemplateException {
        if (this.errorTemplateResource == null) {
            try {
                this.processTemplate(this.templateResource, writer);
                return;
            }
            catch (Exception e) {
                throw new TemplateException("Unable to process template " + this.templateResource.getTemplateId(), (Throwable)e);
            }
        }
        this._write(writer);
    }

    protected void cacheTemplateResource(String templateManagerName) {
        if (templateManagerName.equals("vm")) {
            return;
        }
        if (!(this.templateResource instanceof CacheTemplateResource) && !(this.templateResource instanceof StringTemplateResource)) {
            this.templateResource = new CacheTemplateResource(this.templateResource);
        }
        String portalCacheName = TemplateResourceLoader.class.getName();
        PortalCache<String, Serializable> portalCache = this.getPortalCache(this.templateResource, portalCacheName = portalCacheName.concat(".").concat(templateManagerName));
        Object object = portalCache.get((Serializable)((Object)this.templateResource.getTemplateId()));
        if (object == null || !this.templateResource.equals(object)) {
            portalCache.put((Serializable)((Object)this.templateResource.getTemplateId()), (Object)this.templateResource);
        }
        if (this.errorTemplateResource == null) {
            return;
        }
        if (templateManagerName.equals("vm")) {
            return;
        }
        if (!(this.errorTemplateResource instanceof CacheTemplateResource) && !(this.errorTemplateResource instanceof StringTemplateResource)) {
            this.errorTemplateResource = new CacheTemplateResource(this.errorTemplateResource);
        }
        if ((object = (portalCache = this.getPortalCache(this.errorTemplateResource, portalCacheName)).get((Serializable)((Object)this.errorTemplateResource.getTemplateId()))) == null || !this.errorTemplateResource.equals(object)) {
            portalCache.put((Serializable)((Object)this.errorTemplateResource.getTemplateId()), (Object)this.errorTemplateResource);
        }
    }

    protected PortalCache<String, Serializable> getPortalCache(TemplateResource templateResource, String portalCacheName) {
        if (!(templateResource instanceof CacheTemplateResource)) {
            return MultiVMPoolUtil.getPortalCache((String)portalCacheName);
        }
        CacheTemplateResource cacheTemplateResource = (CacheTemplateResource)templateResource;
        TemplateResource innerTemplateResource = cacheTemplateResource.getInnerTemplateResource();
        if (innerTemplateResource instanceof URLTemplateResource) {
            return SingleVMPoolUtil.getPortalCache((String)portalCacheName);
        }
        return MultiVMPoolUtil.getPortalCache((String)portalCacheName);
    }

    protected abstract void processTemplate(TemplateResource var1, Writer var2) throws Exception;
}

