/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.struts;

import com.liferay.portal.kernel.exception.NoSuchLayoutException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.impl.VirtualLayout;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.PortletLayoutFinder;
import com.liferay.portal.kernel.portlet.PortletURLFactoryUtil;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.service.permission.LayoutPermissionUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.struts.FindActionHelper;
import com.liferay.sites.kernel.util.SitesUtil;
import javax.portlet.PortletMode;
import javax.portlet.PortletURL;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class BaseFindActionHelper
implements FindActionHelper {
    private static final Log _log = LogFactoryUtil.getLog(BaseFindActionHelper.class);

    @Override
    public void execute(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        try {
            long groupId;
            long primaryKey;
            block10: {
                primaryKey = ParamUtil.getLong((HttpServletRequest)request, (String)this.getPrimaryKeyParameterName());
                groupId = ParamUtil.getLong((HttpServletRequest)request, (String)"groupId", (long)themeDisplay.getScopeGroupId());
                if (primaryKey > 0L) {
                    try {
                        long overrideGroupId = this.getGroupId(primaryKey);
                        if (overrideGroupId > 0L) {
                            groupId = overrideGroupId;
                        }
                    }
                    catch (Exception e) {
                        if (!_log.isDebugEnabled()) break block10;
                        _log.debug((Object)e, (Throwable)e);
                    }
                }
            }
            PortletLayoutFinder portletLayoutFinder = this.getPortletLayoutFinder();
            PortletLayoutFinder.Result result = portletLayoutFinder.find(themeDisplay, groupId);
            long plid = result.getPlid();
            Layout layout = BaseFindActionHelper.setTargetLayout(request, groupId, plid);
            LayoutPermissionUtil.check((PermissionChecker)themeDisplay.getPermissionChecker(), (Layout)layout, (boolean)true, (String)"VIEW");
            String portletId = result.getPortletId();
            LiferayPortletURL portletURL = PortletURLFactoryUtil.create((HttpServletRequest)request, (String)portletId, (long)plid, (String)"RENDER_PHASE");
            this.addRequiredParameters(request, portletId, (PortletURL)portletURL);
            boolean inheritRedirect = ParamUtil.getBoolean((HttpServletRequest)request, (String)"inheritRedirect");
            String redirect = null;
            if (inheritRedirect) {
                String noSuchEntryRedirect = ParamUtil.getString((HttpServletRequest)request, (String)"noSuchEntryRedirect");
                redirect = HttpUtil.getParameter((String)noSuchEntryRedirect, (String)"redirect", (boolean)false);
                redirect = HttpUtil.decodeURL((String)redirect);
            } else {
                redirect = ParamUtil.getString((HttpServletRequest)request, (String)"redirect");
            }
            if (Validator.isNotNull((String)redirect)) {
                portletURL.setParameter("redirect", redirect);
            }
            this.setPrimaryKeyParameter((PortletURL)portletURL, primaryKey);
            portletURL.setPortletMode(PortletMode.VIEW);
            portletURL.setWindowState(WindowState.NORMAL);
            portletURL = this.processPortletURL(request, (PortletURL)portletURL);
            response.sendRedirect(portletURL.toString());
        }
        catch (Exception e) {
            String noSuchEntryRedirect = ParamUtil.getString((HttpServletRequest)request, (String)"noSuchEntryRedirect");
            noSuchEntryRedirect = PortalUtil.escapeRedirect((String)noSuchEntryRedirect);
            if (Validator.isNotNull((String)noSuchEntryRedirect) && (e instanceof NoSuchLayoutException || e instanceof PrincipalException)) {
                response.sendRedirect(noSuchEntryRedirect);
            }
            PortalUtil.sendError((Exception)e, (HttpServletRequest)request, (HttpServletResponse)response);
        }
    }

    @Override
    public abstract long getGroupId(long var1) throws Exception;

    @Override
    public abstract String getPrimaryKeyParameterName();

    @Override
    public abstract PortletURL processPortletURL(HttpServletRequest var1, PortletURL var2) throws Exception;

    @Override
    public abstract void setPrimaryKeyParameter(PortletURL var1, long var2) throws Exception;

    protected static Layout setTargetLayout(HttpServletRequest request, long groupId, long plid) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        Group group = GroupLocalServiceUtil.getGroup((long)groupId);
        Layout layout = LayoutLocalServiceUtil.getLayout((long)plid);
        if (groupId == layout.getGroupId() || group.getParentGroupId() == layout.getGroupId() || layout.isPrivateLayout() && !SitesUtil.isUserGroupLayoutSetViewable((PermissionChecker)permissionChecker, (Group)layout.getGroup())) {
            return layout;
        }
        layout = new VirtualLayout(layout, group);
        request.setAttribute("LAYOUT", (Object)layout);
        return layout;
    }

    protected abstract void addRequiredParameters(HttpServletRequest var1, String var2, PortletURL var3);

    protected abstract PortletLayoutFinder getPortletLayoutFinder();
}

