/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.aop;

import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.spring.aop.ServiceBeanAopProxy;
import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.AdvisedSupport;

public class ServiceBeanMethodInvocation
implements MethodInvocation,
Serializable {
    private final Object[] _arguments;
    private boolean _equalsMethod;
    private int _hashCode;
    private int _index;
    private int _markIndex;
    private final Method _method;
    private List<MethodInterceptor> _methodInterceptors;
    private final Object _target;
    private final Class<?> _targetClass;
    private String _toString;

    public ServiceBeanMethodInvocation(Object target, Class<?> targetClass, Method method, Object[] arguments) {
        String methodName;
        this._target = target;
        this._targetClass = targetClass;
        this._method = method;
        this._arguments = arguments;
        if (!this._method.isAccessible()) {
            this._method.setAccessible(true);
        }
        if (this._method.getDeclaringClass() == Object.class && (methodName = this._method.getName()).equals("equals")) {
            this._equalsMethod = true;
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ServiceBeanMethodInvocation)) {
            return false;
        }
        ServiceBeanMethodInvocation serviceBeanMethodInvocation = (ServiceBeanMethodInvocation)obj;
        return Validator.equals((Object)this._method, (Object)serviceBeanMethodInvocation._method);
    }

    public Object[] getArguments() {
        return this._arguments;
    }

    public Method getMethod() {
        return this._method;
    }

    public AccessibleObject getStaticPart() {
        return this._method;
    }

    public Class<?> getTargetClass() {
        return this._targetClass;
    }

    public Object getThis() {
        return this._target;
    }

    public int hashCode() {
        if (this._hashCode == 0) {
            this._hashCode = this._method.hashCode();
        }
        return this._hashCode;
    }

    public void mark() {
        this._markIndex = this._index;
    }

    public Object proceed() throws Throwable {
        if (this._index < this._methodInterceptors.size()) {
            MethodInterceptor methodInterceptor = this._methodInterceptors.get(this._index++);
            return methodInterceptor.invoke((MethodInvocation)this);
        }
        if (this._equalsMethod) {
            AdvisedSupport advisedSupport;
            Object argument = this._arguments[0];
            if (argument == null) {
                return false;
            }
            if (ProxyUtil.isProxyClass(argument.getClass()) && (advisedSupport = ServiceBeanAopProxy.getAdvisedSupport(argument)) != null) {
                TargetSource targetSource = advisedSupport.getTargetSource();
                argument = targetSource.getTarget();
            }
            return this._target.equals(argument);
        }
        try {
            return this._method.invoke(this._target, this._arguments);
        }
        catch (InvocationTargetException ite) {
            throw ite.getTargetException();
        }
    }

    public void reset() {
        this._index = this._markIndex;
    }

    public void setMethodInterceptors(List<MethodInterceptor> methodInterceptors) {
        this._methodInterceptors = methodInterceptors;
    }

    public ServiceBeanMethodInvocation toCacheKeyModel() {
        ServiceBeanMethodInvocation serviceBeanMethodInvocation = new ServiceBeanMethodInvocation(null, null, this._method, null);
        serviceBeanMethodInvocation._equalsMethod = this._equalsMethod;
        serviceBeanMethodInvocation._hashCode = this._hashCode;
        return serviceBeanMethodInvocation;
    }

    public String toString() {
        if (this._toString != null) {
            return this._toString;
        }
        Class<?>[] parameterTypes = this._method.getParameterTypes();
        StringBundler sb = new StringBundler(parameterTypes.length * 2 + 6);
        Class<?> declaringClass = this._method.getDeclaringClass();
        sb.append(declaringClass.getName());
        sb.append(".");
        sb.append(this._method.getName());
        sb.append("(");
        for (int i = 0; i < parameterTypes.length; ++i) {
            Class<?> parameterType = parameterTypes[i];
            sb.append(parameterType.getName());
            if (i + 1 >= parameterTypes.length) continue;
            sb.append(",");
        }
        sb.append(")");
        if (this._targetClass != null) {
            sb.append("@");
            sb.append(this._targetClass.getName());
        }
        this._toString = sb.toString();
        return this._toString;
    }
}

