/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.exception.OldServiceComponentException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ModelHintsUtil;
import com.liferay.portal.kernel.model.ServiceComponent;
import com.liferay.portal.kernel.service.configuration.ServiceComponentConfiguration;
import com.liferay.portal.kernel.upgrade.util.UpgradeColumn;
import com.liferay.portal.kernel.upgrade.util.UpgradeTable;
import com.liferay.portal.kernel.upgrade.util.UpgradeTableFactoryUtil;
import com.liferay.portal.kernel.upgrade.util.UpgradeTableListener;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.DocumentException;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.kernel.xml.UnsecureSAXReaderUtil;
import com.liferay.portal.service.base.ServiceComponentLocalServiceBaseImpl;
import com.liferay.portal.util.PropsValues;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;

public class ServiceComponentLocalServiceImpl
extends ServiceComponentLocalServiceBaseImpl {
    private static final String _DATA_SOURCE_DEFAULT = "liferayDataSource";
    private static final int _SERVICE_COMPONENTS_MAX = 10;
    private static final Log _log = LogFactoryUtil.getLog(ServiceComponentLocalServiceImpl.class);
    private static final PACL _pacl = new NoPACL();

    public void destroyServiceComponent(ServiceComponentConfiguration serviceComponentConfiguration, ClassLoader classLoader) {
        if (PropsValues.CACHE_CLEAR_ON_PLUGIN_UNDEPLOY) {
            CacheRegistryUtil.clear();
        }
    }

    public List<ServiceComponent> getLatestServiceComponents() {
        return this.serviceComponentFinder.findByMaxBuildNumber();
    }

    public ServiceComponent initServiceComponent(ServiceComponentConfiguration serviceComponentConfiguration, ClassLoader classLoader, String buildNamespace, long buildNumber, long buildDate, boolean buildAutoUpgrade) throws PortalException {
        long serviceComponentId;
        try {
            ModelHintsUtil.read((ClassLoader)classLoader, (InputStream)serviceComponentConfiguration.getModelHintsInputStream());
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        try {
            ModelHintsUtil.read((ClassLoader)classLoader, (InputStream)serviceComponentConfiguration.getModelHintsExtInputStream());
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        ServiceComponent serviceComponent = null;
        ServiceComponent previousServiceComponent = null;
        List serviceComponents = this.serviceComponentPersistence.findByBuildNamespace(buildNamespace, 0, 1);
        if (serviceComponents.isEmpty()) {
            serviceComponentId = this.counterLocalService.increment();
            serviceComponent = this.serviceComponentPersistence.create(serviceComponentId);
            serviceComponent.setBuildNamespace(buildNamespace);
            serviceComponent.setBuildNumber(buildNumber);
            serviceComponent.setBuildDate(buildDate);
        } else {
            serviceComponent = (ServiceComponent)serviceComponents.get(0);
            if (serviceComponent.getBuildNumber() < buildNumber) {
                previousServiceComponent = serviceComponent;
                serviceComponentId = this.counterLocalService.increment();
                serviceComponent = this.serviceComponentPersistence.create(serviceComponentId);
                serviceComponent.setBuildNamespace(buildNamespace);
                serviceComponent.setBuildNumber(buildNumber);
                serviceComponent.setBuildDate(buildDate);
            } else {
                if (serviceComponent.getBuildNumber() > buildNumber) {
                    throw new OldServiceComponentException("Build namespace " + buildNamespace + " has build number " + serviceComponent.getBuildNumber() + " which is newer than " + buildNumber);
                }
                return serviceComponent;
            }
        }
        try {
            Document document = SAXReaderUtil.createDocument((String)"UTF-8");
            Element dataElement = document.addElement("data");
            Element tablesSQLElement = dataElement.addElement("tables-sql");
            String tablesSQL = StringUtil.read((InputStream)serviceComponentConfiguration.getSQLTablesInputStream());
            tablesSQLElement.addCDATA(tablesSQL);
            Element sequencesSQLElement = dataElement.addElement("sequences-sql");
            String sequencesSQL = StringUtil.read((InputStream)serviceComponentConfiguration.getSQLSequencesInputStream());
            sequencesSQLElement.addCDATA(sequencesSQL);
            Element indexesSQLElement = dataElement.addElement("indexes-sql");
            String indexesSQL = StringUtil.read((InputStream)serviceComponentConfiguration.getSQLIndexesInputStream());
            indexesSQLElement.addCDATA(indexesSQL);
            String dataXML = document.formattedString();
            serviceComponent.setData(dataXML);
            this.serviceComponentPersistence.update((BaseModel)serviceComponent);
            this.serviceComponentLocalService.upgradeDB(classLoader, buildNamespace, buildNumber, buildAutoUpgrade, previousServiceComponent, tablesSQL, sequencesSQL, indexesSQL);
            this.removeOldServiceComponents(buildNamespace);
            return serviceComponent;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    public void upgradeDB(ClassLoader classLoader, String buildNamespace, long buildNumber, boolean buildAutoUpgrade, ServiceComponent previousServiceComponent, String tablesSQL, String sequencesSQL, String indexesSQL) throws Exception {
        _pacl.doUpgradeDB(new DoUpgradeDBPrivilegedExceptionAction(classLoader, buildNamespace, buildNumber, buildAutoUpgrade, previousServiceComponent, tablesSQL, sequencesSQL, indexesSQL));
    }

    public void verifyDB() {
        List serviceComponents = this.serviceComponentPersistence.findAll();
        for (ServiceComponent serviceComponent : serviceComponents) {
            String buildNamespace = serviceComponent.getBuildNamespace();
            String tablesSQL = serviceComponent.getTablesSQL();
            String sequencesSQL = serviceComponent.getSequencesSQL();
            String indexesSQL = serviceComponent.getIndexesSQL();
            try {
                this.serviceComponentLocalService.upgradeDB(null, buildNamespace, 0L, false, null, tablesSQL, sequencesSQL, indexesSQL);
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
        }
    }

    protected void doUpgradeDB(ClassLoader classLoader, String buildNamespace, long buildNumber, boolean buildAutoUpgrade, ServiceComponent previousServiceComponent, String tablesSQL, String sequencesSQL, String indexesSQL) throws Exception {
        DB db = DBManagerUtil.getDB();
        if (previousServiceComponent == null) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Running " + buildNamespace + " SQL scripts"));
            }
            db.runSQLTemplateString(tablesSQL, true, false);
            db.runSQLTemplateString(sequencesSQL, true, false);
            db.runSQLTemplateString(indexesSQL, true, false);
        } else if (buildAutoUpgrade) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Upgrading " + buildNamespace + " database to build number " + buildNumber));
            }
            if (!tablesSQL.equals(previousServiceComponent.getTablesSQL())) {
                if (_log.isInfoEnabled()) {
                    _log.info((Object)"Upgrading database with tables.sql");
                }
                db.runSQLTemplateString(tablesSQL, true, false);
                this.upgradeModels(classLoader, previousServiceComponent, tablesSQL);
            }
            if (!sequencesSQL.equals(previousServiceComponent.getSequencesSQL())) {
                if (_log.isInfoEnabled()) {
                    _log.info((Object)"Upgrading database with sequences.sql");
                }
                db.runSQLTemplateString(sequencesSQL, true, false);
            }
            if (!indexesSQL.equals(previousServiceComponent.getIndexesSQL()) || !tablesSQL.equals(previousServiceComponent.getTablesSQL())) {
                if (_log.isInfoEnabled()) {
                    _log.info((Object)"Upgrading database with indexes.sql");
                }
                db.runSQLTemplateString(indexesSQL, true, false);
            }
        }
    }

    protected List<String> getModelNames(ClassLoader classLoader) throws DocumentException, IOException {
        ArrayList<String> modelNames;
        block2: {
            modelNames = new ArrayList<String>();
            String xml = StringUtil.read((ClassLoader)classLoader, (String)"META-INF/portlet-model-hints.xml");
            modelNames.addAll(this.getModelNames(xml));
            try {
                xml = StringUtil.read((ClassLoader)classLoader, (String)"META-INF/portlet-model-hints-ext.xml");
                modelNames.addAll(this.getModelNames(xml));
            }
            catch (Exception e) {
                if (!_log.isInfoEnabled()) break block2;
                _log.info((Object)"No optional file META-INF/portlet-model-hints-ext.xml found");
            }
        }
        return modelNames;
    }

    protected List<String> getModelNames(String xml) throws DocumentException {
        ArrayList<String> modelNames = new ArrayList<String>();
        Document document = UnsecureSAXReaderUtil.read((String)xml);
        Element rootElement = document.getRootElement();
        List modelElements = rootElement.elements("model");
        for (Element modelElement : modelElements) {
            String name = modelElement.attributeValue("name");
            modelNames.add(name);
        }
        return modelNames;
    }

    protected List<String> getModifiedTableNames(String previousTablesSQL, String tablesSQL) {
        ArrayList<String> modifiedTableNames = new ArrayList<String>();
        List previousTablesSQLParts = ListUtil.toList((Object[])StringUtil.split((String)previousTablesSQL, (String)";"));
        List tablesSQLParts = ListUtil.toList((Object[])StringUtil.split((String)tablesSQL, (String)";"));
        tablesSQLParts.removeAll(previousTablesSQLParts);
        for (String tablesSQLPart : tablesSQLParts) {
            int x = tablesSQLPart.indexOf("create table ");
            int y = tablesSQLPart.indexOf(" (");
            modifiedTableNames.add(tablesSQLPart.substring(x + 13, y));
        }
        return modifiedTableNames;
    }

    protected UpgradeTableListener getUpgradeTableListener(ClassLoader classLoader, Class<?> modelClass) {
        String modelClassName;
        String upgradeTableListenerClassName = modelClassName = modelClass.getName();
        upgradeTableListenerClassName = StringUtil.replaceLast((String)upgradeTableListenerClassName, (String)".model.impl.", (String)".model.upgrade.");
        upgradeTableListenerClassName = StringUtil.replaceLast((String)upgradeTableListenerClassName, (String)"ModelImpl", (String)"UpgradeTableListener");
        try {
            UpgradeTableListener upgradeTableListener = (UpgradeTableListener)InstanceFactory.newInstance((ClassLoader)classLoader, (String)upgradeTableListenerClassName);
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Instantiated " + upgradeTableListenerClassName));
            }
            return upgradeTableListener;
        }
        catch (Exception e) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Unable to instantiate " + upgradeTableListenerClassName));
            }
            return null;
        }
    }

    protected void removeOldServiceComponents(String buildNamespace) {
        int serviceComponentsCount = this.serviceComponentPersistence.countByBuildNamespace(buildNamespace);
        if (serviceComponentsCount < 10) {
            return;
        }
        List serviceComponents = this.serviceComponentPersistence.findByBuildNamespace(buildNamespace, 10, serviceComponentsCount);
        for (int i = 0; i < serviceComponents.size(); ++i) {
            ServiceComponent serviceComponent = (ServiceComponent)serviceComponents.get(i);
            this.serviceComponentPersistence.remove((BaseModel)serviceComponent);
        }
    }

    protected void upgradeModels(ClassLoader classLoader, ServiceComponent previousServiceComponent, String tablesSQL) throws Exception {
        List<String> modifiedTableNames = this.getModifiedTableNames(previousServiceComponent.getTablesSQL(), tablesSQL);
        List<String> modelNames = this.getModelNames(classLoader);
        for (String modelName : modelNames) {
            Field tableNameField;
            String tableName;
            int pos;
            Class<?> modelClass = Class.forName(modelName.substring(0, pos = modelName.lastIndexOf(".model.")) + ".model.impl." + modelName.substring(pos + 7) + "ModelImpl", true, classLoader);
            Field dataSourceField = modelClass.getField("DATA_SOURCE");
            String dataSource = (String)dataSourceField.get(null);
            if (!dataSource.equals(_DATA_SOURCE_DEFAULT) || !modifiedTableNames.contains(tableName = (String)(tableNameField = modelClass.getField("TABLE_NAME")).get(null))) continue;
            Field tableColumnsField = modelClass.getField("TABLE_COLUMNS");
            Object[][] tableColumns = (Object[][])tableColumnsField.get(null);
            UpgradeTable upgradeTable = UpgradeTableFactoryUtil.getUpgradeTable((String)tableName, (Object[][])tableColumns, (UpgradeColumn[])new UpgradeColumn[0]);
            UpgradeTableListener upgradeTableListener = this.getUpgradeTableListener(classLoader, modelClass);
            Field tableSQLCreateField = modelClass.getField("TABLE_SQL_CREATE");
            String tableSQLCreate = (String)tableSQLCreateField.get(null);
            upgradeTable.setCreateSQL(tableSQLCreate);
            if (upgradeTableListener != null) {
                upgradeTableListener.onBeforeUpdateTable(previousServiceComponent, upgradeTable);
            }
            upgradeTable.updateTable();
            if (upgradeTableListener == null) continue;
            upgradeTableListener.onAfterUpdateTable(previousServiceComponent, upgradeTable);
        }
    }

    private static class NoPACL
    implements PACL {
        private NoPACL() {
        }

        @Override
        public void doUpgradeDB(DoUpgradeDBPrivilegedExceptionAction doUpgradeDBPrivilegedExceptionAction) throws Exception {
            doUpgradeDBPrivilegedExceptionAction.run();
        }
    }

    public static interface PACL {
        public void doUpgradeDB(DoUpgradeDBPrivilegedExceptionAction var1) throws Exception;
    }

    public class DoUpgradeDBPrivilegedExceptionAction
    implements PrivilegedExceptionAction<Void> {
        private final boolean _buildAutoUpgrade;
        private final String _buildNamespace;
        private final long _buildNumber;
        private final ClassLoader _classLoader;
        private final String _indexesSQL;
        private final ServiceComponent _previousServiceComponent;
        private final String _sequencesSQL;
        private final String _tablesSQL;

        public DoUpgradeDBPrivilegedExceptionAction(ClassLoader classLoader, String buildNamespace, long buildNumber, boolean buildAutoUpgrade, ServiceComponent previousServiceComponent, String tablesSQL, String sequencesSQL, String indexesSQL) {
            this._classLoader = classLoader;
            this._buildNamespace = buildNamespace;
            this._buildNumber = buildNumber;
            this._buildAutoUpgrade = buildAutoUpgrade;
            this._previousServiceComponent = previousServiceComponent;
            this._tablesSQL = tablesSQL;
            this._sequencesSQL = sequencesSQL;
            this._indexesSQL = indexesSQL;
        }

        public ClassLoader getClassLoader() {
            return this._classLoader;
        }

        @Override
        public Void run() throws Exception {
            ServiceComponentLocalServiceImpl.this.doUpgradeDB(this._classLoader, this._buildNamespace, this._buildNumber, this._buildAutoUpgrade, this._previousServiceComponent, this._tablesSQL, this._sequencesSQL, this._indexesSQL);
            return null;
        }
    }
}

