/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.exportimport.kernel.staging.LayoutStagingUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.LayoutSetBranch;
import com.liferay.portal.kernel.model.LayoutSetStagingHandler;
import com.liferay.portal.kernel.service.LayoutSetLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ClassLoaderUtil;
import com.liferay.portal.kernel.util.ColorSchemeFactoryUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.ThemeFactoryUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.service.impl.LayoutSetLocalServiceImpl;
import com.liferay.portlet.exportimport.staging.StagingAdvicesThreadLocal;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class LayoutSetLocalServiceStagingAdvice
extends LayoutSetLocalServiceImpl
implements MethodInterceptor {
    private static final Set<String> _layoutSetLocalServiceStagingAdviceMethodNames = new HashSet<String>();

    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        if (!StagingAdvicesThreadLocal.isEnabled()) {
            return methodInvocation.proceed();
        }
        Method method = methodInvocation.getMethod();
        String methodName = method.getName();
        if (!_layoutSetLocalServiceStagingAdviceMethodNames.contains(methodName)) {
            return this.wrapReturnValue(methodInvocation.proceed());
        }
        Object returnValue = null;
        Object thisObject = methodInvocation.getThis();
        Object[] arguments = methodInvocation.getArguments();
        if (methodName.equals("updateLayoutSetPrototypeLinkEnabled") && arguments.length == 5) {
            this.updateLayoutSetPrototypeLinkEnabled((LayoutSetLocalService)thisObject, (Long)arguments[0], (Boolean)arguments[1], (Boolean)arguments[2], (String)arguments[3]);
        } else if (methodName.equals("updateLogo") && arguments.length == 4) {
            returnValue = this.updateLogo((LayoutSetLocalService)thisObject, (Long)arguments[0], (boolean)((Boolean)arguments[1]), (Boolean)arguments[2], (byte[])arguments[3]);
        } else if (methodName.equals("updateLookAndFeel") && arguments.length == 5) {
            returnValue = this.updateLookAndFeel((LayoutSetLocalService)thisObject, (Long)arguments[0], (Boolean)arguments[1], (String)arguments[2], (String)arguments[3], (String)arguments[4]);
        } else if (methodName.equals("updateSettings")) {
            returnValue = this.updateSettings((LayoutSetLocalService)thisObject, (Long)arguments[0], (Boolean)arguments[1], (String)arguments[2]);
        } else {
            try {
                Class<?> clazz = ((Object)((Object)this)).getClass();
                Class[] parameterTypes = (Class[])ArrayUtil.append((Object[])new Class[]{LayoutSetLocalService.class}, (Object[])method.getParameterTypes());
                Method layoutSetLocalServiceStagingAdviceMethod = clazz.getMethod(methodName, parameterTypes);
                arguments = ArrayUtil.append((Object[])new Object[]{thisObject}, (Object[])arguments);
                returnValue = layoutSetLocalServiceStagingAdviceMethod.invoke((Object)this, arguments);
            }
            catch (InvocationTargetException ite) {
                throw ite.getTargetException();
            }
            catch (NoSuchMethodException nsme) {
                returnValue = methodInvocation.proceed();
            }
        }
        return this.wrapReturnValue(returnValue);
    }

    public void updateLayoutSetPrototypeLinkEnabled(LayoutSetLocalService layoutSetLocalService, long groupId, boolean privateLayout, boolean layoutSetPrototypeLinkEnabled, String layoutSetPrototypeUuid) throws PortalException {
        LayoutSet layoutSet = this.layoutSetPersistence.findByG_P(groupId, privateLayout);
        LayoutSetBranch layoutSetBranch = LayoutStagingUtil.getLayoutSetBranch((LayoutSet)(layoutSet = this.wrapLayoutSet(layoutSet)));
        if (layoutSetBranch == null) {
            layoutSetLocalService.updateLayoutSetPrototypeLinkEnabled(groupId, privateLayout, layoutSetPrototypeLinkEnabled, layoutSetPrototypeUuid);
            return;
        }
        if (Validator.isNull((String)layoutSetPrototypeUuid)) {
            layoutSetPrototypeUuid = layoutSetBranch.getLayoutSetPrototypeUuid();
        }
        if (Validator.isNull((String)layoutSetPrototypeUuid) && layoutSetPrototypeLinkEnabled) {
            throw new IllegalStateException("Cannot set layoutSetPrototypeLinkEnabled to true when layoutSetPrototypeUuid is null");
        }
        layoutSetBranch.setLayoutSetPrototypeLinkEnabled(layoutSetPrototypeLinkEnabled);
        layoutSetBranch.setLayoutSetPrototypeUuid(layoutSetPrototypeUuid);
        this.layoutSetBranchPersistence.update((BaseModel)layoutSetBranch);
    }

    public LayoutSet updateLogo(LayoutSetLocalService layoutSetLocalService, long groupId, boolean privateLayout, boolean logo, byte[] logoBytes) throws PortalException {
        LayoutSet layoutSet = this.layoutSetPersistence.findByG_P(groupId, privateLayout);
        LayoutSetBranch layoutSetBranch = LayoutStagingUtil.getLayoutSetBranch((LayoutSet)(layoutSet = this.wrapLayoutSet(layoutSet)));
        if (layoutSetBranch == null) {
            return layoutSetLocalService.updateLogo(groupId, privateLayout, logo, logoBytes);
        }
        layoutSetBranch.setModifiedDate(new Date());
        PortalUtil.updateImageId((BaseModel)layoutSetBranch, (boolean)logo, (byte[])logoBytes, (String)"logoId", (long)0L, (int)0, (int)0);
        this.layoutSetBranchPersistence.update((BaseModel)layoutSetBranch);
        return layoutSet;
    }

    public LayoutSet updateLookAndFeel(LayoutSetLocalService target, long groupId, boolean privateLayout, String themeId, String colorSchemeId, String css) throws PortalException {
        LayoutSet layoutSet = this.layoutSetPersistence.findByG_P(groupId, privateLayout);
        LayoutSetBranch layoutSetBranch = LayoutStagingUtil.getLayoutSetBranch((LayoutSet)(layoutSet = this.wrapLayoutSet(layoutSet)));
        if (layoutSetBranch == null) {
            return target.updateLookAndFeel(groupId, privateLayout, themeId, colorSchemeId, css);
        }
        layoutSetBranch.setModifiedDate(new Date());
        if (Validator.isNull((String)themeId)) {
            themeId = ThemeFactoryUtil.getDefaultRegularThemeId((long)layoutSetBranch.getCompanyId());
        }
        if (Validator.isNull((String)colorSchemeId)) {
            colorSchemeId = ColorSchemeFactoryUtil.getDefaultRegularColorSchemeId();
        }
        layoutSetBranch.setThemeId(themeId);
        layoutSetBranch.setColorSchemeId(colorSchemeId);
        layoutSetBranch.setCss(css);
        this.layoutSetBranchPersistence.update((BaseModel)layoutSetBranch);
        return layoutSet;
    }

    public LayoutSet updateSettings(LayoutSetLocalService target, long groupId, boolean privateLayout, String settings) throws PortalException {
        LayoutSet layoutSet = this.layoutSetPersistence.findByG_P(groupId, privateLayout);
        LayoutSetBranch layoutSetBranch = LayoutStagingUtil.getLayoutSetBranch((LayoutSet)(layoutSet = this.wrapLayoutSet(layoutSet)));
        if (layoutSetBranch == null) {
            return target.updateSettings(groupId, privateLayout, settings);
        }
        layoutSetBranch.setModifiedDate(new Date());
        layoutSetBranch.setSettings(settings);
        this.layoutSetBranchPersistence.update((BaseModel)layoutSetBranch);
        return layoutSet;
    }

    protected LayoutSet unwrapLayoutSet(LayoutSet layoutSet) {
        LayoutSetStagingHandler layoutSetStagingHandler = LayoutStagingUtil.getLayoutSetStagingHandler((LayoutSet)layoutSet);
        if (layoutSetStagingHandler == null) {
            return layoutSet;
        }
        return layoutSetStagingHandler.getLayoutSet();
    }

    protected LayoutSet wrapLayoutSet(LayoutSet layoutSet) {
        LayoutSetStagingHandler layoutSetStagingHandler = LayoutStagingUtil.getLayoutSetStagingHandler((LayoutSet)layoutSet);
        if (layoutSetStagingHandler != null) {
            return layoutSet;
        }
        Group group = null;
        try {
            group = layoutSet.getGroup();
        }
        catch (Exception e) {
            return layoutSet;
        }
        if (!LayoutStagingUtil.isBranchingLayoutSet((Group)group, (boolean)layoutSet.getPrivateLayout())) {
            return layoutSet;
        }
        return (LayoutSet)ProxyUtil.newProxyInstance((ClassLoader)ClassLoaderUtil.getPortalClassLoader(), (Class[])new Class[]{LayoutSet.class}, (InvocationHandler)new LayoutSetStagingHandler(layoutSet));
    }

    protected List<LayoutSet> wrapLayoutSets(List<LayoutSet> layoutSets) {
        if (layoutSets.isEmpty()) {
            return layoutSets;
        }
        ArrayList<LayoutSet> wrappedLayoutSets = new ArrayList<LayoutSet>(layoutSets.size());
        for (int i = 0; i < layoutSets.size(); ++i) {
            LayoutSet wrappedLayoutSet = this.wrapLayoutSet(layoutSets.get(i));
            wrappedLayoutSets.add(wrappedLayoutSet);
        }
        return wrappedLayoutSets;
    }

    protected Object wrapReturnValue(Object returnValue) {
        List list;
        if (returnValue instanceof LayoutSet) {
            returnValue = this.wrapLayoutSet((LayoutSet)returnValue);
        } else if (returnValue instanceof List && !(list = (List)returnValue).isEmpty() && list.get(0) instanceof LayoutSet) {
            returnValue = this.wrapLayoutSets(returnValue);
        }
        return returnValue;
    }

    static {
        _layoutSetLocalServiceStagingAdviceMethodNames.add("updateLayoutSetPrototypeLinkEnabled");
        _layoutSetLocalServiceStagingAdviceMethodNames.add("updateLogo");
        _layoutSetLocalServiceStagingAdviceMethodNames.add("updateLookAndFeel");
        _layoutSetLocalServiceStagingAdviceMethodNames.add("updateSettings");
    }
}

