/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.jsonwebservice;

import com.liferay.portal.jsonwebservice.JSONWebServiceServiceAction;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.servlet.JSONServlet;
import com.liferay.portal.spring.context.PortalContextLoaderListener;
import com.liferay.portal.struts.JSONAction;
import com.liferay.portal.util.PropsValues;
import java.io.IOException;
import java.util.Locale;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class JSONWebServiceServlet
extends JSONServlet {
    private static final Log _log = LogFactoryUtil.getLog(JSONWebServiceServlet.class);

    @Override
    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String path = GetterUtil.getString((String)request.getPathInfo());
        if (!PropsValues.JSONWS_WEB_SERVICE_API_DISCOVERABLE || !path.equals("") && !path.equals("/") || request.getParameter("discover") != null) {
            Locale locale = PortalUtil.getLocale((HttpServletRequest)request, (HttpServletResponse)response, (boolean)true);
            LocaleThreadLocal.setThemeDisplayLocale((Locale)locale);
            super.service(request, response);
            return;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Servlet context " + request.getContextPath()));
        }
        String apiPath = PortalUtil.getPathMain() + "/portal/api/jsonws";
        HttpSession session = request.getSession();
        ServletContext servletContext = session.getServletContext();
        String contextPath = PortalContextLoaderListener.getPortalServletContextPath();
        if (contextPath.isEmpty()) {
            contextPath = "/";
        }
        String proxyPath = PortalUtil.getPathProxy();
        if (servletContext.getContext(contextPath) != null) {
            if (Validator.isNotNull((String)proxyPath) && apiPath.startsWith(proxyPath)) {
                apiPath = apiPath.substring(proxyPath.length());
            }
            if (!contextPath.equals("/") && apiPath.startsWith(contextPath)) {
                apiPath = apiPath.substring(contextPath.length());
            }
            RequestDispatcher requestDispatcher = request.getRequestDispatcher(apiPath);
            requestDispatcher.forward((ServletRequest)request, (ServletResponse)response);
        } else {
            String servletContextPath = servletContext.getContextPath();
            String redirectPath = PortalUtil.getPathContext() + "/api/jsonws?contextPath=" + HttpUtil.encodeURL((String)servletContextPath);
            response.sendRedirect(redirectPath);
        }
    }

    @Override
    protected JSONAction getJSONAction(ServletContext servletContext) {
        JSONWebServiceServiceAction jsonWebServiceServiceAction = new JSONWebServiceServiceAction();
        jsonWebServiceServiceAction.setServletContext(servletContext);
        return jsonWebServiceServiceAction;
    }
}

