/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.css.builder;

import com.liferay.css.builder.CSSBuilderUtil;
import com.liferay.portal.kernel.regex.PatternFactory;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.ArgumentsUtil;
import com.liferay.rtl.css.RTLCSSConverter;
import com.liferay.sass.compiler.SassCompiler;
import com.liferay.sass.compiler.SassCompilerException;
import com.liferay.sass.compiler.jni.internal.JniSassCompiler;
import com.liferay.sass.compiler.ruby.internal.RubySassCompiler;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.tools.ant.DirectoryScanner;

public class CSSBuilder
implements AutoCloseable {
    private static RTLCSSConverter _rtlCSSConverter;
    private final boolean _cleanPortalCommonDir;
    private final String _docrootDirName;
    private final boolean _generateSourceMap;
    private final String _outputDirName;
    private final String _portalCommonDirName;
    private final int _precision;
    private final Pattern[] _rtlExcludedPathPatterns;
    private SassCompiler _sassCompiler;

    public static void main(String[] args) throws Exception {
        Map<String, String> arguments = ArgumentsUtil.parseArguments(args);
        ArrayList<String> dirNames = new ArrayList<String>();
        String dirName = GetterUtil.getString(arguments.get("sass.dir"), "/");
        if (Validator.isNotNull(dirName)) {
            dirNames.add(dirName);
        } else {
            int i = 0;
            while (Validator.isNotNull(dirName = arguments.get("sass.dir." + i))) {
                dirNames.add(dirName);
                ++i;
            }
        }
        String docrootDirName = GetterUtil.getString(arguments.get("sass.docroot.dir"), "src/META-INF/resources");
        boolean generateSourceMap = GetterUtil.getBoolean(arguments.get("sass.generate.source.map"));
        String outputDirName = GetterUtil.getString(arguments.get("sass.output.dir"), ".sass-cache/");
        String portalCommonPath = arguments.get("sass.portal.common.path");
        if (Validator.isNull(portalCommonPath)) {
            portalCommonPath = arguments.get("sass.portal.common.dir");
        }
        int precision = GetterUtil.getInteger(arguments.get("sass.precision"), 9);
        String[] rtlExcludedPathRegexps = StringUtil.split(arguments.get("sass.rtl.excluded.path.regexps"));
        String sassCompilerClassName = arguments.get("sass.compiler.class.name");
        try (CSSBuilder cssBuilder = new CSSBuilder(docrootDirName, generateSourceMap, outputDirName, portalCommonPath, precision, rtlExcludedPathRegexps, sassCompilerClassName);){
            cssBuilder.execute(dirNames);
        }
        catch (Exception e) {
            ArgumentsUtil.processMainException(arguments, e);
        }
    }

    public CSSBuilder(String docrootDirName, boolean generateSourceMap, String outputDirName, String portalCommonPath, int precision, String[] rtlExcludedPathRegexps, String sassCompilerClassName) throws Exception {
        File portalCommonDir = new File(portalCommonPath);
        if (portalCommonDir.isFile()) {
            portalCommonDir = this._unzipPortalCommon(portalCommonDir);
            this._cleanPortalCommonDir = true;
        } else {
            this._cleanPortalCommonDir = false;
        }
        this._docrootDirName = docrootDirName;
        this._generateSourceMap = generateSourceMap;
        this._outputDirName = outputDirName;
        this._portalCommonDirName = portalCommonDir.getCanonicalPath();
        this._precision = precision;
        this._rtlExcludedPathPatterns = PatternFactory.compile(rtlExcludedPathRegexps);
        this._initSassCompiler(sassCompilerClassName);
    }

    @Override
    public void close() throws Exception {
        if (this._cleanPortalCommonDir) {
            this._deltree(this._portalCommonDirName);
        }
    }

    public void execute(List<String> dirNames) throws Exception {
        ArrayList<String> fileNames = new ArrayList<String>();
        for (String dirName : dirNames) {
            this._collectSassFiles(fileNames, dirName, this._docrootDirName);
        }
        for (String fileName : fileNames) {
            long startTime = System.currentTimeMillis();
            this._parseSassFile(fileName);
            System.out.println("Parsed " + fileName + " in " + (System.currentTimeMillis() - startTime) + "ms");
        }
    }

    public boolean isRtlExcludedPath(String filePath) {
        for (Pattern pattern : this._rtlExcludedPathPatterns) {
            Matcher matcher = pattern.matcher(filePath);
            if (!matcher.matches()) continue;
            return true;
        }
        return false;
    }

    private void _collectSassFiles(List<String> fileNames, String dirName, String docrootDirName) throws Exception {
        DirectoryScanner directoryScanner = new DirectoryScanner();
        String basedir = docrootDirName.concat(dirName);
        directoryScanner.setBasedir(basedir);
        directoryScanner.setExcludes(new String[]{"**\\_*.scss", "**\\_diffs\\**", "**\\.sass-cache*\\**", "**\\.sass_cache_*\\**", "**\\_sass_cache_*\\**", "**\\_styled\\**", "**\\_unstyled\\**", "**\\css\\aui\\**", "**\\tmp\\**"});
        directoryScanner.setIncludes(new String[]{"**\\*.scss"});
        directoryScanner.scan();
        String[] fileNamesArray = directoryScanner.getIncludedFiles();
        if (!this._isModified(basedir, fileNamesArray)) {
            return;
        }
        for (String fileName : fileNamesArray) {
            if (fileName.contains("_rtl")) continue;
            fileNames.add(this._normalizeFileName(dirName, fileName));
        }
    }

    private void _deltree(String dirName) throws IOException {
        Files.walkFileTree(Paths.get(dirName, new String[0]), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult postVisitDirectory(Path dirPath, IOException ioe) throws IOException {
                Files.delete(dirPath);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                Files.delete(path);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private String _getRtlCss(String fileName, String css) throws Exception {
        String rtlCss = css;
        try {
            if (_rtlCSSConverter == null) {
                _rtlCSSConverter = new RTLCSSConverter();
            }
            rtlCss = _rtlCSSConverter.process(rtlCss);
        }
        catch (Exception e) {
            System.out.println("Unable to generate RTL version for " + fileName + ", " + e.getMessage());
        }
        return rtlCss;
    }

    private void _initSassCompiler(String sassCompilerClassName) throws Exception {
        if (Validator.isNull(sassCompilerClassName) || sassCompilerClassName.equals("jni")) {
            try {
                System.setProperty("jna.nosys", Boolean.TRUE.toString());
                this._sassCompiler = new JniSassCompiler(this._precision);
                System.out.println("Using native Sass compiler");
            }
            catch (Throwable t) {
                System.out.println("Unable to load native compiler, falling back to Ruby");
                this._sassCompiler = new RubySassCompiler(this._precision);
            }
        } else {
            try {
                this._sassCompiler = new RubySassCompiler(this._precision);
                System.out.println("Using Ruby Sass compiler");
            }
            catch (Exception e) {
                System.out.println("Unable to load Ruby compiler, falling back to native");
                System.setProperty("jna.nosys", Boolean.TRUE.toString());
                this._sassCompiler = new JniSassCompiler(this._precision);
            }
        }
    }

    private boolean _isModified(String dirName, String[] fileNames) throws Exception {
        for (String fileName : fileNames) {
            if (fileName.contains("_rtl")) continue;
            fileName = this._normalizeFileName(dirName, fileName);
            File file = new File(fileName);
            File cacheFile = CSSBuilderUtil.getOutputFile(fileName, this._outputDirName);
            if (file.lastModified() == cacheFile.lastModified()) continue;
            return true;
        }
        return false;
    }

    private String _normalizeFileName(String dirName, String fileName) {
        fileName = StringUtil.replace(dirName + "/" + fileName, new String[]{"\\", "//"}, new String[]{"/", "/"});
        return fileName;
    }

    private String _parseSass(String fileName) throws SassCompilerException {
        String filePath;
        String cssBasePath = filePath = this._docrootDirName.concat(fileName);
        int pos = filePath.lastIndexOf("/css/");
        if (pos >= 0) {
            cssBasePath = filePath.substring(0, pos + 4);
        } else {
            pos = filePath.lastIndexOf("/resources/");
            if (pos >= 0) {
                cssBasePath = filePath.substring(0, pos + 10);
            }
        }
        String css = this._sassCompiler.compileFile(filePath, this._portalCommonDirName + File.pathSeparator + cssBasePath, this._generateSourceMap, filePath + ".map");
        return CSSBuilderUtil.parseStaticTokens(css);
    }

    private void _parseSassFile(String fileName) throws Exception {
        File file = new File(this._docrootDirName, fileName);
        if (!file.exists()) {
            return;
        }
        String ltrContent = this._parseSass(fileName);
        this._writeOutputFile(fileName, ltrContent, false);
        if (this.isRtlExcludedPath(fileName)) {
            return;
        }
        String rtlContent = this._getRtlCss(fileName, ltrContent);
        String rtlCustomFileName = CSSBuilderUtil.getRtlCustomFileName(fileName);
        File rtlCustomFile = new File(this._docrootDirName, rtlCustomFileName);
        if (rtlCustomFile.exists()) {
            rtlContent = rtlContent + this._parseSass(rtlCustomFileName);
        }
        this._writeOutputFile(fileName, rtlContent, true);
    }

    private File _unzipPortalCommon(File portalCommonFile) throws IOException {
        Path portalCommonCssDirPath = Files.createTempDirectory("portalCommonCss", new FileAttribute[0]);
        try (ZipFile zipFile = new ZipFile(portalCommonFile);){
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                String name = zipEntry.getName();
                if (name.endsWith("/") || !name.startsWith("META-INF/resources/")) continue;
                name = name.substring(19);
                Path path = portalCommonCssDirPath.resolve(name);
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                Files.copy(zipFile.getInputStream(zipEntry), path, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        return portalCommonCssDirPath.toFile();
    }

    private void _write(File file, String content) throws Exception {
        File parentFile = file.getParentFile();
        if (!parentFile.exists()) {
            parentFile.mkdirs();
        }
        Path path = Paths.get(file.toURI());
        Files.write(path, content.getBytes("UTF-8"), new OpenOption[0]);
    }

    private void _writeOutputFile(String fileName, String content, boolean rtl) throws Exception {
        String outputFileName;
        if (rtl) {
            String rtlFileName = CSSBuilderUtil.getRtlCustomFileName(fileName);
            outputFileName = CSSBuilderUtil.getOutputFileName(rtlFileName, this._outputDirName, "");
        } else {
            outputFileName = CSSBuilderUtil.getOutputFileName(fileName, this._outputDirName, "");
        }
        File outputFile = new File(this._docrootDirName, outputFileName);
        this._write(outputFile, content);
        File file = new File(this._docrootDirName, fileName);
        outputFile.setLastModified(file.lastModified());
    }
}

