/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.css.builder.sass;

import com.liferay.css.builder.CSSBuilder;
import com.liferay.css.builder.sass.SassFragment;
import com.liferay.rtl.css.RTLCSSConverter;

public class SassString
implements SassFragment {
    private static RTLCSSConverter _rtlCSSConverter;
    private final String _ltrContent;
    private final String _rtlContent;

    public SassString(CSSBuilder cssBuilder, String fileName, String cssContent) throws Exception {
        if (fileName.contains("_rtl")) {
            this._ltrContent = "";
            this._rtlContent = cssContent;
        } else {
            this._ltrContent = cssContent;
            this._rtlContent = !cssBuilder.isRtlExcludedPath(fileName) ? this._getRtlCss(fileName, cssContent) : null;
        }
    }

    @Override
    public String getLtrContent() {
        return this._ltrContent;
    }

    @Override
    public String getRtlContent() {
        return this._rtlContent;
    }

    private String _getRtlCss(String fileName, String css) throws Exception {
        String rtlCss = css;
        try {
            if (_rtlCSSConverter == null) {
                _rtlCSSConverter = new RTLCSSConverter();
            }
            rtlCss = _rtlCSSConverter.process(rtlCss);
        }
        catch (Exception e) {
            System.out.println("Unable to generate RTL version for " + fileName + ", " + e.getMessage());
        }
        return rtlCss;
    }
}

