/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.css.builder.sass;

import com.liferay.css.builder.CSSBuilder;
import com.liferay.css.builder.CSSBuilderUtil;
import com.liferay.css.builder.sass.SassFragment;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.util.AggregateUtil;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;

public class SassFile
implements SassFragment {
    private static final String _BASE_URL = "@base_url@";
    private final String _baseDir;
    private final CSSBuilder _cssBuilder;
    private final String _docrootDirName;
    private long _elapsedTime;
    private final String _fileName;
    private String _ltrContent;
    private String _rtlContent;
    private final List<SassFragment> _sassFragments = new ArrayList<SassFragment>();

    public SassFile(CSSBuilder cssBuilder, String docrootDirName, String fileName) {
        this._cssBuilder = cssBuilder;
        this._docrootDirName = docrootDirName;
        this._fileName = fileName;
        int pos = fileName.lastIndexOf(47);
        this._baseDir = pos != -1 ? fileName.substring(0, pos + 1) : "";
    }

    public void addSassFragment(SassFragment sassFragment) {
        this._sassFragments.add(sassFragment);
    }

    public String getBaseDir() {
        return this._baseDir;
    }

    public String getFileName() {
        return this._fileName;
    }

    @Override
    public String getLtrContent() {
        if (this._ltrContent != null) {
            return this._ltrContent;
        }
        StringBundler sb = new StringBundler(this._sassFragments.size());
        for (SassFragment sassFragment : this._sassFragments) {
            String ltrContent = sassFragment.getLtrContent();
            if (sassFragment instanceof SassFile) {
                SassFile sassFile = (SassFile)sassFragment;
                String baseURL = _BASE_URL.concat(sassFile._baseDir);
                ltrContent = AggregateUtil.updateRelativeURLs(ltrContent, baseURL);
            }
            sb.append(ltrContent);
        }
        this._ltrContent = sb.toString();
        return this._ltrContent;
    }

    @Override
    public String getRtlContent() {
        if (this._rtlContent != null) {
            return this._rtlContent;
        }
        StringBundler sb = new StringBundler(this._sassFragments.size());
        for (SassFragment sassFragment : this._sassFragments) {
            String rtlContent = sassFragment.getRtlContent();
            if (sassFragment instanceof SassFile) {
                SassFile sassFile = (SassFile)sassFragment;
                String baseURL = _BASE_URL.concat(sassFile._baseDir);
                rtlContent = AggregateUtil.updateRelativeURLs(rtlContent, baseURL);
            }
            sb.append(rtlContent);
        }
        this._rtlContent = sb.toString();
        return this._rtlContent;
    }

    public void setElapsedTime(long elapsedTime) {
        this._elapsedTime = elapsedTime;
    }

    public String toString() {
        StringBundler sb = new StringBundler(5);
        sb.append("Parsed ");
        sb.append(this._fileName);
        sb.append(" in ");
        sb.append(this._elapsedTime);
        sb.append("ms");
        return sb.toString();
    }

    public void writeCacheFiles() throws Exception {
        File ltrCacheFile = new File(this._docrootDirName, CSSBuilderUtil.getCacheFileName(this._fileName, ""));
        this._write(ltrCacheFile, this.getLtrContent());
        File ltrFile = new File(this._docrootDirName, this._fileName);
        ltrCacheFile.setLastModified(ltrFile.lastModified());
        String rtlFileName = CSSBuilderUtil.getRtlCustomFileName(this._fileName);
        if (this._cssBuilder.isRtlExcludedPath(this._fileName)) {
            return;
        }
        File rtlCacheFile = new File(this._docrootDirName, CSSBuilderUtil.getCacheFileName(rtlFileName, ""));
        this._write(rtlCacheFile, this.getRtlContent());
        rtlCacheFile.setLastModified(ltrFile.lastModified());
    }

    private void _write(File file, String content) throws Exception {
        File parentFile = file.getParentFile();
        if (!parentFile.exists()) {
            parentFile.mkdirs();
        }
        Path path = Paths.get(file.toURI());
        Files.write(path, content.getBytes("UTF-8"), new OpenOption[0]);
    }
}

