/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.css.builder;

import com.liferay.css.builder.CSSBuilderUtil;
import com.liferay.css.builder.sass.SassFile;
import com.liferay.css.builder.sass.SassFileWithMediaQuery;
import com.liferay.css.builder.sass.SassString;
import com.liferay.portal.kernel.regex.PatternFactory;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.ArgumentsUtil;
import com.liferay.sass.compiler.SassCompiler;
import com.liferay.sass.compiler.SassCompilerException;
import com.liferay.sass.compiler.jni.internal.JniSassCompiler;
import com.liferay.sass.compiler.ruby.internal.RubySassCompiler;
import java.io.File;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.DirectoryScanner;

public class CSSBuilder {
    private static final String _CSS_COMMENT_BEGIN = "/*";
    private static final String _CSS_COMMENT_END = "*/";
    private static final String _CSS_IMPORT_BEGIN = "@import url(";
    private static final String _CSS_IMPORT_END = ");";
    private final String _docrootDirName;
    private final boolean _generateSourceMap;
    private final String _portalCommonDirName;
    private final Pattern[] _rtlExcludedPathPatterns;
    private SassCompiler _sassCompiler;
    private final ConcurrentMap<String, SassFile> _sassFileCache = new ConcurrentHashMap<String, SassFile>();

    public static void main(String[] args) throws Exception {
        Map<String, String> arguments = ArgumentsUtil.parseArguments(args);
        ArrayList<String> dirNames = new ArrayList<String>();
        String dirName = GetterUtil.getString(arguments.get("sass.dir"), "/");
        if (Validator.isNotNull(dirName)) {
            dirNames.add(dirName);
        } else {
            int i = 0;
            while (Validator.isNotNull(dirName = arguments.get("sass.dir." + i))) {
                dirNames.add(dirName);
                ++i;
            }
        }
        String docrootDirName = GetterUtil.getString(arguments.get("sass.docroot.dir"), "src/META-INF/resources");
        boolean generateSourceMap = GetterUtil.getBoolean(arguments.get("sass.generate.source.map"));
        String portalCommonDirName = arguments.get("sass.portal.common.dir");
        String[] rtlExcludedPathRegexps = StringUtil.split(arguments.get("sass.rtl.excluded.path.regexps"));
        String sassCompilerClassName = arguments.get("sass.compiler.class.name");
        try {
            CSSBuilder cssBuilder = new CSSBuilder(docrootDirName, generateSourceMap, portalCommonDirName, rtlExcludedPathRegexps, sassCompilerClassName);
            cssBuilder.execute(dirNames);
        }
        catch (Exception e) {
            ArgumentsUtil.processMainException(arguments, e);
        }
    }

    public CSSBuilder(String docrootDirName, boolean generateSourceMap, String portalCommonDirName, String[] rtlExcludedPathRegexps, String sassCompilerClassName) throws Exception {
        this._docrootDirName = docrootDirName;
        this._generateSourceMap = generateSourceMap;
        this._portalCommonDirName = portalCommonDirName;
        this._rtlExcludedPathPatterns = PatternFactory.compile(rtlExcludedPathRegexps);
        this._initSassCompiler(sassCompilerClassName);
    }

    public void execute(List<String> dirNames) throws Exception {
        ArrayList<String> fileNames = new ArrayList<String>();
        for (String dirName : dirNames) {
            this._collectSassFiles(fileNames, dirName, this._docrootDirName);
        }
        for (String fileName : fileNames) {
            this._build(fileName);
        }
        for (SassFile sassFile : this._sassFileCache.values()) {
            sassFile.writeCacheFiles();
            System.out.println(sassFile);
        }
    }

    public boolean isRtlExcludedPath(String filePath) {
        for (Pattern pattern : this._rtlExcludedPathPatterns) {
            Matcher matcher = pattern.matcher(filePath);
            if (!matcher.matches()) continue;
            return true;
        }
        return false;
    }

    private void _addSassString(SassFile sassFile, String fileName, String sassContent) throws Exception {
        if ((sassContent = sassContent.trim()).isEmpty()) {
            return;
        }
        String cssContent = this._parseSass(fileName, CSSBuilderUtil.parseStaticTokens(sassContent));
        sassFile.addSassFragment(new SassString(this, fileName, cssContent));
    }

    private SassFile _build(String fileName) throws Exception {
        SassFile sassFile = (SassFile)this._sassFileCache.get(fileName);
        if (sassFile != null) {
            return sassFile;
        }
        sassFile = new SassFile(this, this._docrootDirName, fileName);
        SassFile previousSassFile = this._sassFileCache.putIfAbsent(fileName, sassFile);
        if (previousSassFile != null) {
            sassFile = previousSassFile;
        } else {
            this._parseSassFile(sassFile);
        }
        return sassFile;
    }

    private void _collectSassFiles(List<String> fileNames, String dirName, String docrootDirName) throws Exception {
        DirectoryScanner directoryScanner = new DirectoryScanner();
        String basedir = docrootDirName.concat(dirName);
        directoryScanner.setBasedir(basedir);
        directoryScanner.setExcludes(new String[]{"**\\_*.scss", "**\\_diffs\\**", "**\\.sass-cache*\\**", "**\\.sass_cache_*\\**", "**\\_sass_cache_*\\**", "**\\_styled\\**", "**\\_unstyled\\**", "**\\css\\aui\\**", "**\\tmp\\**"});
        directoryScanner.setIncludes(new String[]{"**\\*.css", "**\\*.scss"});
        directoryScanner.scan();
        String[] fileNamesArray = directoryScanner.getIncludedFiles();
        if (!this._isModified(basedir, fileNamesArray)) {
            return;
        }
        for (String fileName : fileNamesArray) {
            if (fileName.contains("_rtl")) continue;
            fileNames.add(this._normalizeFileName(dirName, fileName));
        }
    }

    private String _fixRelativePath(String fileName) {
        String[] paths = StringUtil.split(fileName, '/');
        StringBundler sb = new StringBundler(paths.length * 2);
        for (String path : paths) {
            if (path.isEmpty() || path.equals(".")) continue;
            if (path.equals("..") && sb.length() >= 2) {
                sb.setIndex(sb.index() - 2);
                continue;
            }
            sb.append("/");
            sb.append(path);
        }
        return sb.toString();
    }

    private void _initSassCompiler(String sassCompilerClassName) throws Exception {
        if (Validator.isNull(sassCompilerClassName) || sassCompilerClassName.equals("jni")) {
            try {
                System.setProperty("jna.nosys", Boolean.TRUE.toString());
                this._sassCompiler = new JniSassCompiler();
                System.out.println("Using native Sass compiler");
            }
            catch (Throwable t) {
                System.out.println("Unable to load native compiler, falling back to Ruby");
                this._sassCompiler = new RubySassCompiler();
            }
        } else {
            try {
                this._sassCompiler = new RubySassCompiler();
                System.out.println("Using Ruby Sass compiler");
            }
            catch (Exception e) {
                System.out.println("Unable to load Ruby compiler, falling back to native");
                System.setProperty("jna.nosys", Boolean.TRUE.toString());
                this._sassCompiler = new JniSassCompiler();
            }
        }
    }

    private boolean _isModified(String dirName, String[] fileNames) throws Exception {
        for (String fileName : fileNames) {
            if (fileName.contains("_rtl")) continue;
            fileName = this._normalizeFileName(dirName, fileName);
            File file = new File(fileName);
            File cacheFile = CSSBuilderUtil.getCacheFile(fileName);
            if (file.lastModified() == cacheFile.lastModified()) continue;
            return true;
        }
        return false;
    }

    private String _normalizeFileName(String dirName, String fileName) {
        return StringUtil.replace(dirName + "/" + fileName, new String[]{"\\", "//"}, new String[]{"/", "/"});
    }

    private String _parseSass(String fileName, String content) throws SassCompilerException {
        String filePath;
        String cssBasePath = filePath = this._docrootDirName.concat(fileName);
        int pos = filePath.lastIndexOf("/css/");
        if (pos >= 0) {
            cssBasePath = filePath.substring(0, pos + 4);
        } else {
            pos = filePath.lastIndexOf("/resources/");
            if (pos >= 0) {
                cssBasePath = filePath.substring(0, pos + 10);
            }
        }
        return this._sassCompiler.compileString(content, filePath, this._portalCommonDirName + File.pathSeparator + cssBasePath, this._generateSourceMap, filePath + ".map");
    }

    private void _parseSassFile(SassFile sassFile) throws Exception {
        String fileName = sassFile.getFileName();
        long start = System.currentTimeMillis();
        File file = new File(this._docrootDirName, fileName);
        if (!file.exists()) {
            return;
        }
        String content = this._read(file);
        int pos = 0;
        StringBundler sb = new StringBundler();
        while (true) {
            int commentX = content.indexOf(_CSS_COMMENT_BEGIN, pos);
            int commentY = content.indexOf(_CSS_COMMENT_END, commentX + _CSS_COMMENT_BEGIN.length());
            int importX = content.indexOf(_CSS_IMPORT_BEGIN, pos);
            int importY = content.indexOf(_CSS_IMPORT_END, importX + _CSS_IMPORT_BEGIN.length());
            if (importX == -1 || importY == -1) break;
            if (commentX != -1 && commentY != -1 && commentX < importX && commentY > importX) {
                sb.append(content.substring(pos, commentY += _CSS_COMMENT_END.length()));
                pos = commentY;
                continue;
            }
            sb.append(content.substring(pos, importX));
            String mediaQuery = "";
            int mediaQueryImportX = content.indexOf(41, importX + _CSS_IMPORT_BEGIN.length());
            int mediaQueryImportY = content.indexOf(59, importX + _CSS_IMPORT_BEGIN.length());
            String importFileName = null;
            if (importY != mediaQueryImportX) {
                mediaQuery = content.substring(mediaQueryImportX + 1, mediaQueryImportY);
                importFileName = content.substring(importX + _CSS_IMPORT_BEGIN.length(), mediaQueryImportX);
            } else {
                importFileName = content.substring(importX + _CSS_IMPORT_BEGIN.length(), importY);
            }
            if (!importFileName.isEmpty()) {
                if (importFileName.charAt(0) != '/') {
                    importFileName = this._fixRelativePath(sassFile.getBaseDir().concat(importFileName));
                }
                SassFile importSassFile = this._build(importFileName);
                if (Validator.isNotNull(mediaQuery)) {
                    sassFile.addSassFragment(new SassFileWithMediaQuery(importSassFile, mediaQuery));
                } else {
                    sassFile.addSassFragment(importSassFile);
                }
            }
            if (Validator.isNotNull(mediaQuery)) {
                pos = mediaQueryImportY + 1;
                continue;
            }
            pos = importY + _CSS_IMPORT_END.length();
        }
        sb.append(content.substring(pos));
        this._addSassString(sassFile, fileName, sb.toString());
        String rtlCustomFileName = CSSBuilderUtil.getRtlCustomFileName(fileName);
        File rtlCustomFile = new File(this._docrootDirName, rtlCustomFileName);
        if (rtlCustomFile.exists()) {
            this._addSassString(sassFile, rtlCustomFileName, this._read(rtlCustomFile));
        }
        sassFile.setElapsedTime(System.currentTimeMillis() - start);
    }

    private String _read(File file) throws Exception {
        String s = new String(Files.readAllBytes(file.toPath()), "UTF-8");
        return StringUtil.replace(s, "\r\n", "\n");
    }
}

