/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.theme.minium.full.site.initializer.internal.importer;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.commerce.account.model.CommerceAccount;
import com.liferay.commerce.account.service.CommerceAccountLocalService;
import com.liferay.commerce.machine.learning.recommendation.ProductContentCommerceMLRecommendation;
import com.liferay.commerce.machine.learning.recommendation.ProductContentCommerceMLRecommendationManager;
import com.liferay.commerce.machine.learning.recommendation.ProductInteractionCommerceMLRecommendation;
import com.liferay.commerce.machine.learning.recommendation.ProductInteractionCommerceMLRecommendationManager;
import com.liferay.commerce.machine.learning.recommendation.UserCommerceMLRecommendation;
import com.liferay.commerce.machine.learning.recommendation.UserCommerceMLRecommendationManager;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.service.CPDefinitionLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import java.util.Date;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, service={CommerceMLRecommendationImporter.class})
public class CommerceMLRecommendationImporter {
    private static final Log _log = LogFactoryUtil.getLog(CommerceMLRecommendationImporter.class);
    @Reference
    private AssetEntryLocalService _assetEntryLocalService;
    @Reference
    private CommerceAccountLocalService _commerceAccountLocalService;
    @Reference
    private CPDefinitionLocalService _cpDefinitionLocalService;
    @Reference
    private ProductContentCommerceMLRecommendationManager _productContentCommerceMLRecommendationManager;
    @Reference
    private ProductInteractionCommerceMLRecommendationManager _productInteractionCommerceMLRecommendationManager;
    @Reference
    private UserCommerceMLRecommendationManager _userCommerceMLRecommendationManager;
    @Reference
    private UserLocalService _userLocalService;

    public void importCommerceMLRecommendations(JSONArray jsonArray, String externalReferenceCodePrefix, long scopeGroupId, long userId) throws PortalException {
        ServiceContext serviceContext = new ServiceContext();
        User user = this._userLocalService.getUser(userId);
        serviceContext.setCompanyId(user.getCompanyId());
        serviceContext.setScopeGroupId(scopeGroupId);
        serviceContext.setUserId(userId);
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            String type = jsonObject.getString("type");
            try {
                if (type.equals("product-content-recommendation")) {
                    this._importProductContentCommerceMLRecommendation(jsonObject, externalReferenceCodePrefix, serviceContext);
                    continue;
                }
                if (type.equals("product-interaction-recommendation")) {
                    this._importProductInteractionCommerceMLRecommendation(jsonObject, externalReferenceCodePrefix, serviceContext);
                    continue;
                }
                this._importUserCommerceMLRecommendation(jsonObject, externalReferenceCodePrefix, serviceContext);
                continue;
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)String.format("Unable to import recommendation type: %s", type), (Throwable)exception);
            }
        }
    }

    private void _importProductContentCommerceMLRecommendation(JSONObject jsonObject, String externalReferenceCodePrefix, ServiceContext serviceContext) throws PortalException {
        String productExternalReferenceCode = externalReferenceCodePrefix + jsonObject.getString("productExternalReferenceCode");
        CPDefinition cpDefinition = this._cpDefinitionLocalService.fetchCPDefinitionByCProductExternalReferenceCode(productExternalReferenceCode, serviceContext.getCompanyId());
        if (cpDefinition == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)String.format("Unable to fetch commerce product definition with external reference code: %s", productExternalReferenceCode));
            }
            return;
        }
        String recommendedProductExternalReferenceCode = externalReferenceCodePrefix + jsonObject.getString("recommendedProductExternalReferenceCode");
        CPDefinition recommendedCPDefinition = this._cpDefinitionLocalService.fetchCPDefinitionByCProductExternalReferenceCode(recommendedProductExternalReferenceCode, serviceContext.getCompanyId());
        if (recommendedCPDefinition == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)String.format("Unable to fetch commerce product definition with external reference code: %s", recommendedProductExternalReferenceCode));
            }
            return;
        }
        ProductContentCommerceMLRecommendation productContentCommerceMLRecommendation = this._productContentCommerceMLRecommendationManager.create();
        productContentCommerceMLRecommendation.setCompanyId(serviceContext.getCompanyId());
        productContentCommerceMLRecommendation.setCreateDate(new Date());
        productContentCommerceMLRecommendation.setEntryClassPK(cpDefinition.getCPDefinitionId());
        productContentCommerceMLRecommendation.setJobId("commerce-ml-recommendation-importer");
        productContentCommerceMLRecommendation.setRank(jsonObject.getInt("rank"));
        productContentCommerceMLRecommendation.setRecommendedEntryClassPK(recommendedCPDefinition.getCPDefinitionId());
        productContentCommerceMLRecommendation.setScore((float)jsonObject.getDouble("score"));
        this._productContentCommerceMLRecommendationManager.addProductContentCommerceMLRecommendation(productContentCommerceMLRecommendation);
    }

    private void _importProductInteractionCommerceMLRecommendation(JSONObject jsonObject, String externalReferenceCodePrefix, ServiceContext serviceContext) throws PortalException {
        String productExternalReferenceCode = externalReferenceCodePrefix + jsonObject.getString("productExternalReferenceCode");
        CPDefinition cpDefinition = this._cpDefinitionLocalService.fetchCPDefinitionByCProductExternalReferenceCode(productExternalReferenceCode, serviceContext.getCompanyId());
        if (cpDefinition == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)String.format("Unable to fetch commerce product definition with external reference code: %s", productExternalReferenceCode));
            }
            return;
        }
        String recommendedProductExternalReferenceCode = externalReferenceCodePrefix + jsonObject.getString("recommendedProductExternalReferenceCode");
        CPDefinition recommendedCPDefinition = this._cpDefinitionLocalService.fetchCPDefinitionByCProductExternalReferenceCode(recommendedProductExternalReferenceCode, serviceContext.getCompanyId());
        if (recommendedCPDefinition == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)String.format("Unable to fetch commerce product definition with external reference code: %s", recommendedProductExternalReferenceCode));
            }
            return;
        }
        ProductInteractionCommerceMLRecommendation productInteractionCommerceMLRecommendation = this._productInteractionCommerceMLRecommendationManager.create();
        productInteractionCommerceMLRecommendation.setCompanyId(serviceContext.getCompanyId());
        productInteractionCommerceMLRecommendation.setCreateDate(new Date());
        productInteractionCommerceMLRecommendation.setEntryClassPK(cpDefinition.getCPDefinitionId());
        productInteractionCommerceMLRecommendation.setJobId("commerce-ml-recommendation-importer");
        productInteractionCommerceMLRecommendation.setRank(jsonObject.getInt("rank"));
        productInteractionCommerceMLRecommendation.setRecommendedEntryClassPK(recommendedCPDefinition.getCPDefinitionId());
        productInteractionCommerceMLRecommendation.setScore((float)jsonObject.getDouble("score"));
        this._productInteractionCommerceMLRecommendationManager.addProductInteractionCommerceMLRecommendation(productInteractionCommerceMLRecommendation);
    }

    private void _importUserCommerceMLRecommendation(JSONObject jsonObject, String externalReferenceCodePrefix, ServiceContext serviceContext) throws PortalException {
        String accountExternalReferenceCode = jsonObject.getString("accountExternalReferenceCode");
        CommerceAccount commerceAccount = this._commerceAccountLocalService.fetchByExternalReferenceCode(serviceContext.getCompanyId(), accountExternalReferenceCode);
        if (commerceAccount == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)String.format("Unable to fetch account with external reference code: %s", accountExternalReferenceCode));
            }
            return;
        }
        String recommendedProductExternalReferenceCode = externalReferenceCodePrefix + jsonObject.getString("recommendedProductExternalReferenceCode");
        CPDefinition recommendedCPDefinition = this._cpDefinitionLocalService.fetchCPDefinitionByCProductExternalReferenceCode(recommendedProductExternalReferenceCode, serviceContext.getCompanyId());
        if (recommendedCPDefinition == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)String.format("Unable to fetch commerce product definition with external reference code: %s", recommendedProductExternalReferenceCode));
            }
            return;
        }
        AssetEntry assetEntry = this._assetEntryLocalService.getEntry(CPDefinition.class.getName(), recommendedCPDefinition.getCPDefinitionId());
        long[] categoryIds = assetEntry.getCategoryIds();
        UserCommerceMLRecommendation userCommerceMLRecommendation = this._userCommerceMLRecommendationManager.create();
        userCommerceMLRecommendation.setAssetCategoryIds(categoryIds);
        userCommerceMLRecommendation.setCompanyId(serviceContext.getCompanyId());
        userCommerceMLRecommendation.setCreateDate(new Date());
        userCommerceMLRecommendation.setEntryClassPK(commerceAccount.getCommerceAccountId());
        userCommerceMLRecommendation.setJobId("commerce-ml-recommendation-importer");
        userCommerceMLRecommendation.setRecommendedEntryClassPK(recommendedCPDefinition.getCPDefinitionId());
        userCommerceMLRecommendation.setScore((float)jsonObject.getDouble("score"));
        this._userCommerceMLRecommendationManager.addUserCommerceMLRecommendation(userCommerceMLRecommendation);
    }
}

