/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.theme.minium.full.site.initializer.internal;

import com.liferay.commerce.theme.minium.SiteInitializerDependencyResolver;
import com.liferay.commerce.theme.minium.SiteInitializerDependencyResolverThreadLocal;
import com.liferay.commerce.theme.minium.full.site.initializer.internal.importer.CommerceMLForecastImporter;
import com.liferay.commerce.theme.minium.full.site.initializer.internal.importer.CommerceMLRecommendationImporter;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.service.DLFileEntryLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.site.exception.InitializationException;
import com.liferay.site.initializer.SiteInitializer;
import java.util.List;
import java.util.Locale;
import javax.servlet.ServletContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, immediate=true, property={"site.initializer.key=minium-full-initializer"}, service={SiteInitializer.class})
public class MiniumFullSiteInitializer
implements SiteInitializer {
    public static final String KEY = "minium-full-initializer";
    private static final Log _log = LogFactoryUtil.getLog(MiniumFullSiteInitializer.class);
    @Reference
    private CommerceMLForecastImporter _commerceMLForecastImporter;
    @Reference
    private CommerceMLRecommendationImporter _commerceMLRecommendationImporter;
    @Reference
    private DLFileEntryLocalService _dlFileEntryLocalService;
    @Reference(target="(site.initializer.key=minium-full-initializer)")
    private SiteInitializerDependencyResolver _fullSiteInitializerDependencyResolver;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private ResourcePermissionLocalService _resourcePermissionLocalService;
    @Reference
    private RoleLocalService _roleLocalService;
    @Reference(target="(osgi.web.symbolicname=com.liferay.commerce.theme.minium.full.site.initializer)")
    private ServletContext _servletContext;
    @Reference(target="(site.initializer.key=minium-initializer)")
    private SiteInitializer _siteInitializer;
    @Reference
    private UserLocalService _userLocalService;

    public String getDescription(Locale locale) {
        return this._siteInitializer.getDescription(locale);
    }

    public String getKey() {
        return KEY;
    }

    public String getName(Locale locale) {
        return "Minium Demo";
    }

    public String getThumbnailSrc() {
        return this._servletContext.getContextPath() + "/images/thumbnail.png";
    }

    public void initialize(long groupId) throws InitializationException {
        try {
            SiteInitializerDependencyResolverThreadLocal.setSiteInitializerDependencyResolver((SiteInitializerDependencyResolver)this._fullSiteInitializerDependencyResolver);
            this._siteInitializer.initialize(groupId);
            this._importCommerceMLForecasts(groupId);
            this._importCommerceMLRecommendations(groupId);
            this.fixDLFileEntryPermissions(groupId);
        }
        catch (InitializationException initializationException) {
            throw initializationException;
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
            throw new InitializationException((Throwable)exception);
        }
        finally {
            SiteInitializerDependencyResolverThreadLocal.removeSiteInitializerDependencyResolver();
        }
    }

    public boolean isActive(long companyId) {
        return this._siteInitializer.isActive(companyId);
    }

    protected void fixDLFileEntryPermissions(long groupId) throws PortalException {
        List dlFileEntries = this._dlFileEntryLocalService.getFileEntries(groupId, 0L);
        if (dlFileEntries.isEmpty()) {
            return;
        }
        Group group = this._groupLocalService.getGroup(groupId);
        long companyId = group.getCompanyId();
        for (DLFileEntry dlFileEntry : dlFileEntries) {
            Role role = this._roleLocalService.getRole(companyId, "Site Member");
            this._resourcePermissionLocalService.setResourcePermissions(companyId, dlFileEntry.getModelClassName(), 4, String.valueOf(dlFileEntry.getPrimaryKey()), role.getRoleId(), new String[]{"VIEW"});
        }
    }

    private JSONArray _getJSONArray(String name) throws Exception {
        return this._jsonFactory.createJSONArray(this._fullSiteInitializerDependencyResolver.getJSON(name));
    }

    private void _importCommerceMLForecasts(long groupId) throws Exception {
        JSONArray jsonArray = this._getJSONArray("forecasts.json");
        User user = this._userLocalService.getUser(PrincipalThreadLocal.getUserId());
        this._commerceMLForecastImporter.importCommerceMLForecasts(jsonArray, groupId, user.getUserId());
    }

    private void _importCommerceMLRecommendations(long groupId) throws Exception {
        JSONArray jsonArray = this._getJSONArray("recommendations.json");
        User user = this._userLocalService.getUser(PrincipalThreadLocal.getUserId());
        this._commerceMLRecommendationImporter.importCommerceMLRecommendations(jsonArray, "MIN", groupId, user.getUserId());
    }
}

