/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.punchout.helper;

import com.liferay.commerce.account.model.CommerceAccountUserRel;
import com.liferay.commerce.account.service.CommerceAccountUserRelLocalService;
import com.liferay.commerce.punchout.service.PunchOutAccountRoleHelper;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroupRole;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, immediate=true, service={PunchOutAccountRoleHelper.class})
public class PunchOutAccountRoleHelperImpl
implements PunchOutAccountRoleHelper {
    @Reference
    private CommerceAccountUserRelLocalService _commerceAccountUserRelLocalService;
    @Reference
    private RoleLocalService _roleLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public boolean hasPunchOutRole(long userId, long commerceAccountId) throws PortalException {
        List commerceAccountUserRels = this._commerceAccountUserRelLocalService.getCommerceAccountUserRels(commerceAccountId);
        if (commerceAccountUserRels.isEmpty()) {
            return false;
        }
        User user = this._userLocalService.fetchUser(userId);
        if (user == null) {
            return false;
        }
        Role punchOutRole = this._roleLocalService.fetchRole(user.getCompanyId(), "Punch Out");
        if (punchOutRole == null) {
            return false;
        }
        for (CommerceAccountUserRel commerceAccountUserRel : commerceAccountUserRels) {
            List userGroupRoles = commerceAccountUserRel.getUserGroupRoles();
            for (UserGroupRole userGroupRole : userGroupRoles) {
                Role role = userGroupRole.getRole();
                if (userGroupRole.getUserId() != userId || role.getRoleId() != punchOutRole.getRoleId()) continue;
                return true;
            }
        }
        return false;
    }
}

