/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.punchout.helper;

import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.commerce.currency.model.CommerceCurrency;
import com.liferay.commerce.model.CommerceAddress;
import com.liferay.commerce.model.CommerceCountry;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.model.CommerceRegion;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.service.CPInstanceLocalService;
import com.liferay.commerce.punchout.service.PunchOutReturnService;
import com.liferay.commerce.service.CommerceAddressLocalService;
import com.liferay.commerce.service.CommerceCountryLocalService;
import com.liferay.commerce.service.CommerceRegionLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, immediate=true, property={"service.ranking:Integer=100"}, service={PunchOutReturnService.class})
public class PunchOut2GoReturnServiceImpl
implements PunchOutReturnService {
    private static final Log _log = LogFactoryUtil.getLog(PunchOut2GoReturnServiceImpl.class);
    private static final DateFormat _dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    @Reference
    private AssetEntryLocalService _assetEntryLocalService;
    @Reference
    private CommerceAddressLocalService _commerceAddressLocalService;
    @Reference
    private CommerceCountryLocalService _commerceCountryLocalService;
    @Reference
    private CommerceRegionLocalService _commerceRegionLocalService;
    @Reference
    private CPInstanceLocalService _cpInstanceLocalService;
    @Reference
    private JSONFactory _jsonFactory;

    public String returnToPunchOutVendor(CommerceOrder commerceOrder, String url) throws Exception {
        try {
            JSONObject cartJSONObject = this._jsonFactory.createJSONObject();
            cartJSONObject.put("contract_id", "").put("discount", (Object)commerceOrder.getTotalDiscountAmount()).put("discount_description", "").put("quote_id", "").put("shipping", (Object)commerceOrder.getShippingAmount()).put("shipping_description", commerceOrder.getShippingOptionName()).put("tax", (Object)commerceOrder.getTaxAmount()).put("tax_description", "").put("total", (Object)commerceOrder.getTotal());
            CommerceCurrency commerceCurrency = commerceOrder.getCommerceCurrency();
            cartJSONObject.put("currencyCode", commerceCurrency.getCode());
            JSONArray cartItemJSONArray = this._jsonFactory.createJSONArray();
            for (CommerceOrderItem commerceOrderItem : commerceOrder.getCommerceOrderItems()) {
                JSONObject cartItemJSONObject = this._jsonFactory.createJSONObject();
                cartItemJSONObject.put("skuid", commerceOrderItem.getCPInstanceId()).put("supplierauxid", commerceOrder.getCommerceOrderId() + "/" + commerceOrderItem.getCommerceOrderItemId()).put("supplierid", commerceOrderItem.getSku());
                CPDefinition cpDefinition = commerceOrderItem.getCPDefinition();
                cartItemJSONObject.put("description", cpDefinition.getDescription());
                StringBundler assetCategorySB = new StringBundler();
                AssetEntry assetEntry = this._assetEntryLocalService.getEntry(CPDefinition.class.getName(), cpDefinition.getCPDefinitionId());
                for (AssetCategory assetCategory : assetEntry.getCategories()) {
                    assetCategorySB.append(assetCategory.getName());
                    assetCategorySB.append(",");
                }
                cartItemJSONObject.put("classification", assetCategorySB.toString()).put("commercePriceListId", commerceOrderItem.getCommercePriceListId()).put("deliveryGroup", commerceOrderItem.getDeliveryGroup()).put("discountAmount", (Object)commerceOrderItem.getDiscountAmount()).put("externalReferenceCode", commerceOrderItem.getExternalReferenceCode()).put("finalPrice", (Object)commerceOrderItem.getFinalPrice()).put("parentCommerceOrderItemId", commerceOrderItem.getParentCommerceOrderItemId()).put("printedNote", commerceOrderItem.getPrintedNote()).put("promoPrice", (Object)commerceOrderItem.getPromoPrice()).put("quantity", commerceOrderItem.getQuantity()).put("shippedQuantity", commerceOrderItem.getShippedQuantity()).put("unitprice", (Object)commerceOrderItem.getUnitPrice()).put("uom", "EA");
                JSONObject shippingAddressJSONObject = this._buildShippingAddressJSONObject(commerceOrderItem.getShippingAddressId());
                cartItemJSONObject.put("shippingAddress", shippingAddressJSONObject);
                CPInstance cpInstance = this._cpInstanceLocalService.fetchCPInstance(commerceOrderItem.getCPInstanceId());
                cartItemJSONObject.put("unspsc", cpInstance.getUnspsc());
                String formattedCreateDate = this._getDateString(commerceOrderItem.getCreateDate());
                cartItemJSONObject.put("createDate", formattedCreateDate);
                String formattedModifiedDate = this._getDateString(commerceOrderItem.getModifiedDate());
                cartItemJSONObject.put("modifiedDate", formattedModifiedDate);
                String formattedRequestedDeliveryDate = this._getDateString(commerceOrderItem.getRequestedDeliveryDate());
                cartItemJSONObject.put("requestedDeliveryDate", formattedRequestedDeliveryDate);
                cartItemJSONArray.put(cartItemJSONObject);
            }
            cartJSONObject.put("items", cartItemJSONArray);
            String cartJSON = cartJSONObject.toString();
            if (_log.isDebugEnabled()) {
                String stringBundler = StringBundler.concat((String[])new String[]{"PunchOut2Go cart transfer request to ", url, "; cart JSON: ", cartJSON});
                _log.debug((Object)stringBundler);
            }
            URL urlObj = new URL(url);
            HttpURLConnection httpURLConnection = (HttpURLConnection)urlObj.openConnection();
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setRequestProperty("Content-type", "application/json");
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(httpURLConnection.getOutputStream());
            outputStreamWriter.write(cartJSON);
            outputStreamWriter.flush();
            int responseCode = httpURLConnection.getResponseCode();
            if (responseCode == 200) {
                String response = StringUtil.toLowerCase((String)StringUtil.read((InputStream)httpURLConnection.getInputStream()));
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("JSON response received from PunchOut2Go: " + response));
                }
                JSONArray jsonArray = this._jsonFactory.createJSONArray("[" + response + "]");
                JSONObject jsonObject = jsonArray.getJSONObject(0);
                return jsonObject.getString("redirecturl");
            }
            _log.error((Object)("PunchOut2Go cart transfer response code: " + responseCode));
            return null;
        }
        catch (Exception exception) {
            _log.error((Object)"PunchOut2Go cart transfer failed", (Throwable)exception);
            throw exception;
        }
    }

    private JSONObject _buildCountryJSONObject(long commerceCountryId) {
        JSONObject countryJSONObject = this._jsonFactory.createJSONObject();
        countryJSONObject.put("id", commerceCountryId);
        if (commerceCountryId < 1L) {
            return countryJSONObject;
        }
        CommerceCountry commerceCountry = this._commerceCountryLocalService.fetchCommerceCountry(commerceCountryId);
        if (commerceCountry == null) {
            return countryJSONObject;
        }
        countryJSONObject.put("name", commerceCountry.getName()).put("numericISOCode", commerceCountry.getNumericISOCode()).put("threeLettersISOCode", commerceCountry.getThreeLettersISOCode()).put("twoLettersISOCode", commerceCountry.getTwoLettersISOCode());
        return countryJSONObject;
    }

    private JSONObject _buildRegionJSONObject(long commerceRegionId) {
        JSONObject regionJSONObject = this._jsonFactory.createJSONObject();
        regionJSONObject.put("id", commerceRegionId);
        if (commerceRegionId < 1L) {
            return regionJSONObject;
        }
        CommerceRegion commerceRegion = this._commerceRegionLocalService.fetchCommerceRegion(commerceRegionId);
        if (commerceRegion == null) {
            return regionJSONObject;
        }
        regionJSONObject.put("code", commerceRegion.getCode()).put("name", commerceRegion.getName());
        return regionJSONObject;
    }

    private JSONObject _buildShippingAddressJSONObject(long shippingAddressId) {
        JSONObject shippingAddressJSONObject = this._jsonFactory.createJSONObject();
        shippingAddressJSONObject.put("shippingAddressId", shippingAddressId);
        if (shippingAddressId < 1L) {
            return shippingAddressJSONObject;
        }
        CommerceAddress shippingAddress = this._commerceAddressLocalService.fetchCommerceAddress(shippingAddressId);
        if (shippingAddress == null) {
            return shippingAddressJSONObject;
        }
        shippingAddressJSONObject.put("city", shippingAddress.getCity()).put("externalReferenceCode", shippingAddress.getExternalReferenceCode()).put("name", shippingAddress.getName()).put("street1", shippingAddress.getStreet1()).put("street2", shippingAddress.getStreet2()).put("street3", shippingAddress.getStreet3());
        JSONObject regionJSONObject = this._buildRegionJSONObject(shippingAddress.getCommerceRegionId());
        shippingAddressJSONObject.put("region", regionJSONObject).put("zip", shippingAddress.getZip());
        JSONObject countryJSONObject = this._buildCountryJSONObject(shippingAddress.getCommerceCountryId());
        shippingAddressJSONObject.put("companyId", shippingAddress.getCompanyId()).put("country", countryJSONObject).put("description", shippingAddress.getDescription()).put("groupId", shippingAddress.getGroupId()).put("isDefaultBilling", shippingAddress.isDefaultBilling()).put("isDefaultShipping", shippingAddress.isDefaultShipping()).put("isGeolocated", shippingAddress.isGeolocated()).put("latitude", shippingAddress.getLatitude()).put("longitude", shippingAddress.getLongitude()).put("phoneNumber", shippingAddress.getPhoneNumber()).put("type", shippingAddress.getType());
        String formattedCreateDate = this._getDateString(shippingAddress.getCreateDate());
        shippingAddressJSONObject.put("createDate", formattedCreateDate);
        String formattedModifiedDate = this._getDateString(shippingAddress.getModifiedDate());
        shippingAddressJSONObject.put("modifiedDate", formattedModifiedDate);
        return shippingAddressJSONObject;
    }

    private String _getDateString(Date date) {
        if (date == null) {
            return "";
        }
        return _dateFormat.format(date);
    }
}

