/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.client.extension.model.impl;

import com.liferay.client.extension.model.ClientExtensionEntryRel;
import com.liferay.client.extension.model.ClientExtensionEntryRelModel;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;

import java.io.Serializable;

import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the ClientExtensionEntryRel service. Represents a row in the &quot;ClientExtensionEntryRel&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>ClientExtensionEntryRelModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link ClientExtensionEntryRelImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see ClientExtensionEntryRelImpl
 * @generated
 */
public class ClientExtensionEntryRelModelImpl
	extends BaseModelImpl<ClientExtensionEntryRel>
	implements ClientExtensionEntryRelModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a client extension entry rel model instance should use the <code>ClientExtensionEntryRel</code> interface instead.
	 */
	public static final String TABLE_NAME = "ClientExtensionEntryRel";

	public static final Object[][] TABLE_COLUMNS = {
		{"mvccVersion", Types.BIGINT}, {"uuid_", Types.VARCHAR},
		{"externalReferenceCode", Types.VARCHAR},
		{"clientExtensionEntryRelId", Types.BIGINT},
		{"companyId", Types.BIGINT}, {"userId", Types.BIGINT},
		{"userName", Types.VARCHAR}, {"createDate", Types.TIMESTAMP},
		{"modifiedDate", Types.TIMESTAMP}, {"classNameId", Types.BIGINT},
		{"classPK", Types.BIGINT}, {"cetExternalReferenceCode", Types.VARCHAR},
		{"type_", Types.VARCHAR}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("mvccVersion", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("uuid_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("externalReferenceCode", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("clientExtensionEntryRelId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("classNameId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("classPK", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("cetExternalReferenceCode", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("type_", Types.VARCHAR);
	}

	public static final String TABLE_SQL_CREATE =
		"create table ClientExtensionEntryRel (mvccVersion LONG default 0 not null,uuid_ VARCHAR(75) null,externalReferenceCode VARCHAR(75) null,clientExtensionEntryRelId LONG not null primary key,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,classNameId LONG,classPK LONG,cetExternalReferenceCode VARCHAR(75) null,type_ VARCHAR(75) null)";

	public static final String TABLE_SQL_DROP =
		"drop table ClientExtensionEntryRel";

	public static final String ORDER_BY_JPQL =
		" ORDER BY clientExtensionEntryRel.clientExtensionEntryRelId ASC";

	public static final String ORDER_BY_SQL =
		" ORDER BY ClientExtensionEntryRel.clientExtensionEntryRelId ASC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long CLASSNAMEID_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long CLASSPK_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long COMPANYID_COLUMN_BITMASK = 4L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long EXTERNALREFERENCECODE_COLUMN_BITMASK = 8L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long TYPE_COLUMN_BITMASK = 16L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long UUID_COLUMN_BITMASK = 32L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *		#getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long CLIENTEXTENSIONENTRYRELID_COLUMN_BITMASK = 64L;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setEntityCacheEnabled(boolean entityCacheEnabled) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setFinderCacheEnabled(boolean finderCacheEnabled) {
	}

	public ClientExtensionEntryRelModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _clientExtensionEntryRelId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setClientExtensionEntryRelId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _clientExtensionEntryRelId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return ClientExtensionEntryRel.class;
	}

	@Override
	public String getModelClassName() {
		return ClientExtensionEntryRel.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<ClientExtensionEntryRel, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		for (Map.Entry<String, Function<ClientExtensionEntryRel, Object>>
				entry : attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<ClientExtensionEntryRel, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply((ClientExtensionEntryRel)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<ClientExtensionEntryRel, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<ClientExtensionEntryRel, Object>
				attributeSetterBiConsumer = attributeSetterBiConsumers.get(
					attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(ClientExtensionEntryRel)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<ClientExtensionEntryRel, Object>>
		getAttributeGetterFunctions() {

		return _attributeGetterFunctions;
	}

	public Map<String, BiConsumer<ClientExtensionEntryRel, Object>>
		getAttributeSetterBiConsumers() {

		return _attributeSetterBiConsumers;
	}

	private static final Map<String, Function<ClientExtensionEntryRel, Object>>
		_attributeGetterFunctions;
	private static final Map
		<String, BiConsumer<ClientExtensionEntryRel, Object>>
			_attributeSetterBiConsumers;

	static {
		Map<String, Function<ClientExtensionEntryRel, Object>>
			attributeGetterFunctions =
				new LinkedHashMap
					<String, Function<ClientExtensionEntryRel, Object>>();
		Map<String, BiConsumer<ClientExtensionEntryRel, ?>>
			attributeSetterBiConsumers =
				new LinkedHashMap
					<String, BiConsumer<ClientExtensionEntryRel, ?>>();

		attributeGetterFunctions.put(
			"mvccVersion", ClientExtensionEntryRel::getMvccVersion);
		attributeSetterBiConsumers.put(
			"mvccVersion",
			(BiConsumer<ClientExtensionEntryRel, Long>)
				ClientExtensionEntryRel::setMvccVersion);
		attributeGetterFunctions.put("uuid", ClientExtensionEntryRel::getUuid);
		attributeSetterBiConsumers.put(
			"uuid",
			(BiConsumer<ClientExtensionEntryRel, String>)
				ClientExtensionEntryRel::setUuid);
		attributeGetterFunctions.put(
			"externalReferenceCode",
			ClientExtensionEntryRel::getExternalReferenceCode);
		attributeSetterBiConsumers.put(
			"externalReferenceCode",
			(BiConsumer<ClientExtensionEntryRel, String>)
				ClientExtensionEntryRel::setExternalReferenceCode);
		attributeGetterFunctions.put(
			"clientExtensionEntryRelId",
			ClientExtensionEntryRel::getClientExtensionEntryRelId);
		attributeSetterBiConsumers.put(
			"clientExtensionEntryRelId",
			(BiConsumer<ClientExtensionEntryRel, Long>)
				ClientExtensionEntryRel::setClientExtensionEntryRelId);
		attributeGetterFunctions.put(
			"companyId", ClientExtensionEntryRel::getCompanyId);
		attributeSetterBiConsumers.put(
			"companyId",
			(BiConsumer<ClientExtensionEntryRel, Long>)
				ClientExtensionEntryRel::setCompanyId);
		attributeGetterFunctions.put(
			"userId", ClientExtensionEntryRel::getUserId);
		attributeSetterBiConsumers.put(
			"userId",
			(BiConsumer<ClientExtensionEntryRel, Long>)
				ClientExtensionEntryRel::setUserId);
		attributeGetterFunctions.put(
			"userName", ClientExtensionEntryRel::getUserName);
		attributeSetterBiConsumers.put(
			"userName",
			(BiConsumer<ClientExtensionEntryRel, String>)
				ClientExtensionEntryRel::setUserName);
		attributeGetterFunctions.put(
			"createDate", ClientExtensionEntryRel::getCreateDate);
		attributeSetterBiConsumers.put(
			"createDate",
			(BiConsumer<ClientExtensionEntryRel, Date>)
				ClientExtensionEntryRel::setCreateDate);
		attributeGetterFunctions.put(
			"modifiedDate", ClientExtensionEntryRel::getModifiedDate);
		attributeSetterBiConsumers.put(
			"modifiedDate",
			(BiConsumer<ClientExtensionEntryRel, Date>)
				ClientExtensionEntryRel::setModifiedDate);
		attributeGetterFunctions.put(
			"classNameId", ClientExtensionEntryRel::getClassNameId);
		attributeSetterBiConsumers.put(
			"classNameId",
			(BiConsumer<ClientExtensionEntryRel, Long>)
				ClientExtensionEntryRel::setClassNameId);
		attributeGetterFunctions.put(
			"classPK", ClientExtensionEntryRel::getClassPK);
		attributeSetterBiConsumers.put(
			"classPK",
			(BiConsumer<ClientExtensionEntryRel, Long>)
				ClientExtensionEntryRel::setClassPK);
		attributeGetterFunctions.put(
			"cetExternalReferenceCode",
			ClientExtensionEntryRel::getCETExternalReferenceCode);
		attributeSetterBiConsumers.put(
			"cetExternalReferenceCode",
			(BiConsumer<ClientExtensionEntryRel, String>)
				ClientExtensionEntryRel::setCETExternalReferenceCode);
		attributeGetterFunctions.put("type", ClientExtensionEntryRel::getType);
		attributeSetterBiConsumers.put(
			"type",
			(BiConsumer<ClientExtensionEntryRel, String>)
				ClientExtensionEntryRel::setType);

		_attributeGetterFunctions = Collections.unmodifiableMap(
			attributeGetterFunctions);
		_attributeSetterBiConsumers = Collections.unmodifiableMap(
			(Map)attributeSetterBiConsumers);
	}

	@Override
	public long getMvccVersion() {
		return _mvccVersion;
	}

	@Override
	public void setMvccVersion(long mvccVersion) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_mvccVersion = mvccVersion;
	}

	@Override
	public String getUuid() {
		if (_uuid == null) {
			return "";
		}
		else {
			return _uuid;
		}
	}

	@Override
	public void setUuid(String uuid) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_uuid = uuid;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalUuid() {
		return getColumnOriginalValue("uuid_");
	}

	@Override
	public String getExternalReferenceCode() {
		if (_externalReferenceCode == null) {
			return "";
		}
		else {
			return _externalReferenceCode;
		}
	}

	@Override
	public void setExternalReferenceCode(String externalReferenceCode) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_externalReferenceCode = externalReferenceCode;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalExternalReferenceCode() {
		return getColumnOriginalValue("externalReferenceCode");
	}

	@Override
	public long getClientExtensionEntryRelId() {
		return _clientExtensionEntryRelId;
	}

	@Override
	public void setClientExtensionEntryRelId(long clientExtensionEntryRelId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_clientExtensionEntryRelId = clientExtensionEntryRelId;
	}

	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCompanyId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("companyId"));
	}

	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userName = userName;
	}

	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_createDate = createDate;
	}

	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_modifiedDate = modifiedDate;
	}

	@Override
	public String getClassName() {
		if (getClassNameId() <= 0) {
			return "";
		}

		return PortalUtil.getClassName(getClassNameId());
	}

	@Override
	public void setClassName(String className) {
		long classNameId = 0;

		if (Validator.isNotNull(className)) {
			classNameId = PortalUtil.getClassNameId(className);
		}

		setClassNameId(classNameId);
	}

	@Override
	public long getClassNameId() {
		return _classNameId;
	}

	@Override
	public void setClassNameId(long classNameId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_classNameId = classNameId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalClassNameId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("classNameId"));
	}

	@Override
	public long getClassPK() {
		return _classPK;
	}

	@Override
	public void setClassPK(long classPK) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_classPK = classPK;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalClassPK() {
		return GetterUtil.getLong(this.<Long>getColumnOriginalValue("classPK"));
	}

	@Override
	public String getCETExternalReferenceCode() {
		if (_cetExternalReferenceCode == null) {
			return "";
		}
		else {
			return _cetExternalReferenceCode;
		}
	}

	@Override
	public void setCETExternalReferenceCode(String cetExternalReferenceCode) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_cetExternalReferenceCode = cetExternalReferenceCode;
	}

	@Override
	public String getType() {
		if (_type == null) {
			return "";
		}
		else {
			return _type;
		}
	}

	@Override
	public void setType(String type) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_type = type;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalType() {
		return getColumnOriginalValue("type_");
	}

	@Override
	public long getContainerModelId() {
		return getClientExtensionEntryRelId();
	}

	@Override
	public void setContainerModelId(long containerModelId) {
		_clientExtensionEntryRelId = containerModelId;
	}

	@Override
	public String getContainerModelName() {
		return String.valueOf(getContainerModelId());
	}

	@Override
	public long getParentContainerModelId() {
		return 0;
	}

	@Override
	public void setParentContainerModelId(long parentContainerModelId) {
	}

	@Override
	public StagedModelType getStagedModelType() {
		return new StagedModelType(
			PortalUtil.getClassNameId(ClientExtensionEntryRel.class.getName()),
			getClassNameId());
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), ClientExtensionEntryRel.class.getName(),
			getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public ClientExtensionEntryRel toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, ClientExtensionEntryRel>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		ClientExtensionEntryRelImpl clientExtensionEntryRelImpl =
			new ClientExtensionEntryRelImpl();

		clientExtensionEntryRelImpl.setMvccVersion(getMvccVersion());
		clientExtensionEntryRelImpl.setUuid(getUuid());
		clientExtensionEntryRelImpl.setExternalReferenceCode(
			getExternalReferenceCode());
		clientExtensionEntryRelImpl.setClientExtensionEntryRelId(
			getClientExtensionEntryRelId());
		clientExtensionEntryRelImpl.setCompanyId(getCompanyId());
		clientExtensionEntryRelImpl.setUserId(getUserId());
		clientExtensionEntryRelImpl.setUserName(getUserName());
		clientExtensionEntryRelImpl.setCreateDate(getCreateDate());
		clientExtensionEntryRelImpl.setModifiedDate(getModifiedDate());
		clientExtensionEntryRelImpl.setClassNameId(getClassNameId());
		clientExtensionEntryRelImpl.setClassPK(getClassPK());
		clientExtensionEntryRelImpl.setCETExternalReferenceCode(
			getCETExternalReferenceCode());
		clientExtensionEntryRelImpl.setType(getType());

		clientExtensionEntryRelImpl.resetOriginalValues();

		return clientExtensionEntryRelImpl;
	}

	@Override
	public ClientExtensionEntryRel cloneWithOriginalValues() {
		ClientExtensionEntryRelImpl clientExtensionEntryRelImpl =
			new ClientExtensionEntryRelImpl();

		clientExtensionEntryRelImpl.setMvccVersion(
			this.<Long>getColumnOriginalValue("mvccVersion"));
		clientExtensionEntryRelImpl.setUuid(
			this.<String>getColumnOriginalValue("uuid_"));
		clientExtensionEntryRelImpl.setExternalReferenceCode(
			this.<String>getColumnOriginalValue("externalReferenceCode"));
		clientExtensionEntryRelImpl.setClientExtensionEntryRelId(
			this.<Long>getColumnOriginalValue("clientExtensionEntryRelId"));
		clientExtensionEntryRelImpl.setCompanyId(
			this.<Long>getColumnOriginalValue("companyId"));
		clientExtensionEntryRelImpl.setUserId(
			this.<Long>getColumnOriginalValue("userId"));
		clientExtensionEntryRelImpl.setUserName(
			this.<String>getColumnOriginalValue("userName"));
		clientExtensionEntryRelImpl.setCreateDate(
			this.<Date>getColumnOriginalValue("createDate"));
		clientExtensionEntryRelImpl.setModifiedDate(
			this.<Date>getColumnOriginalValue("modifiedDate"));
		clientExtensionEntryRelImpl.setClassNameId(
			this.<Long>getColumnOriginalValue("classNameId"));
		clientExtensionEntryRelImpl.setClassPK(
			this.<Long>getColumnOriginalValue("classPK"));
		clientExtensionEntryRelImpl.setCETExternalReferenceCode(
			this.<String>getColumnOriginalValue("cetExternalReferenceCode"));
		clientExtensionEntryRelImpl.setType(
			this.<String>getColumnOriginalValue("type_"));

		return clientExtensionEntryRelImpl;
	}

	@Override
	public int compareTo(ClientExtensionEntryRel clientExtensionEntryRel) {
		long primaryKey = clientExtensionEntryRel.getPrimaryKey();

		if (getPrimaryKey() < primaryKey) {
			return -1;
		}
		else if (getPrimaryKey() > primaryKey) {
			return 1;
		}
		else {
			return 0;
		}
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof ClientExtensionEntryRel)) {
			return false;
		}

		ClientExtensionEntryRel clientExtensionEntryRel =
			(ClientExtensionEntryRel)object;

		long primaryKey = clientExtensionEntryRel.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return true;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return true;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_setModifiedDate = false;

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<ClientExtensionEntryRel> toCacheModel() {
		ClientExtensionEntryRelCacheModel clientExtensionEntryRelCacheModel =
			new ClientExtensionEntryRelCacheModel();

		clientExtensionEntryRelCacheModel.mvccVersion = getMvccVersion();

		clientExtensionEntryRelCacheModel.uuid = getUuid();

		String uuid = clientExtensionEntryRelCacheModel.uuid;

		if ((uuid != null) && (uuid.length() == 0)) {
			clientExtensionEntryRelCacheModel.uuid = null;
		}

		clientExtensionEntryRelCacheModel.externalReferenceCode =
			getExternalReferenceCode();

		String externalReferenceCode =
			clientExtensionEntryRelCacheModel.externalReferenceCode;

		if ((externalReferenceCode != null) &&
			(externalReferenceCode.length() == 0)) {

			clientExtensionEntryRelCacheModel.externalReferenceCode = null;
		}

		clientExtensionEntryRelCacheModel.clientExtensionEntryRelId =
			getClientExtensionEntryRelId();

		clientExtensionEntryRelCacheModel.companyId = getCompanyId();

		clientExtensionEntryRelCacheModel.userId = getUserId();

		clientExtensionEntryRelCacheModel.userName = getUserName();

		String userName = clientExtensionEntryRelCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			clientExtensionEntryRelCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			clientExtensionEntryRelCacheModel.createDate = createDate.getTime();
		}
		else {
			clientExtensionEntryRelCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			clientExtensionEntryRelCacheModel.modifiedDate =
				modifiedDate.getTime();
		}
		else {
			clientExtensionEntryRelCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		clientExtensionEntryRelCacheModel.classNameId = getClassNameId();

		clientExtensionEntryRelCacheModel.classPK = getClassPK();

		clientExtensionEntryRelCacheModel.cetExternalReferenceCode =
			getCETExternalReferenceCode();

		String cetExternalReferenceCode =
			clientExtensionEntryRelCacheModel.cetExternalReferenceCode;

		if ((cetExternalReferenceCode != null) &&
			(cetExternalReferenceCode.length() == 0)) {

			clientExtensionEntryRelCacheModel.cetExternalReferenceCode = null;
		}

		clientExtensionEntryRelCacheModel.type = getType();

		String type = clientExtensionEntryRelCacheModel.type;

		if ((type != null) && (type.length() == 0)) {
			clientExtensionEntryRelCacheModel.type = null;
		}

		return clientExtensionEntryRelCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<ClientExtensionEntryRel, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<ClientExtensionEntryRel, Object>>
				entry : attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<ClientExtensionEntryRel, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply(
				(ClientExtensionEntryRel)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	@Override
	public String toXmlString() {
		Map<String, Function<ClientExtensionEntryRel, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 4);

		sb.append("<model><model-name>");
		sb.append(getModelClassName());
		sb.append("</model-name>");

		for (Map.Entry<String, Function<ClientExtensionEntryRel, Object>>
				entry : attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<ClientExtensionEntryRel, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("<column><column-name>");
			sb.append(attributeName);
			sb.append("</column-name><column-value><![CDATA[");
			sb.append(
				attributeGetterFunction.apply((ClientExtensionEntryRel)this));
			sb.append("]]></column-value></column>");
		}

		sb.append("</model>");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function
			<InvocationHandler, ClientExtensionEntryRel>
				_escapedModelProxyProviderFunction =
					ProxyUtil.getProxyProviderFunction(
						ClientExtensionEntryRel.class, ModelWrapper.class);

	}

	private long _mvccVersion;
	private String _uuid;
	private String _externalReferenceCode;
	private long _clientExtensionEntryRelId;
	private long _companyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private long _classNameId;
	private long _classPK;
	private String _cetExternalReferenceCode;
	private String _type;

	public <T> T getColumnValue(String columnName) {
		columnName = _attributeNames.getOrDefault(columnName, columnName);

		Function<ClientExtensionEntryRel, Object> function =
			_attributeGetterFunctions.get(columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((ClientExtensionEntryRel)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("mvccVersion", _mvccVersion);
		_columnOriginalValues.put("uuid_", _uuid);
		_columnOriginalValues.put(
			"externalReferenceCode", _externalReferenceCode);
		_columnOriginalValues.put(
			"clientExtensionEntryRelId", _clientExtensionEntryRelId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("userId", _userId);
		_columnOriginalValues.put("userName", _userName);
		_columnOriginalValues.put("createDate", _createDate);
		_columnOriginalValues.put("modifiedDate", _modifiedDate);
		_columnOriginalValues.put("classNameId", _classNameId);
		_columnOriginalValues.put("classPK", _classPK);
		_columnOriginalValues.put(
			"cetExternalReferenceCode", _cetExternalReferenceCode);
		_columnOriginalValues.put("type_", _type);
	}

	private static final Map<String, String> _attributeNames;

	static {
		Map<String, String> attributeNames = new HashMap<>();

		attributeNames.put("uuid_", "uuid");
		attributeNames.put("type_", "type");

		_attributeNames = Collections.unmodifiableMap(attributeNames);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("mvccVersion", 1L);

		columnBitmasks.put("uuid_", 2L);

		columnBitmasks.put("externalReferenceCode", 4L);

		columnBitmasks.put("clientExtensionEntryRelId", 8L);

		columnBitmasks.put("companyId", 16L);

		columnBitmasks.put("userId", 32L);

		columnBitmasks.put("userName", 64L);

		columnBitmasks.put("createDate", 128L);

		columnBitmasks.put("modifiedDate", 256L);

		columnBitmasks.put("classNameId", 512L);

		columnBitmasks.put("classPK", 1024L);

		columnBitmasks.put("cetExternalReferenceCode", 2048L);

		columnBitmasks.put("type_", 4096L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private ClientExtensionEntryRel _escapedModel;

}