/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.client.extension.model.impl;

import com.liferay.client.extension.model.ClientExtensionEntry;
import com.liferay.client.extension.service.ClientExtensionEntryLocalServiceUtil;

/**
 * The extended model base implementation for the ClientExtensionEntry service. Represents a row in the &quot;ClientExtensionEntry&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link ClientExtensionEntryImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see ClientExtensionEntryImpl
 * @see ClientExtensionEntry
 * @generated
 */
public abstract class ClientExtensionEntryBaseImpl
	extends ClientExtensionEntryModelImpl implements ClientExtensionEntry {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a client extension entry model instance should use the <code>ClientExtensionEntry</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			ClientExtensionEntryLocalServiceUtil.addClientExtensionEntry(this);
		}
		else {
			ClientExtensionEntryLocalServiceUtil.updateClientExtensionEntry(
				this);
		}
	}

}