/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.client.extension.internal.upgrade.v3_1_0;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.upgrade.UpgradeProcessFactory;
import com.liferay.portal.kernel.upgrade.UpgradeStep;
import com.liferay.portal.kernel.util.UnicodePropertiesBuilder;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Objects;

public class ClientExtensionEntryUpgradeProcess
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(ClientExtensionEntryUpgradeProcess.class);

    protected void doUpgrade() throws Exception {
        if (this.hasColumn("ClientExtensionEntry", "typeSettings")) {
            return;
        }
        this.alterTableAddColumn("ClientExtensionEntry", "typeSettings", "TEXT null");
        String selectSQL = StringBundler.concat((String[])new String[]{"select clientExtensionEntryId, customElementCSSURLs, ", "customElementHTMLElementName, customElementURLs, ", "customElementUseESM, friendlyURLMapping, iFrameURL, ", "instanceable, portletCategoryName, type_ from ", "ClientExtensionEntry"});
        String updateSQL = "update ClientExtensionEntry set typeSettings = ? where clientExtensionEntryId = ?";
        try (Statement statement = this.connection.createStatement();
             ResultSet resultSet = statement.executeQuery(selectSQL);
             PreparedStatement preparedStatement = AutoBatchPreparedStatementUtil.autoBatch((Connection)this.connection, (String)updateSQL);){
            while (resultSet.next()) {
                String type = resultSet.getString("type_");
                String typeSettings = this._getTypeSettings(resultSet, type);
                if (typeSettings == null) {
                    _log.error((Object)("Unknown client extension entry type " + type));
                    continue;
                }
                preparedStatement.setString(1, typeSettings);
                preparedStatement.setLong(2, resultSet.getLong("clientExtensionEntryId"));
                preparedStatement.addBatch();
            }
            preparedStatement.executeBatch();
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
        }
    }

    protected UpgradeStep[] getPostUpgradeSteps() {
        return new UpgradeStep[]{UpgradeProcessFactory.dropColumns((String)"ClientExtensionEntry", (String[])new String[]{"customElementCSSURLs", "customElementHTMLElementName", "customElementURLs", "customElementUseESM", "friendlyURLMapping", "iFrameURL", "instanceable", "portletCategoryName"})};
    }

    private String _getTypeSettings(ResultSet resultSet, String type) throws Exception {
        String friendlyURLMapping = resultSet.getString("friendlyURLMapping");
        boolean instanceable = resultSet.getBoolean("instanceable");
        String portletCategoryName = resultSet.getString("portletCategoryName");
        if (Objects.equals(type, "customElement")) {
            return UnicodePropertiesBuilder.create((boolean)true).put("cssURLs", resultSet.getString("customElementCSSURLs")).put("friendlyURLMapping", friendlyURLMapping).put("htmlElementName", resultSet.getString("customElementHTMLElementName")).put("instanceable", instanceable).put("portletCategoryName", portletCategoryName).put("urls", resultSet.getString("customElementURLs")).put("useESM", resultSet.getBoolean("customElementUseESM")).buildString();
        }
        if (Objects.equals(type, "iframe")) {
            return UnicodePropertiesBuilder.create((boolean)true).put("friendlyURLMapping", friendlyURLMapping).put("instanceable", instanceable).put("portletCategoryName", portletCategoryName).put("url", resultSet.getString("iFrameURL")).buildString();
        }
        return null;
    }
}

