/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.client.extension.internal.service.taglib;

import com.liferay.client.extension.internal.service.taglib.util.ClientExtensionDynamicIncludeUtil;
import com.liferay.client.extension.model.ClientExtensionEntryRel;
import com.liferay.client.extension.type.CET;
import com.liferay.client.extension.type.GlobalJSCET;
import com.liferay.client.extension.type.manager.CETManager;
import com.liferay.portal.kernel.content.security.policy.ContentSecurityPolicyNonceProviderUtil;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.taglib.DynamicInclude;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.UnicodePropertiesBuilder;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseDynamicInclude
implements DynamicInclude {
    @Reference
    protected CETManager cetManager;
    @Reference
    protected JSONFactory jsonFactory;
    private static final Log _log = LogFactoryUtil.getLog(BaseDynamicInclude.class);

    public void include(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String key) throws IOException {
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PrintWriter printWriter = httpServletResponse.getWriter();
        List<ClientExtensionEntryRel> clientExtensionEntryRels = ClientExtensionDynamicIncludeUtil.getClientExtensionEntryRels(themeDisplay.getLayout(), "globalJS");
        for (ClientExtensionEntryRel clientExtensionEntryRel : clientExtensionEntryRels) {
            UnicodeProperties typeSettingsUnicodeProperties;
            GlobalJSCET globalJSCET = (GlobalJSCET)this.cetManager.getCET(clientExtensionEntryRel.getCompanyId(), clientExtensionEntryRel.getCETExternalReferenceCode());
            if (globalJSCET == null || !Objects.equals((typeSettingsUnicodeProperties = UnicodePropertiesBuilder.create((boolean)true).fastLoad(clientExtensionEntryRel.getTypeSettings()).build()).getProperty("scriptLocation", ""), this.getScriptLocation())) continue;
            this._writeScript(globalJSCET, httpServletRequest, typeSettingsUnicodeProperties.getProperty("loadType", ""), printWriter);
        }
        if (!FeatureFlagManagerUtil.isEnabled((long)themeDisplay.getCompanyId(), (String)"LPD-30371")) {
            return;
        }
        try {
            List cets = this.cetManager.getCETs(themeDisplay.getCompanyId(), null, "globalJS", Pagination.of((int)-1, (int)-1), null);
            for (CET cet : cets) {
                String scriptLocation;
                GlobalJSCET globalJSCET = (GlobalJSCET)cet;
                if (!StringUtil.equalsIgnoreCase((String)globalJSCET.getScope(), (String)"instance") || Validator.isNull((String)(scriptLocation = globalJSCET.getScriptLocation())) || !StringUtil.equalsIgnoreCase((String)scriptLocation, (String)this.getScriptLocation())) continue;
                this._writeScript(globalJSCET, httpServletRequest, null, printWriter);
            }
        }
        catch (Exception exception) {
            _log.error((Object)("Unable to inject global JavaScript client extensions for company " + themeDisplay.getCompanyId()), (Throwable)exception);
        }
    }

    protected abstract String getScriptLocation();

    private String _toScriptElementAttributes(String scriptElementAttributesJSON) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            JSONObject jsonObject = this.jsonFactory.createJSONObject(scriptElementAttributesJSON);
            Iterator iterator = jsonObject.keys();
            if (!jsonObject.has("data-senna-track")) {
                stringBuilder.append("data-senna-track=\"temporary\" ");
            }
            if (!jsonObject.has("type")) {
                stringBuilder.append("type=\"text/javascript\" ");
            }
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                if (key.equals("async") || key.equals("defer")) continue;
                Object value = jsonObject.get(key);
                if (value instanceof Boolean) {
                    if (value == Boolean.FALSE) continue;
                    stringBuilder.append(key);
                } else {
                    stringBuilder.append(key);
                    stringBuilder.append("=");
                    stringBuilder.append("\"");
                    stringBuilder.append(HtmlUtil.escapeAttribute((String)((String)value)));
                    stringBuilder.append("\"");
                }
                if (!iterator.hasNext()) continue;
                stringBuilder.append(" ");
            }
        }
        catch (JSONException jsonException) {
            _log.error((Object)("Unable to parse script element attributes JSON: " + scriptElementAttributesJSON), (Throwable)jsonException);
        }
        return stringBuilder.toString();
    }

    private void _writeScript(GlobalJSCET globalJSCET, HttpServletRequest httpServletRequest, String loadType, PrintWriter printWriter) {
        printWriter.print("<script");
        printWriter.print(ContentSecurityPolicyNonceProviderUtil.getNonceAttribute((HttpServletRequest)httpServletRequest));
        if (Validator.isNotNull((String)loadType) && !Objects.equals(loadType, "default")) {
            printWriter.print(" ");
            printWriter.print(loadType);
        }
        printWriter.print(" ");
        printWriter.print(this._toScriptElementAttributes(globalJSCET.getScriptElementAttributesJSON()));
        printWriter.print(" src=\"");
        printWriter.print(globalJSCET.getURL());
        printWriter.print("\"></script>");
    }
}

