/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.client.extension.internal.search;

import com.liferay.client.extension.model.ClientExtensionEntry;
import com.liferay.client.extension.service.ClientExtensionEntryLocalService;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.IndexWriterHelper;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Localization;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={Indexer.class})
public class ClientExtensionEntryIndexer
extends BaseIndexer<ClientExtensionEntry> {
    public static final String CLASS_NAME = ClientExtensionEntry.class.getName();
    private static final Log _log = LogFactoryUtil.getLog(ClientExtensionEntryIndexer.class);
    @Reference
    private ClientExtensionEntryLocalService _clientExtensionEntryLocalService;
    @Reference
    private IndexWriterHelper _indexWriterHelper;
    @Reference
    private Localization _localization;

    public String getClassName() {
        return CLASS_NAME;
    }

    public void postProcessSearchQuery(BooleanQuery searchQuery, BooleanFilter fullQueryBooleanFilter, SearchContext searchContext) throws Exception {
        this.addSearchTerm(searchQuery, searchContext, "entryClassPK", false);
        this.addSearchTerm(searchQuery, searchContext, "name", true);
    }

    protected void doDelete(ClientExtensionEntry clientExtensionEntry) throws Exception {
        this.deleteDocument(clientExtensionEntry.getCompanyId(), clientExtensionEntry.getClientExtensionEntryId());
    }

    protected Document doGetDocument(ClientExtensionEntry clientExtensionEntry) throws Exception {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Indexing client extension entry " + clientExtensionEntry));
        }
        Document document = this.getBaseModelDocument(CLASS_NAME, (BaseModel)clientExtensionEntry);
        String[] nameAvailableLanguageIds = this._localization.getAvailableLanguageIds(clientExtensionEntry.getName());
        String nameDefaultLanguageId = this._localization.getDefaultLanguageId(clientExtensionEntry.getName());
        for (String nameAvailableLanguageId : nameAvailableLanguageIds) {
            String name = clientExtensionEntry.getName(nameAvailableLanguageId);
            if (nameDefaultLanguageId.equals(nameAvailableLanguageId)) {
                document.addText("name", name);
            }
            document.addText(this._localization.getLocalizedName("name", nameAvailableLanguageId), name);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Client extension entry " + clientExtensionEntry + " indexed successfully"));
        }
        return document;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletRequest portletRequest, PortletResponse portletResponse) {
        Summary summary = this.createSummary(document);
        summary.setMaxContentLength(200);
        return summary;
    }

    protected void doReindex(ClientExtensionEntry clientExtensionEntry) throws Exception {
        this._indexWriterHelper.updateDocument(clientExtensionEntry.getCompanyId(), this.getDocument(clientExtensionEntry));
    }

    protected void doReindex(String className, long classPK) throws Exception {
        this.doReindex(this._clientExtensionEntryLocalService.getClientExtensionEntry(classPK));
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this._reindexClientExtensionEntries(companyId);
    }

    private void _reindexClientExtensionEntries(long companyId) throws Exception {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = this._clientExtensionEntryLocalService.getIndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setCompanyId(companyId);
        indexableActionableDynamicQuery.setPerformActionMethod(clientExtensionEntry -> {
            block2: {
                try {
                    indexableActionableDynamicQuery.addDocuments(new Document[]{this.getDocument(clientExtensionEntry)});
                }
                catch (PortalException portalException) {
                    if (!_log.isWarnEnabled()) break block2;
                    _log.warn((Object)("Unable to index client extension entry " + clientExtensionEntry), (Throwable)portalException);
                }
            }
        });
        indexableActionableDynamicQuery.performActions();
    }
}

