/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.client.extension.internal.upgrade.v2_4_0;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.db.DBTypeToSQLMap;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;

/**
 * @author José Abelenda
 */
public class RemoteAppEntryUpgradeProcess extends UpgradeProcess {

	@Override
	protected void doUpgrade() throws Exception {
		_addExternalReferenceCodeColumn();

		_updateExternalReferenceCode();
	}

	private void _addExternalReferenceCodeColumn() throws Exception {
		if (!hasColumn("RemoteAppEntry", "externalReferenceCode")) {
			alterTableAddColumn(
				"RemoteAppEntry", "externalReferenceCode", "VARCHAR(75)");
		}
	}

	private void _updateExternalReferenceCode() throws Exception {
		StringBundler sb = new StringBundler(3);

		sb.append("update RemoteAppEntry set externalReferenceCode = ");
		sb.append("CAST_TEXT(remoteAppEntryId) where externalReferenceCode ");
		sb.append("is null");

		DBTypeToSQLMap dbTypeToSQLMap = new DBTypeToSQLMap(sb.toString());

		runSQL(dbTypeToSQLMap);
	}

}