/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.client.extension.internal.upgrade.v2_0_0;

import com.liferay.client.extension.constants.ClientExtensionConstants;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;

/**
 * @author Iván Zaera Avellón
 */
public class RemoteAppEntryUpgradeProcess extends UpgradeProcess {

	@Override
	protected void doUpgrade() throws Exception {
		if (!hasColumn("RemoteAppEntry", "customElementCSSURLs")) {
			alterTableAddColumn(
				"RemoteAppEntry", "customElementCSSURLs", "TEXT");
		}

		if (!hasColumn("RemoteAppEntry", "customElementHTMLElementName")) {
			alterTableAddColumn(
				"RemoteAppEntry", "customElementHTMLElementName",
				"VARCHAR(255)");
		}

		if (!hasColumn("RemoteAppEntry", "customElementURLs")) {
			alterTableAddColumn("RemoteAppEntry", "customElementURLs", "TEXT");
		}

		if (hasColumn("RemoteAppEntry", "url")) {
			alterColumnName("RemoteAppEntry", "url", "iFrameURL STRING null");
		}

		if (!hasColumn("RemoteAppEntry", "instanceable")) {
			alterTableAddColumn("RemoteAppEntry", "instanceable", "BOOLEAN");

			runSQL("update RemoteAppEntry set instanceable = [$TRUE$]");
		}

		if (!hasColumn("RemoteAppEntry", "portletCategoryName")) {
			alterTableAddColumn(
				"RemoteAppEntry", "portletCategoryName", "VARCHAR(75)");

			runSQL(
				"update RemoteAppEntry set portletCategoryName = " +
					"'category.remote-apps'");
		}

		if (!hasColumn("RemoteAppEntry", "properties")) {
			alterTableAddColumn("RemoteAppEntry", "properties", "TEXT");
		}

		if (!hasColumn("RemoteAppEntry", "type_")) {
			alterTableAddColumn("RemoteAppEntry", "type_", "VARCHAR(75)");

			runSQL(
				StringBundler.concat(
					"update RemoteAppEntry set type_ = '",
					ClientExtensionConstants.TYPE_IFRAME, "'"));
		}
	}

}