/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.client.extension.internal.upgrade;

import com.liferay.client.extension.internal.upgrade.v3_0_0.ClassNamesUpgradeProcess;
import com.liferay.client.extension.internal.upgrade.v3_0_0.ClientExtensionEntryUpgradeProcess;
import com.liferay.portal.kernel.model.Release;
import com.liferay.portal.upgrade.registry.UpgradeStepRegistrator;

import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

/**
 * @author Iván Zaera
 */
@Component(immediate = true, service = UpgradeStepRegistrator.class)
public class ClientExtensionServiceUpgrade implements UpgradeStepRegistrator {

	@Override
	public void register(Registry registry) {
		registry.register(
			"1.0.0", "1.0.1",
			new com.liferay.client.extension.internal.upgrade.v1_0_1.
				RemoteAppEntryUpgradeProcess());

		registry.register(
			"1.0.1", "2.0.0",
			new com.liferay.client.extension.internal.upgrade.v2_0_0.
				RemoteAppEntryUpgradeProcess());

		registry.register(
			"2.0.0", "2.1.0",
			new com.liferay.client.extension.internal.upgrade.v2_1_0.
				ResourcePermissionsUpgradeProcess());

		registry.register(
			"2.1.0", "2.2.0",
			new com.liferay.client.extension.internal.upgrade.v2_2_0.
				RemoteAppEntryUpgradeProcess());

		registry.register(
			"2.2.0", "2.3.0",
			new com.liferay.client.extension.internal.upgrade.v2_3_0.
				RemoteAppEntryUpgradeProcess());

		registry.register(
			"2.3.0", "2.4.0",
			new com.liferay.client.extension.internal.upgrade.v2_4_0.
				RemoteAppEntryUpgradeProcess());

		registry.register(
			"2.4.0", "2.5.0",
			new com.liferay.client.extension.internal.upgrade.v2_5_0.
				RemoteAppEntryUpgradeProcess());

		registry.register(
			"2.5.0", "3.0.0", new ClassNamesUpgradeProcess(),
			new ClientExtensionEntryUpgradeProcess());
	}

	@Reference(
		target = "(!(release.bundle.symbolic.name=com.liferay.remote.app.service))"
	)
	private Release _release;

}