/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.client.extension.internal.upgrade;

import com.liferay.portal.kernel.model.Release;
import com.liferay.portal.kernel.service.ReleaseLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.upgrade.registry.UpgradeStepRegistrator;

import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

/**
 * @author Brian Wing Shun Chan
 */
@Component(
	enabled = true, immediate = true, service = UpgradeStepRegistrator.class
)
public class ClientExtensionInitialUpgradeStepRegistrator
	implements UpgradeStepRegistrator {

	@Override
	public void register(Registry registry) {
		registry.registerInitialUpgradeSteps(
			new UpgradeProcess() {

				@Override
				protected void doUpgrade() throws Exception {
					Release remoteAppRelease =
						_releaseLocalService.fetchRelease(
							"com.liferay.remote.app.service");

					if (remoteAppRelease == null) {
						return;
					}

					Release clientExtensionRelease =
						_releaseLocalService.fetchRelease(
							"com.liferay.client.extension.service");

					clientExtensionRelease.setSchemaVersion(
						remoteAppRelease.getSchemaVersion());

					_releaseLocalService.updateRelease(clientExtensionRelease);

					_releaseLocalService.deleteRelease(remoteAppRelease);
				}

			});
	}

	@Reference
	private ReleaseLocalService _releaseLocalService;

}