/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.client.extension.service.impl;

import com.liferay.client.extension.deployer.ClientExtensionEntryDeployer;
import com.liferay.client.extension.exception.ClientExtensionEntryCustomElementCSSURLsException;
import com.liferay.client.extension.exception.ClientExtensionEntryCustomElementHTMLElementNameException;
import com.liferay.client.extension.exception.ClientExtensionEntryCustomElementURLsException;
import com.liferay.client.extension.exception.ClientExtensionEntryFriendlyURLMappingException;
import com.liferay.client.extension.exception.ClientExtensionEntryIFrameURLException;
import com.liferay.client.extension.exception.DuplicateClientExtensionEntryExternalReferenceCodeException;
import com.liferay.client.extension.model.ClientExtensionEntry;
import com.liferay.client.extension.service.base.ClientExtensionEntryLocalServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.cluster.Clusterable;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowHandlerRegistryUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.client.extension.model.ClientExtensionEntry"}, service={AopService.class})
public class ClientExtensionEntryLocalServiceImpl
extends ClientExtensionEntryLocalServiceBaseImpl {
    private static final Pattern _friendlyURLMappingPattern = Pattern.compile("[A-Za-z0-9-_]*");
    private BundleContext _bundleContext;
    @Reference
    private ClientExtensionEntryDeployer _clientExtensionEntryDeployer;
    @Reference
    private CompanyLocalService _companyLocalService;
    private final Set<String> _reservedCustomElementHTMLElementNames = SetUtil.fromArray((Object[])new String[]{"annotation-xml", "color-profile", "font-face", "font-face-format", "font-face-name", "font-face-src", "font-face-uri", "missing-glyph"});
    @Reference
    private ResourceLocalService _resourceLocalService;
    private final Map<Long, List<ServiceRegistration<?>>> _serviceRegistrationsMaps = new ConcurrentHashMap();
    @Reference
    private UserLocalService _userLocalService;

    @Indexable(type=IndexableType.REINDEX)
    public ClientExtensionEntry addCustomElementClientExtensionEntry(String externalReferenceCode, long userId, String customElementCSSURLs, String customElementHTMLElementName, String customElementURLs, boolean customElementUseESM, String description, String friendlyURLMapping, boolean instanceable, Map<Locale, String> nameMap, String portletCategoryName, String properties, String sourceCodeURL) throws PortalException {
        long clientExtensionEntryId = this.counterLocalService.increment();
        if (Validator.isBlank((String)externalReferenceCode)) {
            externalReferenceCode = String.valueOf(clientExtensionEntryId);
        }
        User user = this._userLocalService.getUser(userId);
        this._validateExternalReferenceCode(user.getCompanyId(), externalReferenceCode);
        customElementCSSURLs = StringUtil.trim((String)customElementCSSURLs);
        customElementHTMLElementName = StringUtil.trim((String)customElementHTMLElementName);
        customElementURLs = StringUtil.trim((String)customElementURLs);
        this._validateCustomElement(customElementCSSURLs, customElementHTMLElementName, customElementURLs);
        this._validateFriendlyURLMapping(friendlyURLMapping);
        ClientExtensionEntry clientExtensionEntry = this.clientExtensionEntryPersistence.create(clientExtensionEntryId);
        clientExtensionEntry.setExternalReferenceCode(externalReferenceCode);
        clientExtensionEntry.setCompanyId(user.getCompanyId());
        clientExtensionEntry.setUserId(user.getUserId());
        clientExtensionEntry.setUserName(user.getFullName());
        clientExtensionEntry.setCustomElementCSSURLs(customElementCSSURLs);
        clientExtensionEntry.setCustomElementHTMLElementName(customElementHTMLElementName);
        clientExtensionEntry.setCustomElementURLs(customElementURLs);
        clientExtensionEntry.setCustomElementUseESM(customElementUseESM);
        clientExtensionEntry.setDescription(description);
        clientExtensionEntry.setFriendlyURLMapping(friendlyURLMapping);
        clientExtensionEntry.setInstanceable(instanceable);
        clientExtensionEntry.setNameMap(nameMap);
        clientExtensionEntry.setPortletCategoryName(portletCategoryName);
        clientExtensionEntry.setProperties(properties);
        clientExtensionEntry.setSourceCodeURL(sourceCodeURL);
        clientExtensionEntry.setType("customElement");
        clientExtensionEntry.setStatus(2);
        clientExtensionEntry.setStatusByUserId(userId);
        clientExtensionEntry.setStatusDate(new Date());
        clientExtensionEntry = (ClientExtensionEntry)this.clientExtensionEntryPersistence.update((BaseModel)clientExtensionEntry);
        this._addResources(clientExtensionEntry);
        return this._startWorkflowInstance(userId, clientExtensionEntry);
    }

    @Indexable(type=IndexableType.REINDEX)
    public ClientExtensionEntry addIFrameClientExtensionEntry(long userId, String description, String friendlyURLMapping, String iFrameURL, boolean instanceable, Map<Locale, String> nameMap, String portletCategoryName, String properties, String sourceCodeURL) throws PortalException {
        this._validateFriendlyURLMapping(friendlyURLMapping);
        iFrameURL = StringUtil.trim((String)iFrameURL);
        this._validateIFrameURL(iFrameURL);
        ClientExtensionEntry clientExtensionEntry = this.clientExtensionEntryPersistence.create(this.counterLocalService.increment());
        User user = this._userLocalService.getUser(userId);
        clientExtensionEntry.setCompanyId(user.getCompanyId());
        clientExtensionEntry.setUserId(user.getUserId());
        clientExtensionEntry.setUserName(user.getFullName());
        clientExtensionEntry.setDescription(description);
        clientExtensionEntry.setFriendlyURLMapping(friendlyURLMapping);
        clientExtensionEntry.setIFrameURL(iFrameURL);
        clientExtensionEntry.setInstanceable(instanceable);
        clientExtensionEntry.setNameMap(nameMap);
        clientExtensionEntry.setPortletCategoryName(portletCategoryName);
        clientExtensionEntry.setProperties(properties);
        clientExtensionEntry.setSourceCodeURL(sourceCodeURL);
        clientExtensionEntry.setType("iframe");
        clientExtensionEntry.setStatus(2);
        clientExtensionEntry.setStatusByUserId(userId);
        clientExtensionEntry.setStatusDate(new Date());
        clientExtensionEntry = (ClientExtensionEntry)this.clientExtensionEntryPersistence.update((BaseModel)clientExtensionEntry);
        this._addResources(clientExtensionEntry);
        return this._startWorkflowInstance(userId, clientExtensionEntry);
    }

    @Indexable(type=IndexableType.REINDEX)
    public ClientExtensionEntry addOrUpdateCustomElementClientExtensionEntry(String externalReferenceCode, long userId, String customElementCSSURLs, String customElementHTMLElementName, String customElementURLs, boolean customElementUseESM, String description, String friendlyURLMapping, boolean instanceable, Map<Locale, String> nameMap, String portletCategoryName, String properties, String sourceCodeURL) throws PortalException {
        User user = this._userLocalService.getUser(userId);
        ClientExtensionEntry clientExtensionEntry = this.clientExtensionEntryLocalService.fetchClientExtensionEntryByExternalReferenceCode(user.getCompanyId(), externalReferenceCode);
        if (clientExtensionEntry != null) {
            return this.clientExtensionEntryLocalService.updateCustomElementClientExtensionEntry(userId, clientExtensionEntry.getClientExtensionEntryId(), customElementCSSURLs, customElementHTMLElementName, customElementURLs, customElementUseESM, description, friendlyURLMapping, nameMap, portletCategoryName, properties, sourceCodeURL);
        }
        return this.addCustomElementClientExtensionEntry(externalReferenceCode, userId, customElementCSSURLs, customElementHTMLElementName, customElementURLs, customElementUseESM, description, friendlyURLMapping, instanceable, nameMap, portletCategoryName, properties, sourceCodeURL);
    }

    @Override
    @SystemEvent(type=1)
    public ClientExtensionEntry deleteClientExtensionEntry(ClientExtensionEntry clientExtensionEntry) throws PortalException {
        this.clientExtensionEntryPersistence.remove((BaseModel)clientExtensionEntry);
        this._resourceLocalService.deleteResource(clientExtensionEntry.getCompanyId(), ClientExtensionEntry.class.getName(), 4, clientExtensionEntry.getClientExtensionEntryId());
        this.clientExtensionEntryLocalService.undeployClientExtensionEntry(clientExtensionEntry);
        return clientExtensionEntry;
    }

    @Override
    public ClientExtensionEntry deleteClientExtensionEntry(long clientExtensionEntryId) throws PortalException {
        ClientExtensionEntry clientExtensionEntry = this.clientExtensionEntryPersistence.findByPrimaryKey(clientExtensionEntryId);
        return this.deleteClientExtensionEntry(clientExtensionEntry);
    }

    @Clusterable
    public void deployClientExtensionEntry(ClientExtensionEntry clientExtensionEntry) {
        this.undeployClientExtensionEntry(clientExtensionEntry);
        this._serviceRegistrationsMaps.put(clientExtensionEntry.getClientExtensionEntryId(), this._clientExtensionEntryDeployer.deploy(clientExtensionEntry));
    }

    public List<ClientExtensionEntry> search(long companyId, String keywords, int start, int end, Sort sort) throws PortalException {
        SearchContext searchContext = this._buildSearchContext(companyId, keywords, start, end, sort);
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(ClientExtensionEntry.class);
        for (int i = 0; i < 10; ++i) {
            Hits hits = indexer.search(searchContext);
            List<ClientExtensionEntry> clientExtensionEntries = this._getClientExtensionEntries(hits);
            if (clientExtensionEntries == null) continue;
            return clientExtensionEntries;
        }
        throw new SearchException("Unable to fix the search index after 10 attempts");
    }

    public int searchCount(long companyId, String keywords) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(ClientExtensionEntry.class);
        SearchContext searchContext = this._buildSearchContext(companyId, keywords, -1, -1, null);
        return GetterUtil.getInteger((Object)indexer.searchCount(searchContext));
    }

    @Override
    public void setAopProxy(Object aopProxy) {
        super.setAopProxy(aopProxy);
        List clientExtensionEntries = this.clientExtensionEntryLocalService.getClientExtensionEntries(-1, -1);
        for (ClientExtensionEntry clientExtensionEntry : clientExtensionEntries) {
            this.deployClientExtensionEntry(clientExtensionEntry);
        }
    }

    @Clusterable
    public void undeployClientExtensionEntry(ClientExtensionEntry clientExtensionEntry) {
        List<ServiceRegistration<?>> serviceRegistrations = this._serviceRegistrationsMaps.remove(clientExtensionEntry.getClientExtensionEntryId());
        if (serviceRegistrations != null) {
            for (ServiceRegistration<?> serviceRegistration : serviceRegistrations) {
                serviceRegistration.unregister();
            }
        }
    }

    @Indexable(type=IndexableType.REINDEX)
    public ClientExtensionEntry updateCustomElementClientExtensionEntry(long userId, long clientExtensionEntryId, String customElementCSSURLs, String customElementHTMLElementName, String customElementURLs, boolean customElementUseESM, String description, String friendlyURLMapping, Map<Locale, String> nameMap, String portletCategoryName, String properties, String sourceCodeURL) throws PortalException {
        customElementCSSURLs = StringUtil.trim((String)customElementCSSURLs);
        customElementHTMLElementName = StringUtil.trim((String)customElementHTMLElementName);
        customElementURLs = StringUtil.trim((String)customElementURLs);
        this._validateCustomElement(customElementCSSURLs, customElementHTMLElementName, customElementURLs);
        this._validateFriendlyURLMapping(friendlyURLMapping);
        ClientExtensionEntry clientExtensionEntry = this.clientExtensionEntryPersistence.findByPrimaryKey(clientExtensionEntryId);
        this.clientExtensionEntryLocalService.undeployClientExtensionEntry(clientExtensionEntry);
        clientExtensionEntry.setCustomElementCSSURLs(customElementCSSURLs);
        clientExtensionEntry.setCustomElementHTMLElementName(customElementHTMLElementName);
        clientExtensionEntry.setCustomElementURLs(customElementURLs);
        clientExtensionEntry.setCustomElementUseESM(customElementUseESM);
        clientExtensionEntry.setDescription(description);
        clientExtensionEntry.setFriendlyURLMapping(friendlyURLMapping);
        clientExtensionEntry.setNameMap(nameMap);
        clientExtensionEntry.setPortletCategoryName(portletCategoryName);
        clientExtensionEntry.setProperties(properties);
        clientExtensionEntry.setSourceCodeURL(sourceCodeURL);
        clientExtensionEntry.setStatus(2);
        clientExtensionEntry.setStatusByUserId(userId);
        clientExtensionEntry.setStatusDate(new Date());
        clientExtensionEntry = (ClientExtensionEntry)this.clientExtensionEntryPersistence.update((BaseModel)clientExtensionEntry);
        return this._startWorkflowInstance(userId, clientExtensionEntry);
    }

    @Indexable(type=IndexableType.REINDEX)
    public ClientExtensionEntry updateIFrameClientExtensionEntry(long userId, long clientExtensionEntryId, String description, String friendlyURLMapping, String iFrameURL, Map<Locale, String> nameMap, String portletCategoryName, String properties, String sourceCodeURL) throws PortalException {
        this._validateFriendlyURLMapping(friendlyURLMapping);
        iFrameURL = StringUtil.trim((String)iFrameURL);
        this._validateIFrameURL(iFrameURL);
        ClientExtensionEntry clientExtensionEntry = this.clientExtensionEntryPersistence.findByPrimaryKey(clientExtensionEntryId);
        this.clientExtensionEntryLocalService.undeployClientExtensionEntry(clientExtensionEntry);
        clientExtensionEntry.setDescription(description);
        clientExtensionEntry.setFriendlyURLMapping(friendlyURLMapping);
        clientExtensionEntry.setIFrameURL(iFrameURL);
        clientExtensionEntry.setNameMap(nameMap);
        clientExtensionEntry.setPortletCategoryName(portletCategoryName);
        clientExtensionEntry.setProperties(properties);
        clientExtensionEntry.setSourceCodeURL(sourceCodeURL);
        clientExtensionEntry.setStatus(2);
        clientExtensionEntry.setStatusByUserId(userId);
        clientExtensionEntry.setStatusDate(new Date());
        clientExtensionEntry = (ClientExtensionEntry)this.clientExtensionEntryPersistence.update((BaseModel)clientExtensionEntry);
        return this._startWorkflowInstance(userId, clientExtensionEntry);
    }

    @Indexable(type=IndexableType.REINDEX)
    public ClientExtensionEntry updateStatus(long userId, long clientExtensionEntryId, int status) throws PortalException {
        ClientExtensionEntry clientExtensionEntry = this.clientExtensionEntryPersistence.findByPrimaryKey(clientExtensionEntryId);
        if (status == clientExtensionEntry.getStatus()) {
            return clientExtensionEntry;
        }
        if (status == 0) {
            this.clientExtensionEntryLocalService.deployClientExtensionEntry(clientExtensionEntry);
        } else if (clientExtensionEntry.getStatus() == 0) {
            this.clientExtensionEntryLocalService.undeployClientExtensionEntry(clientExtensionEntry);
        }
        User user = this._userLocalService.getUser(userId);
        clientExtensionEntry.setStatus(status);
        clientExtensionEntry.setStatusByUserId(user.getUserId());
        clientExtensionEntry.setStatusByUserName(user.getFullName());
        clientExtensionEntry.setStatusDate(new Date());
        return (ClientExtensionEntry)this.clientExtensionEntryPersistence.update((BaseModel)clientExtensionEntry);
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
    }

    private void _addResources(ClientExtensionEntry clientExtensionEntry) throws PortalException {
        this._resourceLocalService.addResources(clientExtensionEntry.getCompanyId(), 0L, clientExtensionEntry.getUserId(), ClientExtensionEntry.class.getName(), clientExtensionEntry.getClientExtensionEntryId(), false, true, true);
    }

    private SearchContext _buildSearchContext(long companyId, String keywords, int start, int end, Sort sort) {
        SearchContext searchContext = new SearchContext();
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setHighlightEnabled(false);
        queryConfig.setScoreEnabled(false);
        searchContext.setAttributes((Map)HashMapBuilder.put((Object)"name", (Object)keywords).put((Object)"url", (Object)keywords).build());
        searchContext.setCompanyId(companyId);
        searchContext.setEnd(end);
        searchContext.setKeywords(keywords);
        if (sort != null) {
            searchContext.setSorts(new Sort[]{sort});
        }
        searchContext.setStart(start);
        return searchContext;
    }

    private List<ClientExtensionEntry> _getClientExtensionEntries(Hits hits) throws PortalException {
        List documents = hits.toList();
        ArrayList<ClientExtensionEntry> clientExtensionEntries = new ArrayList<ClientExtensionEntry>(documents.size());
        for (Document document : documents) {
            long clientExtensionEntryId = GetterUtil.getLong((String)document.get("entryClassPK"));
            ClientExtensionEntry clientExtensionEntry = this.clientExtensionEntryPersistence.fetchByPrimaryKey(clientExtensionEntryId);
            if (clientExtensionEntry == null) {
                clientExtensionEntries = null;
                Indexer indexer = IndexerRegistryUtil.getIndexer(ClientExtensionEntry.class);
                long companyId = GetterUtil.getLong((String)document.get("companyId"));
                indexer.delete(companyId, document.getUID());
                continue;
            }
            clientExtensionEntries.add(clientExtensionEntry);
        }
        return clientExtensionEntries;
    }

    private ClientExtensionEntry _startWorkflowInstance(long userId, ClientExtensionEntry clientExtensionEntry) throws PortalException {
        Company company = this._companyLocalService.getCompany(clientExtensionEntry.getCompanyId());
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        return (ClientExtensionEntry)WorkflowHandlerRegistryUtil.startWorkflowInstance((long)clientExtensionEntry.getCompanyId(), (long)company.getGroupId(), (long)userId, (String)ClientExtensionEntry.class.getName(), (long)clientExtensionEntry.getClientExtensionEntryId(), (Object)clientExtensionEntry, (ServiceContext)serviceContext, Collections.singletonMap("url", Optional.ofNullable(clientExtensionEntry.getCustomElementURLs()).orElse(clientExtensionEntry.getIFrameURL())));
    }

    /*
     * WARNING - void declaration
     */
    private void _validateCustomElement(String customElementCSSURLs, String customElementHTMLElementName, String customElementURLs) throws PortalException {
        if (Validator.isNotNull((String)customElementCSSURLs)) {
            void var6_7;
            String[] stringArray = customElementCSSURLs.split("\n");
            int n = stringArray.length;
            boolean bl = false;
            while (var6_7 < n) {
                String customElementCSSURL = stringArray[var6_7];
                if (!Validator.isUrl((String)customElementCSSURL, (boolean)true)) {
                    throw new ClientExtensionEntryCustomElementCSSURLsException("Invalid custom element CSS URL " + customElementCSSURL);
                }
                ++var6_7;
            }
        }
        if (Validator.isNull((String)customElementHTMLElementName)) {
            throw new ClientExtensionEntryCustomElementHTMLElementNameException("Custom element HTML element name is null");
        }
        char[] customElementHTMLElementNameCharArray = customElementHTMLElementName.toCharArray();
        if (!Validator.isChar((char)customElementHTMLElementNameCharArray[0]) || !Character.isLowerCase(customElementHTMLElementNameCharArray[0])) {
            throw new ClientExtensionEntryCustomElementHTMLElementNameException("Custom element HTML element name must start with a lowercase letter");
        }
        boolean containsDash = false;
        for (char c : customElementHTMLElementNameCharArray) {
            if (c == '-') {
                containsDash = true;
            }
            if (Validator.isChar((char)c) && Character.isLowerCase(c) || Validator.isNumber((String)String.valueOf(c)) || c == '-' || c == '.' || c == '_') continue;
            throw new ClientExtensionEntryCustomElementHTMLElementNameException("Custom element HTML element name contains an invalid character");
        }
        if (!containsDash) {
            throw new ClientExtensionEntryCustomElementHTMLElementNameException("Custom element HTML element name must contain at least one hyphen");
        }
        if (this._reservedCustomElementHTMLElementNames.contains(customElementHTMLElementName)) {
            throw new ClientExtensionEntryCustomElementHTMLElementNameException("Reserved custom element HTML element name " + customElementHTMLElementName);
        }
        if (Validator.isNull((String)customElementURLs)) {
            throw new ClientExtensionEntryCustomElementURLsException("Invalid custom element URLs " + customElementURLs);
        }
        for (String customElementURL : customElementURLs.split("\n")) {
            if (Validator.isUrl((String)customElementURL, (boolean)true)) continue;
            throw new ClientExtensionEntryCustomElementURLsException("Invalid custom element URL " + customElementURL);
        }
    }

    private void _validateExternalReferenceCode(long companyId, String externalReferenceCode) throws DuplicateClientExtensionEntryExternalReferenceCodeException {
        if (Validator.isNull((String)externalReferenceCode)) {
            return;
        }
        ClientExtensionEntry clientExtensionEntry = this.clientExtensionEntryLocalService.fetchClientExtensionEntryByExternalReferenceCode(companyId, externalReferenceCode);
        if (clientExtensionEntry != null) {
            throw new DuplicateClientExtensionEntryExternalReferenceCodeException();
        }
    }

    private void _validateFriendlyURLMapping(String friendlyURLMapping) throws PortalException {
        Matcher matcher = _friendlyURLMappingPattern.matcher(friendlyURLMapping);
        if (!matcher.matches()) {
            throw new ClientExtensionEntryFriendlyURLMappingException("Invalid friendly URL mapping " + friendlyURLMapping);
        }
    }

    private void _validateIFrameURL(String iFrameURL) throws PortalException {
        if (!Validator.isUrl((String)iFrameURL)) {
            throw new ClientExtensionEntryIFrameURLException("Invalid IFrame URL " + iFrameURL);
        }
    }
}

