/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.client.extension.model.impl;

import com.liferay.client.extension.model.ClientExtensionEntry;
import com.liferay.client.extension.model.ClientExtensionEntryModel;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.LocaleException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowConstants;

import java.io.Serializable;

import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the ClientExtensionEntry service. Represents a row in the &quot;ClientExtensionEntry&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>ClientExtensionEntryModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link ClientExtensionEntryImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see ClientExtensionEntryImpl
 * @generated
 */
@JSON(strict = true)
public class ClientExtensionEntryModelImpl
	extends BaseModelImpl<ClientExtensionEntry>
	implements ClientExtensionEntryModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a client extension entry model instance should use the <code>ClientExtensionEntry</code> interface instead.
	 */
	public static final String TABLE_NAME = "ClientExtensionEntry";

	public static final Object[][] TABLE_COLUMNS = {
		{"mvccVersion", Types.BIGINT}, {"uuid_", Types.VARCHAR},
		{"externalReferenceCode", Types.VARCHAR},
		{"clientExtensionEntryId", Types.BIGINT}, {"companyId", Types.BIGINT},
		{"userId", Types.BIGINT}, {"userName", Types.VARCHAR},
		{"createDate", Types.TIMESTAMP}, {"modifiedDate", Types.TIMESTAMP},
		{"customElementCSSURLs", Types.CLOB},
		{"customElementHTMLElementName", Types.VARCHAR},
		{"customElementURLs", Types.CLOB},
		{"customElementUseESM", Types.BOOLEAN}, {"description", Types.CLOB},
		{"friendlyURLMapping", Types.VARCHAR}, {"iFrameURL", Types.VARCHAR},
		{"instanceable", Types.BOOLEAN}, {"name", Types.VARCHAR},
		{"portletCategoryName", Types.VARCHAR}, {"properties", Types.CLOB},
		{"sourceCodeURL", Types.VARCHAR}, {"type_", Types.VARCHAR},
		{"status", Types.INTEGER}, {"statusByUserId", Types.BIGINT},
		{"statusByUserName", Types.VARCHAR}, {"statusDate", Types.TIMESTAMP}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("mvccVersion", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("uuid_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("externalReferenceCode", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("clientExtensionEntryId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("customElementCSSURLs", Types.CLOB);
		TABLE_COLUMNS_MAP.put("customElementHTMLElementName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("customElementURLs", Types.CLOB);
		TABLE_COLUMNS_MAP.put("customElementUseESM", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("description", Types.CLOB);
		TABLE_COLUMNS_MAP.put("friendlyURLMapping", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("iFrameURL", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("instanceable", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("name", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("portletCategoryName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("properties", Types.CLOB);
		TABLE_COLUMNS_MAP.put("sourceCodeURL", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("type_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("status", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("statusByUserId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("statusByUserName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("statusDate", Types.TIMESTAMP);
	}

	public static final String TABLE_SQL_CREATE =
		"create table ClientExtensionEntry (mvccVersion LONG default 0 not null,uuid_ VARCHAR(75) null,externalReferenceCode VARCHAR(75) null,clientExtensionEntryId LONG not null primary key,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,customElementCSSURLs TEXT null,customElementHTMLElementName VARCHAR(255) null,customElementURLs TEXT null,customElementUseESM BOOLEAN,description TEXT null,friendlyURLMapping VARCHAR(75) null,iFrameURL STRING null,instanceable BOOLEAN,name STRING null,portletCategoryName VARCHAR(75) null,properties TEXT null,sourceCodeURL STRING null,type_ VARCHAR(75) null,status INTEGER,statusByUserId LONG,statusByUserName VARCHAR(75) null,statusDate DATE null)";

	public static final String TABLE_SQL_DROP =
		"drop table ClientExtensionEntry";

	public static final String ORDER_BY_JPQL =
		" ORDER BY clientExtensionEntry.clientExtensionEntryId ASC";

	public static final String ORDER_BY_SQL =
		" ORDER BY ClientExtensionEntry.clientExtensionEntryId ASC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long COMPANYID_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long EXTERNALREFERENCECODE_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long UUID_COLUMN_BITMASK = 4L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *		#getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long CLIENTEXTENSIONENTRYID_COLUMN_BITMASK = 8L;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setEntityCacheEnabled(boolean entityCacheEnabled) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setFinderCacheEnabled(boolean finderCacheEnabled) {
	}

	public ClientExtensionEntryModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _clientExtensionEntryId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setClientExtensionEntryId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _clientExtensionEntryId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return ClientExtensionEntry.class;
	}

	@Override
	public String getModelClassName() {
		return ClientExtensionEntry.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<ClientExtensionEntry, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		for (Map.Entry<String, Function<ClientExtensionEntry, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<ClientExtensionEntry, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply((ClientExtensionEntry)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<ClientExtensionEntry, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<ClientExtensionEntry, Object> attributeSetterBiConsumer =
				attributeSetterBiConsumers.get(attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(ClientExtensionEntry)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<ClientExtensionEntry, Object>>
		getAttributeGetterFunctions() {

		return _attributeGetterFunctions;
	}

	public Map<String, BiConsumer<ClientExtensionEntry, Object>>
		getAttributeSetterBiConsumers() {

		return _attributeSetterBiConsumers;
	}

	private static final Map<String, Function<ClientExtensionEntry, Object>>
		_attributeGetterFunctions;
	private static final Map<String, BiConsumer<ClientExtensionEntry, Object>>
		_attributeSetterBiConsumers;

	static {
		Map<String, Function<ClientExtensionEntry, Object>>
			attributeGetterFunctions =
				new LinkedHashMap
					<String, Function<ClientExtensionEntry, Object>>();
		Map<String, BiConsumer<ClientExtensionEntry, ?>>
			attributeSetterBiConsumers =
				new LinkedHashMap
					<String, BiConsumer<ClientExtensionEntry, ?>>();

		attributeGetterFunctions.put(
			"mvccVersion", ClientExtensionEntry::getMvccVersion);
		attributeSetterBiConsumers.put(
			"mvccVersion",
			(BiConsumer<ClientExtensionEntry, Long>)
				ClientExtensionEntry::setMvccVersion);
		attributeGetterFunctions.put("uuid", ClientExtensionEntry::getUuid);
		attributeSetterBiConsumers.put(
			"uuid",
			(BiConsumer<ClientExtensionEntry, String>)
				ClientExtensionEntry::setUuid);
		attributeGetterFunctions.put(
			"externalReferenceCode",
			ClientExtensionEntry::getExternalReferenceCode);
		attributeSetterBiConsumers.put(
			"externalReferenceCode",
			(BiConsumer<ClientExtensionEntry, String>)
				ClientExtensionEntry::setExternalReferenceCode);
		attributeGetterFunctions.put(
			"clientExtensionEntryId",
			ClientExtensionEntry::getClientExtensionEntryId);
		attributeSetterBiConsumers.put(
			"clientExtensionEntryId",
			(BiConsumer<ClientExtensionEntry, Long>)
				ClientExtensionEntry::setClientExtensionEntryId);
		attributeGetterFunctions.put(
			"companyId", ClientExtensionEntry::getCompanyId);
		attributeSetterBiConsumers.put(
			"companyId",
			(BiConsumer<ClientExtensionEntry, Long>)
				ClientExtensionEntry::setCompanyId);
		attributeGetterFunctions.put("userId", ClientExtensionEntry::getUserId);
		attributeSetterBiConsumers.put(
			"userId",
			(BiConsumer<ClientExtensionEntry, Long>)
				ClientExtensionEntry::setUserId);
		attributeGetterFunctions.put(
			"userName", ClientExtensionEntry::getUserName);
		attributeSetterBiConsumers.put(
			"userName",
			(BiConsumer<ClientExtensionEntry, String>)
				ClientExtensionEntry::setUserName);
		attributeGetterFunctions.put(
			"createDate", ClientExtensionEntry::getCreateDate);
		attributeSetterBiConsumers.put(
			"createDate",
			(BiConsumer<ClientExtensionEntry, Date>)
				ClientExtensionEntry::setCreateDate);
		attributeGetterFunctions.put(
			"modifiedDate", ClientExtensionEntry::getModifiedDate);
		attributeSetterBiConsumers.put(
			"modifiedDate",
			(BiConsumer<ClientExtensionEntry, Date>)
				ClientExtensionEntry::setModifiedDate);
		attributeGetterFunctions.put(
			"customElementCSSURLs",
			ClientExtensionEntry::getCustomElementCSSURLs);
		attributeSetterBiConsumers.put(
			"customElementCSSURLs",
			(BiConsumer<ClientExtensionEntry, String>)
				ClientExtensionEntry::setCustomElementCSSURLs);
		attributeGetterFunctions.put(
			"customElementHTMLElementName",
			ClientExtensionEntry::getCustomElementHTMLElementName);
		attributeSetterBiConsumers.put(
			"customElementHTMLElementName",
			(BiConsumer<ClientExtensionEntry, String>)
				ClientExtensionEntry::setCustomElementHTMLElementName);
		attributeGetterFunctions.put(
			"customElementURLs", ClientExtensionEntry::getCustomElementURLs);
		attributeSetterBiConsumers.put(
			"customElementURLs",
			(BiConsumer<ClientExtensionEntry, String>)
				ClientExtensionEntry::setCustomElementURLs);
		attributeGetterFunctions.put(
			"customElementUseESM",
			ClientExtensionEntry::getCustomElementUseESM);
		attributeSetterBiConsumers.put(
			"customElementUseESM",
			(BiConsumer<ClientExtensionEntry, Boolean>)
				ClientExtensionEntry::setCustomElementUseESM);
		attributeGetterFunctions.put(
			"description", ClientExtensionEntry::getDescription);
		attributeSetterBiConsumers.put(
			"description",
			(BiConsumer<ClientExtensionEntry, String>)
				ClientExtensionEntry::setDescription);
		attributeGetterFunctions.put(
			"friendlyURLMapping", ClientExtensionEntry::getFriendlyURLMapping);
		attributeSetterBiConsumers.put(
			"friendlyURLMapping",
			(BiConsumer<ClientExtensionEntry, String>)
				ClientExtensionEntry::setFriendlyURLMapping);
		attributeGetterFunctions.put(
			"iFrameURL", ClientExtensionEntry::getIFrameURL);
		attributeSetterBiConsumers.put(
			"iFrameURL",
			(BiConsumer<ClientExtensionEntry, String>)
				ClientExtensionEntry::setIFrameURL);
		attributeGetterFunctions.put(
			"instanceable", ClientExtensionEntry::getInstanceable);
		attributeSetterBiConsumers.put(
			"instanceable",
			(BiConsumer<ClientExtensionEntry, Boolean>)
				ClientExtensionEntry::setInstanceable);
		attributeGetterFunctions.put("name", ClientExtensionEntry::getName);
		attributeSetterBiConsumers.put(
			"name",
			(BiConsumer<ClientExtensionEntry, String>)
				ClientExtensionEntry::setName);
		attributeGetterFunctions.put(
			"portletCategoryName",
			ClientExtensionEntry::getPortletCategoryName);
		attributeSetterBiConsumers.put(
			"portletCategoryName",
			(BiConsumer<ClientExtensionEntry, String>)
				ClientExtensionEntry::setPortletCategoryName);
		attributeGetterFunctions.put(
			"properties", ClientExtensionEntry::getProperties);
		attributeSetterBiConsumers.put(
			"properties",
			(BiConsumer<ClientExtensionEntry, String>)
				ClientExtensionEntry::setProperties);
		attributeGetterFunctions.put(
			"sourceCodeURL", ClientExtensionEntry::getSourceCodeURL);
		attributeSetterBiConsumers.put(
			"sourceCodeURL",
			(BiConsumer<ClientExtensionEntry, String>)
				ClientExtensionEntry::setSourceCodeURL);
		attributeGetterFunctions.put("type", ClientExtensionEntry::getType);
		attributeSetterBiConsumers.put(
			"type",
			(BiConsumer<ClientExtensionEntry, String>)
				ClientExtensionEntry::setType);
		attributeGetterFunctions.put("status", ClientExtensionEntry::getStatus);
		attributeSetterBiConsumers.put(
			"status",
			(BiConsumer<ClientExtensionEntry, Integer>)
				ClientExtensionEntry::setStatus);
		attributeGetterFunctions.put(
			"statusByUserId", ClientExtensionEntry::getStatusByUserId);
		attributeSetterBiConsumers.put(
			"statusByUserId",
			(BiConsumer<ClientExtensionEntry, Long>)
				ClientExtensionEntry::setStatusByUserId);
		attributeGetterFunctions.put(
			"statusByUserName", ClientExtensionEntry::getStatusByUserName);
		attributeSetterBiConsumers.put(
			"statusByUserName",
			(BiConsumer<ClientExtensionEntry, String>)
				ClientExtensionEntry::setStatusByUserName);
		attributeGetterFunctions.put(
			"statusDate", ClientExtensionEntry::getStatusDate);
		attributeSetterBiConsumers.put(
			"statusDate",
			(BiConsumer<ClientExtensionEntry, Date>)
				ClientExtensionEntry::setStatusDate);

		_attributeGetterFunctions = Collections.unmodifiableMap(
			attributeGetterFunctions);
		_attributeSetterBiConsumers = Collections.unmodifiableMap(
			(Map)attributeSetterBiConsumers);
	}

	@JSON
	@Override
	public long getMvccVersion() {
		return _mvccVersion;
	}

	@Override
	public void setMvccVersion(long mvccVersion) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_mvccVersion = mvccVersion;
	}

	@JSON
	@Override
	public String getUuid() {
		if (_uuid == null) {
			return "";
		}
		else {
			return _uuid;
		}
	}

	@Override
	public void setUuid(String uuid) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_uuid = uuid;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalUuid() {
		return getColumnOriginalValue("uuid_");
	}

	@JSON
	@Override
	public String getExternalReferenceCode() {
		if (_externalReferenceCode == null) {
			return "";
		}
		else {
			return _externalReferenceCode;
		}
	}

	@Override
	public void setExternalReferenceCode(String externalReferenceCode) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_externalReferenceCode = externalReferenceCode;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalExternalReferenceCode() {
		return getColumnOriginalValue("externalReferenceCode");
	}

	@JSON
	@Override
	public long getClientExtensionEntryId() {
		return _clientExtensionEntryId;
	}

	@Override
	public void setClientExtensionEntryId(long clientExtensionEntryId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_clientExtensionEntryId = clientExtensionEntryId;
	}

	@JSON
	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCompanyId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("companyId"));
	}

	@JSON
	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	@JSON
	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userName = userName;
	}

	@JSON
	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_createDate = createDate;
	}

	@JSON
	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_modifiedDate = modifiedDate;
	}

	@JSON
	@Override
	public String getCustomElementCSSURLs() {
		if (_customElementCSSURLs == null) {
			return "";
		}
		else {
			return _customElementCSSURLs;
		}
	}

	@Override
	public void setCustomElementCSSURLs(String customElementCSSURLs) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_customElementCSSURLs = customElementCSSURLs;
	}

	@JSON
	@Override
	public String getCustomElementHTMLElementName() {
		if (_customElementHTMLElementName == null) {
			return "";
		}
		else {
			return _customElementHTMLElementName;
		}
	}

	@Override
	public void setCustomElementHTMLElementName(
		String customElementHTMLElementName) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_customElementHTMLElementName = customElementHTMLElementName;
	}

	@JSON
	@Override
	public String getCustomElementURLs() {
		if (_customElementURLs == null) {
			return "";
		}
		else {
			return _customElementURLs;
		}
	}

	@Override
	public void setCustomElementURLs(String customElementURLs) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_customElementURLs = customElementURLs;
	}

	@JSON
	@Override
	public boolean getCustomElementUseESM() {
		return _customElementUseESM;
	}

	@JSON
	@Override
	public boolean isCustomElementUseESM() {
		return _customElementUseESM;
	}

	@Override
	public void setCustomElementUseESM(boolean customElementUseESM) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_customElementUseESM = customElementUseESM;
	}

	@JSON
	@Override
	public String getDescription() {
		if (_description == null) {
			return "";
		}
		else {
			return _description;
		}
	}

	@Override
	public void setDescription(String description) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_description = description;
	}

	@JSON
	@Override
	public String getFriendlyURLMapping() {
		if (_friendlyURLMapping == null) {
			return "";
		}
		else {
			return _friendlyURLMapping;
		}
	}

	@Override
	public void setFriendlyURLMapping(String friendlyURLMapping) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_friendlyURLMapping = friendlyURLMapping;
	}

	@JSON
	@Override
	public String getIFrameURL() {
		if (_iFrameURL == null) {
			return "";
		}
		else {
			return _iFrameURL;
		}
	}

	@Override
	public void setIFrameURL(String iFrameURL) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_iFrameURL = iFrameURL;
	}

	@JSON
	@Override
	public boolean getInstanceable() {
		return _instanceable;
	}

	@JSON
	@Override
	public boolean isInstanceable() {
		return _instanceable;
	}

	@Override
	public void setInstanceable(boolean instanceable) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_instanceable = instanceable;
	}

	@JSON
	@Override
	public String getName() {
		if (_name == null) {
			return "";
		}
		else {
			return _name;
		}
	}

	@Override
	public String getName(Locale locale) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getName(languageId);
	}

	@Override
	public String getName(Locale locale, boolean useDefault) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getName(languageId, useDefault);
	}

	@Override
	public String getName(String languageId) {
		return LocalizationUtil.getLocalization(getName(), languageId);
	}

	@Override
	public String getName(String languageId, boolean useDefault) {
		return LocalizationUtil.getLocalization(
			getName(), languageId, useDefault);
	}

	@Override
	public String getNameCurrentLanguageId() {
		return _nameCurrentLanguageId;
	}

	@JSON
	@Override
	public String getNameCurrentValue() {
		Locale locale = getLocale(_nameCurrentLanguageId);

		return getName(locale);
	}

	@Override
	public Map<Locale, String> getNameMap() {
		return LocalizationUtil.getLocalizationMap(getName());
	}

	@Override
	public void setName(String name) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_name = name;
	}

	@Override
	public void setName(String name, Locale locale) {
		setName(name, locale, LocaleUtil.getDefault());
	}

	@Override
	public void setName(String name, Locale locale, Locale defaultLocale) {
		String languageId = LocaleUtil.toLanguageId(locale);
		String defaultLanguageId = LocaleUtil.toLanguageId(defaultLocale);

		if (Validator.isNotNull(name)) {
			setName(
				LocalizationUtil.updateLocalization(
					getName(), "Name", name, languageId, defaultLanguageId));
		}
		else {
			setName(
				LocalizationUtil.removeLocalization(
					getName(), "Name", languageId));
		}
	}

	@Override
	public void setNameCurrentLanguageId(String languageId) {
		_nameCurrentLanguageId = languageId;
	}

	@Override
	public void setNameMap(Map<Locale, String> nameMap) {
		setNameMap(nameMap, LocaleUtil.getDefault());
	}

	@Override
	public void setNameMap(Map<Locale, String> nameMap, Locale defaultLocale) {
		if (nameMap == null) {
			return;
		}

		setName(
			LocalizationUtil.updateLocalization(
				nameMap, getName(), "Name",
				LocaleUtil.toLanguageId(defaultLocale)));
	}

	@JSON
	@Override
	public String getPortletCategoryName() {
		if (_portletCategoryName == null) {
			return "";
		}
		else {
			return _portletCategoryName;
		}
	}

	@Override
	public void setPortletCategoryName(String portletCategoryName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_portletCategoryName = portletCategoryName;
	}

	@JSON
	@Override
	public String getProperties() {
		if (_properties == null) {
			return "";
		}
		else {
			return _properties;
		}
	}

	@Override
	public void setProperties(String properties) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_properties = properties;
	}

	@JSON
	@Override
	public String getSourceCodeURL() {
		if (_sourceCodeURL == null) {
			return "";
		}
		else {
			return _sourceCodeURL;
		}
	}

	@Override
	public void setSourceCodeURL(String sourceCodeURL) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_sourceCodeURL = sourceCodeURL;
	}

	@JSON
	@Override
	public String getType() {
		if (_type == null) {
			return "";
		}
		else {
			return _type;
		}
	}

	@Override
	public void setType(String type) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_type = type;
	}

	@JSON
	@Override
	public int getStatus() {
		return _status;
	}

	@Override
	public void setStatus(int status) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_status = status;
	}

	@JSON
	@Override
	public long getStatusByUserId() {
		return _statusByUserId;
	}

	@Override
	public void setStatusByUserId(long statusByUserId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_statusByUserId = statusByUserId;
	}

	@Override
	public String getStatusByUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getStatusByUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setStatusByUserUuid(String statusByUserUuid) {
	}

	@JSON
	@Override
	public String getStatusByUserName() {
		if (_statusByUserName == null) {
			return "";
		}
		else {
			return _statusByUserName;
		}
	}

	@Override
	public void setStatusByUserName(String statusByUserName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_statusByUserName = statusByUserName;
	}

	@JSON
	@Override
	public Date getStatusDate() {
		return _statusDate;
	}

	@Override
	public void setStatusDate(Date statusDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_statusDate = statusDate;
	}

	@Override
	public long getContainerModelId() {
		return getClientExtensionEntryId();
	}

	@Override
	public void setContainerModelId(long containerModelId) {
		_clientExtensionEntryId = containerModelId;
	}

	@Override
	public String getContainerModelName() {
		return String.valueOf(getName());
	}

	@Override
	public long getParentContainerModelId() {
		return 0;
	}

	@Override
	public void setParentContainerModelId(long parentContainerModelId) {
	}

	@Override
	public StagedModelType getStagedModelType() {
		return new StagedModelType(
			PortalUtil.getClassNameId(ClientExtensionEntry.class.getName()));
	}

	@Override
	public boolean isApproved() {
		if (getStatus() == WorkflowConstants.STATUS_APPROVED) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isDenied() {
		if (getStatus() == WorkflowConstants.STATUS_DENIED) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isDraft() {
		if (getStatus() == WorkflowConstants.STATUS_DRAFT) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isExpired() {
		if (getStatus() == WorkflowConstants.STATUS_EXPIRED) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isInactive() {
		if (getStatus() == WorkflowConstants.STATUS_INACTIVE) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isIncomplete() {
		if (getStatus() == WorkflowConstants.STATUS_INCOMPLETE) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isPending() {
		if (getStatus() == WorkflowConstants.STATUS_PENDING) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isScheduled() {
		if (getStatus() == WorkflowConstants.STATUS_SCHEDULED) {
			return true;
		}
		else {
			return false;
		}
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), ClientExtensionEntry.class.getName(),
			getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public String[] getAvailableLanguageIds() {
		Set<String> availableLanguageIds = new TreeSet<String>();

		Map<Locale, String> nameMap = getNameMap();

		for (Map.Entry<Locale, String> entry : nameMap.entrySet()) {
			Locale locale = entry.getKey();
			String value = entry.getValue();

			if (Validator.isNotNull(value)) {
				availableLanguageIds.add(LocaleUtil.toLanguageId(locale));
			}
		}

		return availableLanguageIds.toArray(
			new String[availableLanguageIds.size()]);
	}

	@Override
	public String getDefaultLanguageId() {
		String xml = getName();

		if (xml == null) {
			return "";
		}

		Locale defaultLocale = LocaleUtil.getDefault();

		return LocalizationUtil.getDefaultLanguageId(xml, defaultLocale);
	}

	@Override
	public void prepareLocalizedFieldsForImport() throws LocaleException {
		Locale defaultLocale = LocaleUtil.fromLanguageId(
			getDefaultLanguageId());

		Locale[] availableLocales = LocaleUtil.fromLanguageIds(
			getAvailableLanguageIds());

		Locale defaultImportLocale = LocalizationUtil.getDefaultImportLocale(
			ClientExtensionEntry.class.getName(), getPrimaryKey(),
			defaultLocale, availableLocales);

		prepareLocalizedFieldsForImport(defaultImportLocale);
	}

	@Override
	@SuppressWarnings("unused")
	public void prepareLocalizedFieldsForImport(Locale defaultImportLocale)
		throws LocaleException {

		Locale defaultLocale = LocaleUtil.getDefault();

		String modelDefaultLanguageId = getDefaultLanguageId();

		String name = getName(defaultLocale);

		if (Validator.isNull(name)) {
			setName(getName(modelDefaultLanguageId), defaultLocale);
		}
		else {
			setName(getName(defaultLocale), defaultLocale, defaultLocale);
		}
	}

	@Override
	public ClientExtensionEntry toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, ClientExtensionEntry>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		ClientExtensionEntryImpl clientExtensionEntryImpl =
			new ClientExtensionEntryImpl();

		clientExtensionEntryImpl.setMvccVersion(getMvccVersion());
		clientExtensionEntryImpl.setUuid(getUuid());
		clientExtensionEntryImpl.setExternalReferenceCode(
			getExternalReferenceCode());
		clientExtensionEntryImpl.setClientExtensionEntryId(
			getClientExtensionEntryId());
		clientExtensionEntryImpl.setCompanyId(getCompanyId());
		clientExtensionEntryImpl.setUserId(getUserId());
		clientExtensionEntryImpl.setUserName(getUserName());
		clientExtensionEntryImpl.setCreateDate(getCreateDate());
		clientExtensionEntryImpl.setModifiedDate(getModifiedDate());
		clientExtensionEntryImpl.setCustomElementCSSURLs(
			getCustomElementCSSURLs());
		clientExtensionEntryImpl.setCustomElementHTMLElementName(
			getCustomElementHTMLElementName());
		clientExtensionEntryImpl.setCustomElementURLs(getCustomElementURLs());
		clientExtensionEntryImpl.setCustomElementUseESM(
			isCustomElementUseESM());
		clientExtensionEntryImpl.setDescription(getDescription());
		clientExtensionEntryImpl.setFriendlyURLMapping(getFriendlyURLMapping());
		clientExtensionEntryImpl.setIFrameURL(getIFrameURL());
		clientExtensionEntryImpl.setInstanceable(isInstanceable());
		clientExtensionEntryImpl.setName(getName());
		clientExtensionEntryImpl.setPortletCategoryName(
			getPortletCategoryName());
		clientExtensionEntryImpl.setProperties(getProperties());
		clientExtensionEntryImpl.setSourceCodeURL(getSourceCodeURL());
		clientExtensionEntryImpl.setType(getType());
		clientExtensionEntryImpl.setStatus(getStatus());
		clientExtensionEntryImpl.setStatusByUserId(getStatusByUserId());
		clientExtensionEntryImpl.setStatusByUserName(getStatusByUserName());
		clientExtensionEntryImpl.setStatusDate(getStatusDate());

		clientExtensionEntryImpl.resetOriginalValues();

		return clientExtensionEntryImpl;
	}

	@Override
	public ClientExtensionEntry cloneWithOriginalValues() {
		ClientExtensionEntryImpl clientExtensionEntryImpl =
			new ClientExtensionEntryImpl();

		clientExtensionEntryImpl.setMvccVersion(
			this.<Long>getColumnOriginalValue("mvccVersion"));
		clientExtensionEntryImpl.setUuid(
			this.<String>getColumnOriginalValue("uuid_"));
		clientExtensionEntryImpl.setExternalReferenceCode(
			this.<String>getColumnOriginalValue("externalReferenceCode"));
		clientExtensionEntryImpl.setClientExtensionEntryId(
			this.<Long>getColumnOriginalValue("clientExtensionEntryId"));
		clientExtensionEntryImpl.setCompanyId(
			this.<Long>getColumnOriginalValue("companyId"));
		clientExtensionEntryImpl.setUserId(
			this.<Long>getColumnOriginalValue("userId"));
		clientExtensionEntryImpl.setUserName(
			this.<String>getColumnOriginalValue("userName"));
		clientExtensionEntryImpl.setCreateDate(
			this.<Date>getColumnOriginalValue("createDate"));
		clientExtensionEntryImpl.setModifiedDate(
			this.<Date>getColumnOriginalValue("modifiedDate"));
		clientExtensionEntryImpl.setCustomElementCSSURLs(
			this.<String>getColumnOriginalValue("customElementCSSURLs"));
		clientExtensionEntryImpl.setCustomElementHTMLElementName(
			this.<String>getColumnOriginalValue(
				"customElementHTMLElementName"));
		clientExtensionEntryImpl.setCustomElementURLs(
			this.<String>getColumnOriginalValue("customElementURLs"));
		clientExtensionEntryImpl.setCustomElementUseESM(
			this.<Boolean>getColumnOriginalValue("customElementUseESM"));
		clientExtensionEntryImpl.setDescription(
			this.<String>getColumnOriginalValue("description"));
		clientExtensionEntryImpl.setFriendlyURLMapping(
			this.<String>getColumnOriginalValue("friendlyURLMapping"));
		clientExtensionEntryImpl.setIFrameURL(
			this.<String>getColumnOriginalValue("iFrameURL"));
		clientExtensionEntryImpl.setInstanceable(
			this.<Boolean>getColumnOriginalValue("instanceable"));
		clientExtensionEntryImpl.setName(
			this.<String>getColumnOriginalValue("name"));
		clientExtensionEntryImpl.setPortletCategoryName(
			this.<String>getColumnOriginalValue("portletCategoryName"));
		clientExtensionEntryImpl.setProperties(
			this.<String>getColumnOriginalValue("properties"));
		clientExtensionEntryImpl.setSourceCodeURL(
			this.<String>getColumnOriginalValue("sourceCodeURL"));
		clientExtensionEntryImpl.setType(
			this.<String>getColumnOriginalValue("type_"));
		clientExtensionEntryImpl.setStatus(
			this.<Integer>getColumnOriginalValue("status"));
		clientExtensionEntryImpl.setStatusByUserId(
			this.<Long>getColumnOriginalValue("statusByUserId"));
		clientExtensionEntryImpl.setStatusByUserName(
			this.<String>getColumnOriginalValue("statusByUserName"));
		clientExtensionEntryImpl.setStatusDate(
			this.<Date>getColumnOriginalValue("statusDate"));

		return clientExtensionEntryImpl;
	}

	@Override
	public int compareTo(ClientExtensionEntry clientExtensionEntry) {
		long primaryKey = clientExtensionEntry.getPrimaryKey();

		if (getPrimaryKey() < primaryKey) {
			return -1;
		}
		else if (getPrimaryKey() > primaryKey) {
			return 1;
		}
		else {
			return 0;
		}
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof ClientExtensionEntry)) {
			return false;
		}

		ClientExtensionEntry clientExtensionEntry =
			(ClientExtensionEntry)object;

		long primaryKey = clientExtensionEntry.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return true;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return true;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_setModifiedDate = false;

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<ClientExtensionEntry> toCacheModel() {
		ClientExtensionEntryCacheModel clientExtensionEntryCacheModel =
			new ClientExtensionEntryCacheModel();

		clientExtensionEntryCacheModel.mvccVersion = getMvccVersion();

		clientExtensionEntryCacheModel.uuid = getUuid();

		String uuid = clientExtensionEntryCacheModel.uuid;

		if ((uuid != null) && (uuid.length() == 0)) {
			clientExtensionEntryCacheModel.uuid = null;
		}

		clientExtensionEntryCacheModel.externalReferenceCode =
			getExternalReferenceCode();

		String externalReferenceCode =
			clientExtensionEntryCacheModel.externalReferenceCode;

		if ((externalReferenceCode != null) &&
			(externalReferenceCode.length() == 0)) {

			clientExtensionEntryCacheModel.externalReferenceCode = null;
		}

		clientExtensionEntryCacheModel.clientExtensionEntryId =
			getClientExtensionEntryId();

		clientExtensionEntryCacheModel.companyId = getCompanyId();

		clientExtensionEntryCacheModel.userId = getUserId();

		clientExtensionEntryCacheModel.userName = getUserName();

		String userName = clientExtensionEntryCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			clientExtensionEntryCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			clientExtensionEntryCacheModel.createDate = createDate.getTime();
		}
		else {
			clientExtensionEntryCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			clientExtensionEntryCacheModel.modifiedDate =
				modifiedDate.getTime();
		}
		else {
			clientExtensionEntryCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		clientExtensionEntryCacheModel.customElementCSSURLs =
			getCustomElementCSSURLs();

		String customElementCSSURLs =
			clientExtensionEntryCacheModel.customElementCSSURLs;

		if ((customElementCSSURLs != null) &&
			(customElementCSSURLs.length() == 0)) {

			clientExtensionEntryCacheModel.customElementCSSURLs = null;
		}

		clientExtensionEntryCacheModel.customElementHTMLElementName =
			getCustomElementHTMLElementName();

		String customElementHTMLElementName =
			clientExtensionEntryCacheModel.customElementHTMLElementName;

		if ((customElementHTMLElementName != null) &&
			(customElementHTMLElementName.length() == 0)) {

			clientExtensionEntryCacheModel.customElementHTMLElementName = null;
		}

		clientExtensionEntryCacheModel.customElementURLs =
			getCustomElementURLs();

		String customElementURLs =
			clientExtensionEntryCacheModel.customElementURLs;

		if ((customElementURLs != null) && (customElementURLs.length() == 0)) {
			clientExtensionEntryCacheModel.customElementURLs = null;
		}

		clientExtensionEntryCacheModel.customElementUseESM =
			isCustomElementUseESM();

		clientExtensionEntryCacheModel.description = getDescription();

		String description = clientExtensionEntryCacheModel.description;

		if ((description != null) && (description.length() == 0)) {
			clientExtensionEntryCacheModel.description = null;
		}

		clientExtensionEntryCacheModel.friendlyURLMapping =
			getFriendlyURLMapping();

		String friendlyURLMapping =
			clientExtensionEntryCacheModel.friendlyURLMapping;

		if ((friendlyURLMapping != null) &&
			(friendlyURLMapping.length() == 0)) {

			clientExtensionEntryCacheModel.friendlyURLMapping = null;
		}

		clientExtensionEntryCacheModel.iFrameURL = getIFrameURL();

		String iFrameURL = clientExtensionEntryCacheModel.iFrameURL;

		if ((iFrameURL != null) && (iFrameURL.length() == 0)) {
			clientExtensionEntryCacheModel.iFrameURL = null;
		}

		clientExtensionEntryCacheModel.instanceable = isInstanceable();

		clientExtensionEntryCacheModel.name = getName();

		String name = clientExtensionEntryCacheModel.name;

		if ((name != null) && (name.length() == 0)) {
			clientExtensionEntryCacheModel.name = null;
		}

		clientExtensionEntryCacheModel.portletCategoryName =
			getPortletCategoryName();

		String portletCategoryName =
			clientExtensionEntryCacheModel.portletCategoryName;

		if ((portletCategoryName != null) &&
			(portletCategoryName.length() == 0)) {

			clientExtensionEntryCacheModel.portletCategoryName = null;
		}

		clientExtensionEntryCacheModel.properties = getProperties();

		String properties = clientExtensionEntryCacheModel.properties;

		if ((properties != null) && (properties.length() == 0)) {
			clientExtensionEntryCacheModel.properties = null;
		}

		clientExtensionEntryCacheModel.sourceCodeURL = getSourceCodeURL();

		String sourceCodeURL = clientExtensionEntryCacheModel.sourceCodeURL;

		if ((sourceCodeURL != null) && (sourceCodeURL.length() == 0)) {
			clientExtensionEntryCacheModel.sourceCodeURL = null;
		}

		clientExtensionEntryCacheModel.type = getType();

		String type = clientExtensionEntryCacheModel.type;

		if ((type != null) && (type.length() == 0)) {
			clientExtensionEntryCacheModel.type = null;
		}

		clientExtensionEntryCacheModel.status = getStatus();

		clientExtensionEntryCacheModel.statusByUserId = getStatusByUserId();

		clientExtensionEntryCacheModel.statusByUserName = getStatusByUserName();

		String statusByUserName =
			clientExtensionEntryCacheModel.statusByUserName;

		if ((statusByUserName != null) && (statusByUserName.length() == 0)) {
			clientExtensionEntryCacheModel.statusByUserName = null;
		}

		Date statusDate = getStatusDate();

		if (statusDate != null) {
			clientExtensionEntryCacheModel.statusDate = statusDate.getTime();
		}
		else {
			clientExtensionEntryCacheModel.statusDate = Long.MIN_VALUE;
		}

		return clientExtensionEntryCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<ClientExtensionEntry, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<ClientExtensionEntry, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<ClientExtensionEntry, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply(
				(ClientExtensionEntry)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	@Override
	public String toXmlString() {
		Map<String, Function<ClientExtensionEntry, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 4);

		sb.append("<model><model-name>");
		sb.append(getModelClassName());
		sb.append("</model-name>");

		for (Map.Entry<String, Function<ClientExtensionEntry, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<ClientExtensionEntry, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("<column><column-name>");
			sb.append(attributeName);
			sb.append("</column-name><column-value><![CDATA[");
			sb.append(
				attributeGetterFunction.apply((ClientExtensionEntry)this));
			sb.append("]]></column-value></column>");
		}

		sb.append("</model>");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, ClientExtensionEntry>
			_escapedModelProxyProviderFunction =
				ProxyUtil.getProxyProviderFunction(
					ClientExtensionEntry.class, ModelWrapper.class);

	}

	private long _mvccVersion;
	private String _uuid;
	private String _externalReferenceCode;
	private long _clientExtensionEntryId;
	private long _companyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private String _customElementCSSURLs;
	private String _customElementHTMLElementName;
	private String _customElementURLs;
	private boolean _customElementUseESM;
	private String _description;
	private String _friendlyURLMapping;
	private String _iFrameURL;
	private boolean _instanceable;
	private String _name;
	private String _nameCurrentLanguageId;
	private String _portletCategoryName;
	private String _properties;
	private String _sourceCodeURL;
	private String _type;
	private int _status;
	private long _statusByUserId;
	private String _statusByUserName;
	private Date _statusDate;

	public <T> T getColumnValue(String columnName) {
		columnName = _attributeNames.getOrDefault(columnName, columnName);

		Function<ClientExtensionEntry, Object> function =
			_attributeGetterFunctions.get(columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((ClientExtensionEntry)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("mvccVersion", _mvccVersion);
		_columnOriginalValues.put("uuid_", _uuid);
		_columnOriginalValues.put(
			"externalReferenceCode", _externalReferenceCode);
		_columnOriginalValues.put(
			"clientExtensionEntryId", _clientExtensionEntryId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("userId", _userId);
		_columnOriginalValues.put("userName", _userName);
		_columnOriginalValues.put("createDate", _createDate);
		_columnOriginalValues.put("modifiedDate", _modifiedDate);
		_columnOriginalValues.put(
			"customElementCSSURLs", _customElementCSSURLs);
		_columnOriginalValues.put(
			"customElementHTMLElementName", _customElementHTMLElementName);
		_columnOriginalValues.put("customElementURLs", _customElementURLs);
		_columnOriginalValues.put("customElementUseESM", _customElementUseESM);
		_columnOriginalValues.put("description", _description);
		_columnOriginalValues.put("friendlyURLMapping", _friendlyURLMapping);
		_columnOriginalValues.put("iFrameURL", _iFrameURL);
		_columnOriginalValues.put("instanceable", _instanceable);
		_columnOriginalValues.put("name", _name);
		_columnOriginalValues.put("portletCategoryName", _portletCategoryName);
		_columnOriginalValues.put("properties", _properties);
		_columnOriginalValues.put("sourceCodeURL", _sourceCodeURL);
		_columnOriginalValues.put("type_", _type);
		_columnOriginalValues.put("status", _status);
		_columnOriginalValues.put("statusByUserId", _statusByUserId);
		_columnOriginalValues.put("statusByUserName", _statusByUserName);
		_columnOriginalValues.put("statusDate", _statusDate);
	}

	private static final Map<String, String> _attributeNames;

	static {
		Map<String, String> attributeNames = new HashMap<>();

		attributeNames.put("uuid_", "uuid");
		attributeNames.put("type_", "type");

		_attributeNames = Collections.unmodifiableMap(attributeNames);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("mvccVersion", 1L);

		columnBitmasks.put("uuid_", 2L);

		columnBitmasks.put("externalReferenceCode", 4L);

		columnBitmasks.put("clientExtensionEntryId", 8L);

		columnBitmasks.put("companyId", 16L);

		columnBitmasks.put("userId", 32L);

		columnBitmasks.put("userName", 64L);

		columnBitmasks.put("createDate", 128L);

		columnBitmasks.put("modifiedDate", 256L);

		columnBitmasks.put("customElementCSSURLs", 512L);

		columnBitmasks.put("customElementHTMLElementName", 1024L);

		columnBitmasks.put("customElementURLs", 2048L);

		columnBitmasks.put("customElementUseESM", 4096L);

		columnBitmasks.put("description", 8192L);

		columnBitmasks.put("friendlyURLMapping", 16384L);

		columnBitmasks.put("iFrameURL", 32768L);

		columnBitmasks.put("instanceable", 65536L);

		columnBitmasks.put("name", 131072L);

		columnBitmasks.put("portletCategoryName", 262144L);

		columnBitmasks.put("properties", 524288L);

		columnBitmasks.put("sourceCodeURL", 1048576L);

		columnBitmasks.put("type_", 2097152L);

		columnBitmasks.put("status", 4194304L);

		columnBitmasks.put("statusByUserId", 8388608L);

		columnBitmasks.put("statusByUserName", 16777216L);

		columnBitmasks.put("statusDate", 33554432L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private ClientExtensionEntry _escapedModel;

}