/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.client.extension.internal.upgrade;

import com.liferay.portal.kernel.dao.db.DBInspector;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.upgrade.registry.UpgradeStepRegistrator;

import org.osgi.service.component.annotations.Component;

/**
 * @author Brian Wing Shun Chan
 */
@Component(
	enabled = true, immediate = true, service = UpgradeStepRegistrator.class
)
public class ClientExtensionInitialUpgradeStepRegistrator
	implements UpgradeStepRegistrator {

	@Override
	public void register(Registry registry) {
		registry.registerInitialUpgradeSteps(
			new UpgradeProcess() {

				@Override
				protected void doUpgrade() throws Exception {
					DBInspector dbInspector = new DBInspector(connection);

					if (!dbInspector.hasTable("RemoteAppEntry")) {
						return;
					}

					for (UpgradeProcess upgradeProcess : _upgradeProcesses) {
						upgradeProcess.upgrade();
					}
				}

			});
	}

	private final UpgradeProcess[] _upgradeProcesses = {
		new com.liferay.client.extension.internal.upgrade.v1_0_1.
			RemoteAppEntryUpgradeProcess(),
		new com.liferay.client.extension.internal.upgrade.v2_0_0.
			RemoteAppEntryUpgradeProcess(),
		new com.liferay.client.extension.internal.upgrade.v2_1_0.
			ResourcePermissionsUpgradeProcess(),
		new com.liferay.client.extension.internal.upgrade.v2_2_0.
			RemoteAppEntryUpgradeProcess(),
		new com.liferay.client.extension.internal.upgrade.v2_3_0.
			RemoteAppEntryUpgradeProcess(),
		new com.liferay.client.extension.internal.upgrade.v2_4_0.
			RemoteAppEntryUpgradeProcess(),
		new com.liferay.client.extension.internal.upgrade.v2_5_0.
			RemoteAppEntryUpgradeProcess(),
		new com.liferay.client.extension.internal.upgrade.v3_0_0.
			ClassNamesUpgradeProcess(),
		new com.liferay.client.extension.internal.upgrade.v3_0_0.
			ClientExtensionEntryUpgradeProcess()
	};

}