/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.chat.model.impl;

import com.liferay.chat.model.Status;
import com.liferay.petra.lang.HashUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.model.CacheModel;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

/**
 * The cache model class for representing Status in entity cache.
 *
 * @author Brian Wing Shun Chan
 * @generated
 */
public class StatusCacheModel implements CacheModel<Status>, Externalizable {

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof StatusCacheModel)) {
			return false;
		}

		StatusCacheModel statusCacheModel = (StatusCacheModel)object;

		if (statusId == statusCacheModel.statusId) {
			return true;
		}

		return false;
	}

	@Override
	public int hashCode() {
		return HashUtil.hash(0, statusId);
	}

	@Override
	public String toString() {
		StringBundler sb = new StringBundler(17);

		sb.append("{statusId=");
		sb.append(statusId);
		sb.append(", userId=");
		sb.append(userId);
		sb.append(", modifiedDate=");
		sb.append(modifiedDate);
		sb.append(", online=");
		sb.append(online);
		sb.append(", awake=");
		sb.append(awake);
		sb.append(", activePanelIds=");
		sb.append(activePanelIds);
		sb.append(", message=");
		sb.append(message);
		sb.append(", playSound=");
		sb.append(playSound);
		sb.append("}");

		return sb.toString();
	}

	@Override
	public Status toEntityModel() {
		StatusImpl statusImpl = new StatusImpl();

		statusImpl.setStatusId(statusId);
		statusImpl.setUserId(userId);
		statusImpl.setModifiedDate(modifiedDate);
		statusImpl.setOnline(online);
		statusImpl.setAwake(awake);

		if (activePanelIds == null) {
			statusImpl.setActivePanelIds("");
		}
		else {
			statusImpl.setActivePanelIds(activePanelIds);
		}

		if (message == null) {
			statusImpl.setMessage("");
		}
		else {
			statusImpl.setMessage(message);
		}

		statusImpl.setPlaySound(playSound);

		statusImpl.resetOriginalValues();

		return statusImpl;
	}

	@Override
	public void readExternal(ObjectInput objectInput) throws IOException {
		statusId = objectInput.readLong();

		userId = objectInput.readLong();

		modifiedDate = objectInput.readLong();

		online = objectInput.readBoolean();

		awake = objectInput.readBoolean();
		activePanelIds = objectInput.readUTF();
		message = objectInput.readUTF();

		playSound = objectInput.readBoolean();
	}

	@Override
	public void writeExternal(ObjectOutput objectOutput) throws IOException {
		objectOutput.writeLong(statusId);

		objectOutput.writeLong(userId);

		objectOutput.writeLong(modifiedDate);

		objectOutput.writeBoolean(online);

		objectOutput.writeBoolean(awake);

		if (activePanelIds == null) {
			objectOutput.writeUTF("");
		}
		else {
			objectOutput.writeUTF(activePanelIds);
		}

		if (message == null) {
			objectOutput.writeUTF("");
		}
		else {
			objectOutput.writeUTF(message);
		}

		objectOutput.writeBoolean(playSound);
	}

	public long statusId;
	public long userId;
	public long modifiedDate;
	public boolean online;
	public boolean awake;
	public String activePanelIds;
	public String message;
	public boolean playSound;

}