/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.chat.internal.poller;

import com.liferay.chat.internal.configuration.ChatGroupServiceConfiguration;
import com.liferay.chat.model.Entry;
import com.liferay.chat.model.Status;
import com.liferay.chat.service.EntryLocalServiceUtil;
import com.liferay.chat.service.StatusLocalServiceUtil;
import com.liferay.chat.util.BuddyFinder;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.exception.NoSuchLayoutSetException;
import com.liferay.portal.kernel.exception.NoSuchUserException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ContactConstants;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserConstants;
import com.liferay.portal.kernel.poller.BasePollerProcessor;
import com.liferay.portal.kernel.poller.PollerProcessor;
import com.liferay.portal.kernel.poller.PollerRequest;
import com.liferay.portal.kernel.poller.PollerResponse;
import com.liferay.portal.kernel.service.LayoutSetLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Portal;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.chat.configuration.ChatConfiguration"}, configurationPolicy=ConfigurationPolicy.OPTIONAL, enabled=false, immediate=true, property={"javax.portlet.name=com_liferay_chat_web_portlet_ChatPortlet"}, service={PollerProcessor.class})
public class ChatPollerProcessor
extends BasePollerProcessor {
    private static final Log _log = LogFactoryUtil.getLog(ChatPollerProcessor.class);
    @Reference
    private BuddyFinder _buddyFinder;
    private ChatGroupServiceConfiguration _chatGroupServiceConfiguration;
    @Reference
    private Http _http;
    @Reference
    private LayoutSetLocalService _layoutSetLocalService;
    @Reference
    private Portal _portal;
    private final Set<Long> _processedEntryIds = new HashSet<Long>();
    @Reference
    private UserLocalService _userLocalService;

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._chatGroupServiceConfiguration = (ChatGroupServiceConfiguration)ConfigurableUtil.createConfigurable(ChatGroupServiceConfiguration.class, properties);
    }

    protected void addEntry(PollerRequest pollerRequest) throws Exception {
        long toUserId = this.getLong(pollerRequest, "toUserId");
        if (toUserId > 0L) {
            String content = this.getString(pollerRequest, "content");
            EntryLocalServiceUtil.addEntry((long)pollerRequest.getTimestamp(), (long)pollerRequest.getUserId(), (long)toUserId, (String)content);
        }
    }

    protected PollerResponse doReceive(PollerRequest pollerRequest) throws Exception {
        PollerResponse pollerResponse = pollerRequest.createPollerResponse();
        this.getBuddies(pollerRequest, pollerResponse);
        this.getEntries(pollerRequest, pollerResponse);
        return pollerResponse;
    }

    protected void doSend(PollerRequest pollerRequest) throws Exception {
        if (pollerRequest.isStartPolling()) {
            this._processedEntryIds.clear();
        }
        this.addEntry(pollerRequest);
        this.updateStatus(pollerRequest);
    }

    protected void getBuddies(PollerRequest pollerRequest, PollerResponse pollerResponse) throws Exception {
        List buddies = this._buddyFinder.getBuddies(pollerRequest.getCompanyId(), pollerRequest.getUserId());
        JSONArray buddiesJSONArray = JSONFactoryUtil.createJSONArray();
        for (Object[] buddy : buddies) {
            String displayURL;
            JSONObject curUserJSONObject;
            Status buddyStatus;
            String userUuid;
            long userId;
            String screenName;
            long portraitId;
            String middleName;
            boolean male;
            String lastName;
            long groupId;
            String firstName;
            block4: {
                boolean awake = (Boolean)buddy[0];
                firstName = (String)buddy[1];
                groupId = (Long)buddy[2];
                lastName = (String)buddy[3];
                male = (Boolean)buddy[4];
                middleName = (String)buddy[5];
                portraitId = (Long)buddy[6];
                screenName = (String)buddy[7];
                userId = (Long)buddy[8];
                userUuid = (String)buddy[9];
                buddyStatus = StatusLocalServiceUtil.getUserStatus((long)userId);
                awake = buddyStatus.isAwake();
                curUserJSONObject = JSONUtil.put((String)"awake", (Object)awake);
                displayURL = "";
                try {
                    LayoutSet layoutSet = this._layoutSetLocalService.getLayoutSet(groupId, false);
                    if (layoutSet.getPageCount() > 0) {
                        displayURL = this._portal.getLayoutSetDisplayURL(layoutSet, false);
                        displayURL = this._http.removeDomain(displayURL);
                    }
                }
                catch (NoSuchLayoutSetException nslse) {
                    if (!_log.isDebugEnabled()) break block4;
                    _log.debug((Object)nslse, (Throwable)nslse);
                }
            }
            curUserJSONObject.put("displayURL", displayURL);
            String fullName = ContactConstants.getFullName((String)firstName, (String)middleName, (String)lastName);
            curUserJSONObject.put("fullName", fullName).put("groupId", groupId).put("portraitId", portraitId);
            String portraitURL = UserConstants.getPortraitURL((String)"", (boolean)male, (long)portraitId, (String)userUuid);
            curUserJSONObject.put("portraitURL", portraitURL).put("screenName", screenName);
            String statusMessage = buddyStatus.getMessage();
            curUserJSONObject.put("statusMessage", statusMessage).put("userId", userId);
            buddiesJSONArray.put(curUserJSONObject);
        }
        pollerResponse.setParameter("buddies", buddiesJSONArray);
    }

    protected void getEntries(PollerRequest pollerRequest, PollerResponse pollerResponse) throws Exception {
        boolean updatePresence;
        JSONArray entriesJSONArray = JSONFactoryUtil.createJSONArray();
        boolean hasProcessedEntry = false;
        Status status = StatusLocalServiceUtil.getUserStatus((long)pollerRequest.getUserId());
        long createDate = 0L;
        if (pollerRequest.isInitialRequest()) {
            createDate = status.getModifiedDate() - 86400000L;
        }
        List entries = EntryLocalServiceUtil.getNewEntries((long)pollerRequest.getUserId(), (long)createDate, (int)0, (int)this._chatGroupServiceConfiguration.buddyListMaxBuddies());
        entries = ListUtil.copy((List)entries);
        Collections.reverse(entries);
        for (Entry entry : entries) {
            hasProcessedEntry = this._processedEntryIds.contains(entry.getEntryId());
            this._processedEntryIds.add(entry.getEntryId());
            JSONObject entryJSONObject = JSONUtil.put((String)"createDate", (Object)entry.getCreateDate()).put("entryId", entry.getEntryId()).put("fromUserId", entry.getFromUserId());
            if (entry.getFromUserId() != pollerRequest.getUserId()) {
                try {
                    User fromUser = this._userLocalService.getUserById(entry.getFromUserId());
                    entryJSONObject.put("fromFullName", fromUser.getFullName()).put("fromPortraitId", fromUser.getPortraitId());
                }
                catch (NoSuchUserException nsue) {
                    if (!_log.isDebugEnabled()) continue;
                    _log.debug((Object)nsue, (Throwable)nsue);
                    continue;
                }
            }
            entryJSONObject.put("content", HtmlUtil.escape((String)entry.getContent())).put("flag", entry.getFlag()).put("toUserId", entry.getToUserId());
            entriesJSONArray.put(entryJSONObject);
        }
        pollerResponse.setParameter("entries", entriesJSONArray);
        if (!entries.isEmpty() && !hasProcessedEntry) {
            pollerResponse.setParameter("pollerHintHighConnectivity", Boolean.TRUE.toString());
        }
        if (!(updatePresence = this.getBoolean(pollerRequest, "updatePresence"))) {
            if (!entries.isEmpty()) {
                updatePresence = true;
            } else {
                long onlineTimestamp = status.getModifiedDate() + 60000L - 15000L;
                if (onlineTimestamp < pollerRequest.getTimestamp()) {
                    updatePresence = true;
                }
            }
        }
        if (updatePresence) {
            StatusLocalServiceUtil.updateStatus((long)pollerRequest.getUserId(), (long)pollerRequest.getTimestamp());
        }
    }

    protected void updateStatus(PollerRequest pollerRequest) throws Exception {
        int online = this.getInteger(pollerRequest, "online");
        int awake = this.getInteger(pollerRequest, "awake");
        String activePanelIds = this.getString(pollerRequest, "activePanelIds");
        String statusMessage = this.getString(pollerRequest, "statusMessage");
        int playSound = this.getInteger(pollerRequest, "playSound");
        if (online != -1 || awake != -1 || activePanelIds != null || statusMessage != null || playSound != -1) {
            StatusLocalServiceUtil.updateStatus((long)pollerRequest.getUserId(), (long)-1L, (int)online, (int)awake, (String)activePanelIds, (String)statusMessage, (int)playSound);
        }
    }
}

