/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.chat.service.persistence.impl;

import com.liferay.chat.service.persistence.StatusFinder;
import com.liferay.chat.service.persistence.impl.StatusFinderBaseImpl;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.dao.orm.custom.sql.CustomSQL;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={StatusFinder.class})
public class StatusFinderImpl
extends StatusFinderBaseImpl
implements StatusFinder {
    public static final String FIND_BY_MODIFIED_DATE = StatusFinder.class.getName() + ".findByModifiedDate";
    public static final String FIND_BY_SOCIAL_RELATION_TYPES = StatusFinder.class.getName() + ".findBySocialRelationTypes";
    public static final String FIND_BY_USERS_GROUPS = StatusFinder.class.getName() + ".findByUsersGroups";
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private CustomSQL _customSQL;
    @Reference
    private UserLocalService _userLocalService;

    public List<Object[]> findByModifiedDate(long companyId, long userId, long modifiedDate, int start, int end) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), FIND_BY_MODIFIED_DATE);
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            this.addScalars(q);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(this._classNameLocalService.getClassNameId(User.class));
            qPos.add(companyId);
            qPos.add(userId);
            qPos.add(modifiedDate);
            List<Object[]> list = this.toObjectArray(QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end));
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Object[]> findBySocialRelationTypes(long userId, int[] types, long modifiedDate, int start, int end) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = this.getFindBySocialRelationTypes_SQL(types);
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            this.addScalars(q);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(this._classNameLocalService.getClassNameId(User.class));
            qPos.add(userId);
            if (types.length > 0) {
                qPos.add(types);
            }
            qPos.add(CompanyThreadLocal.getCompanyId());
            qPos.add(userId);
            qPos.add(modifiedDate);
            List<Object[]> list = this.toObjectArray(QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end));
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Object[]> findByUsersGroups(long userId, long modifiedDate, String[] groupNames, int start, int end) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = this.getFindByUsersGroups_SQL(groupNames);
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            this.addScalars(q);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(this._classNameLocalService.getClassNameId(User.class));
            qPos.add(CompanyThreadLocal.getCompanyId());
            qPos.add(userId);
            qPos.add(userId);
            if (groupNames.length > 0) {
                qPos.add(groupNames);
            }
            qPos.add(modifiedDate);
            List<Object[]> list = this.toObjectArray(QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end));
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected void addScalars(SQLQuery sqlQuery) {
        sqlQuery.addScalar("awake", Type.BOOLEAN);
        sqlQuery.addScalar("firstName", Type.STRING);
        sqlQuery.addScalar("groupId", Type.LONG);
        sqlQuery.addScalar("lastName", Type.STRING);
        sqlQuery.addScalar("middleName", Type.STRING);
        sqlQuery.addScalar("portraitId", Type.LONG);
        sqlQuery.addScalar("screenName", Type.STRING);
        sqlQuery.addScalar("userId", Type.LONG);
        sqlQuery.addScalar("userUuid", Type.STRING);
    }

    protected String getFindBySocialRelationTypes_SQL(int[] types) {
        String sql = this._customSQL.get(((Object)((Object)this)).getClass(), FIND_BY_SOCIAL_RELATION_TYPES);
        if (types.length == 0) {
            return StringUtil.replace((String)sql, (String)"[$SOCIAL_RELATION_TYPES$]", (String)"");
        }
        StringBundler sb = new StringBundler(types.length * 2 - 1);
        for (int i = 0; i < types.length; ++i) {
            sb.append("?");
            if (i + 1 >= types.length) continue;
            sb.append(",");
        }
        return StringUtil.replace((String)sql, (String)"[$SOCIAL_RELATION_TYPES$]", (String)("SocialRelation.type_ IN (" + sb.toString() + ") AND"));
    }

    protected String getFindByUsersGroups_SQL(String[] groupNames) {
        String sql = this._customSQL.get(((Object)((Object)this)).getClass(), FIND_BY_USERS_GROUPS);
        if (groupNames.length == 0) {
            return StringUtil.replace((String)sql, (String[])new String[]{"[$USERS_GROUPS_JOIN$]", "[$USERS_GROUPS_WHERE$]"}, (String[])new String[]{"", ""});
        }
        StringBundler sb = new StringBundler(groupNames.length * 2 - 1);
        for (int i = 0; i < groupNames.length; ++i) {
            sb.append("?");
            if (i + 1 >= groupNames.length) continue;
            sb.append(",");
        }
        return StringUtil.replace((String)sql, (String[])new String[]{"[$USERS_GROUPS_JOIN$]", "[$USERS_GROUPS_WHERE$]"}, (String[])new String[]{"INNER JOIN Group_ ON Group_.groupId = Users_Groups.groupId", "AND Group_.name NOT IN (" + sb.toString() + ")"});
    }

    protected List<Object[]> toObjectArray(List<?> list) throws Exception {
        List<?> objectArrayList = list;
        ArrayList<Object[]> newObjectArrayList = new ArrayList<Object[]>(objectArrayList.size());
        for (Object[] objectArray : objectArrayList) {
            long userId = (Long)objectArray[7];
            User user = this._userLocalService.getUser(userId);
            Object[] newObjectArray = new Object[objectArray.length + 1];
            System.arraycopy(objectArray, 0, newObjectArray, 0, 4);
            newObjectArray[4] = user.isMale();
            System.arraycopy(objectArray, 4, newObjectArray, 5, 5);
            newObjectArrayList.add(newObjectArray);
        }
        return newObjectArrayList;
    }
}

