/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.chat.service.persistence.impl;

import com.liferay.chat.exception.NoSuchStatusException;
import com.liferay.chat.model.Status;
import com.liferay.chat.model.impl.StatusImpl;
import com.liferay.chat.model.impl.StatusModelImpl;
import com.liferay.chat.service.persistence.StatusPersistence;
import com.liferay.chat.service.persistence.StatusUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.SessionFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.SetUtil;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={StatusPersistence.class})
public class StatusPersistenceImpl
extends BasePersistenceImpl<Status>
implements StatusPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = StatusImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathFetchByUserId;
    private FinderPath _finderPathCountByUserId;
    private static final String _FINDER_COLUMN_USERID_USERID_2 = "status.userId = ?";
    private FinderPath _finderPathWithPaginationFindByModifiedDate;
    private FinderPath _finderPathWithoutPaginationFindByModifiedDate;
    private FinderPath _finderPathCountByModifiedDate;
    private static final String _FINDER_COLUMN_MODIFIEDDATE_MODIFIEDDATE_2 = "status.modifiedDate = ?";
    private FinderPath _finderPathWithPaginationFindByOnline;
    private FinderPath _finderPathWithoutPaginationFindByOnline;
    private FinderPath _finderPathCountByOnline;
    private static final String _FINDER_COLUMN_ONLINE_ONLINE_2 = "status.online = ?";
    private FinderPath _finderPathWithPaginationFindByM_O;
    private FinderPath _finderPathWithoutPaginationFindByM_O;
    private FinderPath _finderPathCountByM_O;
    private static final String _FINDER_COLUMN_M_O_MODIFIEDDATE_2 = "status.modifiedDate = ? AND ";
    private static final String _FINDER_COLUMN_M_O_ONLINE_2 = "status.online = ?";
    private int _valueObjectFinderCacheListThreshold;
    private boolean _columnBitmaskEnabled;
    @Reference
    protected EntityCache entityCache;
    @Reference
    protected FinderCache finderCache;
    private static final String _SQL_SELECT_STATUS = "SELECT status FROM Status status";
    private static final String _SQL_SELECT_STATUS_WHERE = "SELECT status FROM Status status WHERE ";
    private static final String _SQL_COUNT_STATUS = "SELECT COUNT(status) FROM Status status";
    private static final String _SQL_COUNT_STATUS_WHERE = "SELECT COUNT(status) FROM Status status WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "status.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No Status exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No Status exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(StatusPersistenceImpl.class);
    private static final Set<String> _badColumnNames = SetUtil.fromArray((Object[])new String[]{"online"});

    public Status findByUserId(long userId) throws NoSuchStatusException {
        Status status = this.fetchByUserId(userId);
        if (status == null) {
            StringBundler sb = new StringBundler(4);
            sb.append(_NO_SUCH_ENTITY_WITH_KEY);
            sb.append("userId=");
            sb.append(userId);
            sb.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)sb.toString());
            }
            throw new NoSuchStatusException(sb.toString());
        }
        return status;
    }

    public Status fetchByUserId(long userId) {
        return this.fetchByUserId(userId, true);
    }

    public Status fetchByUserId(long userId, boolean useFinderCache) {
        Status status;
        Object[] finderArgs = null;
        if (useFinderCache) {
            finderArgs = new Object[]{userId};
        }
        Object result = null;
        if (useFinderCache) {
            result = this.finderCache.getResult(this._finderPathFetchByUserId, finderArgs, (BasePersistenceImpl)this);
        }
        if (result instanceof Status && userId != (status = (Status)result).getUserId()) {
            result = null;
        }
        if (result == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_SELECT_STATUS_WHERE);
            sb.append(_FINDER_COLUMN_USERID_USERID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(userId);
                List list = query.list();
                if (list.isEmpty()) {
                    if (useFinderCache) {
                        this.finderCache.putResult(this._finderPathFetchByUserId, finderArgs, (Object)list);
                    }
                } else {
                    Status status2 = (Status)list.get(0);
                    result = status2;
                    this.cacheResult(status2);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(this._finderPathFetchByUserId, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (Status)result;
    }

    public Status removeByUserId(long userId) throws NoSuchStatusException {
        Status status = this.findByUserId(userId);
        return (Status)this.remove((BaseModel)status);
    }

    public int countByUserId(long userId) {
        FinderPath finderPath = this._finderPathCountByUserId;
        Object[] finderArgs = new Object[]{userId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_STATUS_WHERE);
            sb.append(_FINDER_COLUMN_USERID_USERID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(userId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<Status> findByModifiedDate(long modifiedDate) {
        return this.findByModifiedDate(modifiedDate, -1, -1, null);
    }

    public List<Status> findByModifiedDate(long modifiedDate, int start, int end) {
        return this.findByModifiedDate(modifiedDate, start, end, null);
    }

    public List<Status> findByModifiedDate(long modifiedDate, int start, int end, OrderByComparator<Status> orderByComparator) {
        return this.findByModifiedDate(modifiedDate, start, end, orderByComparator, true);
    }

    public List<Status> findByModifiedDate(long modifiedDate, int start, int end, OrderByComparator<Status> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByModifiedDate;
                finderArgs = new Object[]{modifiedDate};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByModifiedDate;
            finderArgs = new Object[]{modifiedDate, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (Status status : list) {
                if (modifiedDate == status.getModifiedDate()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_STATUS_WHERE);
            sb.append(_FINDER_COLUMN_MODIFIEDDATE_MODIFIEDDATE_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY status.statusId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(modifiedDate);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(finderPath, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public Status findByModifiedDate_First(long modifiedDate, OrderByComparator<Status> orderByComparator) throws NoSuchStatusException {
        Status status = this.fetchByModifiedDate_First(modifiedDate, orderByComparator);
        if (status != null) {
            return status;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("modifiedDate=");
        sb.append(modifiedDate);
        sb.append("}");
        throw new NoSuchStatusException(sb.toString());
    }

    public Status fetchByModifiedDate_First(long modifiedDate, OrderByComparator<Status> orderByComparator) {
        List<Status> list = this.findByModifiedDate(modifiedDate, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public Status findByModifiedDate_Last(long modifiedDate, OrderByComparator<Status> orderByComparator) throws NoSuchStatusException {
        Status status = this.fetchByModifiedDate_Last(modifiedDate, orderByComparator);
        if (status != null) {
            return status;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("modifiedDate=");
        sb.append(modifiedDate);
        sb.append("}");
        throw new NoSuchStatusException(sb.toString());
    }

    public Status fetchByModifiedDate_Last(long modifiedDate, OrderByComparator<Status> orderByComparator) {
        int count = this.countByModifiedDate(modifiedDate);
        if (count == 0) {
            return null;
        }
        List<Status> list = this.findByModifiedDate(modifiedDate, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public Status[] findByModifiedDate_PrevAndNext(long statusId, long modifiedDate, OrderByComparator<Status> orderByComparator) throws NoSuchStatusException {
        Status status = this.findByPrimaryKey(statusId);
        Session session = null;
        try {
            session = this.openSession();
            Status[] array = new StatusImpl[]{this.getByModifiedDate_PrevAndNext(session, status, modifiedDate, orderByComparator, true), status, this.getByModifiedDate_PrevAndNext(session, status, modifiedDate, orderByComparator, false)};
            Status[] statusArray = array;
            return statusArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Status getByModifiedDate_PrevAndNext(Session session, Status status, long modifiedDate, OrderByComparator<Status> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_STATUS_WHERE);
        sb.append(_FINDER_COLUMN_MODIFIEDDATE_MODIFIEDDATE_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY status.statusId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(modifiedDate);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)status)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (Status)list.get(1);
        }
        return null;
    }

    public void removeByModifiedDate(long modifiedDate) {
        for (Status status : this.findByModifiedDate(modifiedDate, -1, -1, null)) {
            this.remove((BaseModel)status);
        }
    }

    public int countByModifiedDate(long modifiedDate) {
        FinderPath finderPath = this._finderPathCountByModifiedDate;
        Object[] finderArgs = new Object[]{modifiedDate};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_STATUS_WHERE);
            sb.append(_FINDER_COLUMN_MODIFIEDDATE_MODIFIEDDATE_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(modifiedDate);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<Status> findByOnline(boolean online) {
        return this.findByOnline(online, -1, -1, null);
    }

    public List<Status> findByOnline(boolean online, int start, int end) {
        return this.findByOnline(online, start, end, null);
    }

    public List<Status> findByOnline(boolean online, int start, int end, OrderByComparator<Status> orderByComparator) {
        return this.findByOnline(online, start, end, orderByComparator, true);
    }

    public List<Status> findByOnline(boolean online, int start, int end, OrderByComparator<Status> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByOnline;
                finderArgs = new Object[]{online};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByOnline;
            finderArgs = new Object[]{online, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (Status status : list) {
                if (online == status.isOnline()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_STATUS_WHERE);
            sb.append("status.online = ?");
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY status.statusId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(online);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(finderPath, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public Status findByOnline_First(boolean online, OrderByComparator<Status> orderByComparator) throws NoSuchStatusException {
        Status status = this.fetchByOnline_First(online, orderByComparator);
        if (status != null) {
            return status;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("online=");
        sb.append(online);
        sb.append("}");
        throw new NoSuchStatusException(sb.toString());
    }

    public Status fetchByOnline_First(boolean online, OrderByComparator<Status> orderByComparator) {
        List<Status> list = this.findByOnline(online, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public Status findByOnline_Last(boolean online, OrderByComparator<Status> orderByComparator) throws NoSuchStatusException {
        Status status = this.fetchByOnline_Last(online, orderByComparator);
        if (status != null) {
            return status;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("online=");
        sb.append(online);
        sb.append("}");
        throw new NoSuchStatusException(sb.toString());
    }

    public Status fetchByOnline_Last(boolean online, OrderByComparator<Status> orderByComparator) {
        int count = this.countByOnline(online);
        if (count == 0) {
            return null;
        }
        List<Status> list = this.findByOnline(online, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public Status[] findByOnline_PrevAndNext(long statusId, boolean online, OrderByComparator<Status> orderByComparator) throws NoSuchStatusException {
        Status status = this.findByPrimaryKey(statusId);
        Session session = null;
        try {
            session = this.openSession();
            Status[] array = new StatusImpl[]{this.getByOnline_PrevAndNext(session, status, online, orderByComparator, true), status, this.getByOnline_PrevAndNext(session, status, online, orderByComparator, false)};
            Status[] statusArray = array;
            return statusArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Status getByOnline_PrevAndNext(Session session, Status status, boolean online, OrderByComparator<Status> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_STATUS_WHERE);
        sb.append("status.online = ?");
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY status.statusId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(online);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)status)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (Status)list.get(1);
        }
        return null;
    }

    public void removeByOnline(boolean online) {
        for (Status status : this.findByOnline(online, -1, -1, null)) {
            this.remove((BaseModel)status);
        }
    }

    public int countByOnline(boolean online) {
        FinderPath finderPath = this._finderPathCountByOnline;
        Object[] finderArgs = new Object[]{online};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_STATUS_WHERE);
            sb.append("status.online = ?");
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(online);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<Status> findByM_O(long modifiedDate, boolean online) {
        return this.findByM_O(modifiedDate, online, -1, -1, null);
    }

    public List<Status> findByM_O(long modifiedDate, boolean online, int start, int end) {
        return this.findByM_O(modifiedDate, online, start, end, null);
    }

    public List<Status> findByM_O(long modifiedDate, boolean online, int start, int end, OrderByComparator<Status> orderByComparator) {
        return this.findByM_O(modifiedDate, online, start, end, orderByComparator, true);
    }

    public List<Status> findByM_O(long modifiedDate, boolean online, int start, int end, OrderByComparator<Status> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByM_O;
                finderArgs = new Object[]{modifiedDate, online};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByM_O;
            finderArgs = new Object[]{modifiedDate, online, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (Status status : list) {
                if (modifiedDate == status.getModifiedDate() && online == status.isOnline()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            sb.append(_SQL_SELECT_STATUS_WHERE);
            sb.append(_FINDER_COLUMN_M_O_MODIFIEDDATE_2);
            sb.append("status.online = ?");
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY status.statusId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(modifiedDate);
                queryPos.add(online);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(finderPath, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public Status findByM_O_First(long modifiedDate, boolean online, OrderByComparator<Status> orderByComparator) throws NoSuchStatusException {
        Status status = this.fetchByM_O_First(modifiedDate, online, orderByComparator);
        if (status != null) {
            return status;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("modifiedDate=");
        sb.append(modifiedDate);
        sb.append(", online=");
        sb.append(online);
        sb.append("}");
        throw new NoSuchStatusException(sb.toString());
    }

    public Status fetchByM_O_First(long modifiedDate, boolean online, OrderByComparator<Status> orderByComparator) {
        List<Status> list = this.findByM_O(modifiedDate, online, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public Status findByM_O_Last(long modifiedDate, boolean online, OrderByComparator<Status> orderByComparator) throws NoSuchStatusException {
        Status status = this.fetchByM_O_Last(modifiedDate, online, orderByComparator);
        if (status != null) {
            return status;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("modifiedDate=");
        sb.append(modifiedDate);
        sb.append(", online=");
        sb.append(online);
        sb.append("}");
        throw new NoSuchStatusException(sb.toString());
    }

    public Status fetchByM_O_Last(long modifiedDate, boolean online, OrderByComparator<Status> orderByComparator) {
        int count = this.countByM_O(modifiedDate, online);
        if (count == 0) {
            return null;
        }
        List<Status> list = this.findByM_O(modifiedDate, online, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public Status[] findByM_O_PrevAndNext(long statusId, long modifiedDate, boolean online, OrderByComparator<Status> orderByComparator) throws NoSuchStatusException {
        Status status = this.findByPrimaryKey(statusId);
        Session session = null;
        try {
            session = this.openSession();
            Status[] array = new StatusImpl[]{this.getByM_O_PrevAndNext(session, status, modifiedDate, online, orderByComparator, true), status, this.getByM_O_PrevAndNext(session, status, modifiedDate, online, orderByComparator, false)};
            Status[] statusArray = array;
            return statusArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Status getByM_O_PrevAndNext(Session session, Status status, long modifiedDate, boolean online, OrderByComparator<Status> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        sb.append(_SQL_SELECT_STATUS_WHERE);
        sb.append(_FINDER_COLUMN_M_O_MODIFIEDDATE_2);
        sb.append("status.online = ?");
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY status.statusId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(modifiedDate);
        queryPos.add(online);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)status)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (Status)list.get(1);
        }
        return null;
    }

    public void removeByM_O(long modifiedDate, boolean online) {
        for (Status status : this.findByM_O(modifiedDate, online, -1, -1, null)) {
            this.remove((BaseModel)status);
        }
    }

    public int countByM_O(long modifiedDate, boolean online) {
        FinderPath finderPath = this._finderPathCountByM_O;
        Object[] finderArgs = new Object[]{modifiedDate, online};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_STATUS_WHERE);
            sb.append(_FINDER_COLUMN_M_O_MODIFIEDDATE_2);
            sb.append("status.online = ?");
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(modifiedDate);
                queryPos.add(online);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public StatusPersistenceImpl() {
        HashMap<String, String> dbColumnNames = new HashMap<String, String>();
        dbColumnNames.put("online", "online_");
        this.setDBColumnNames(dbColumnNames);
        this.setModelClass(Status.class);
        this.setModelImplClass(StatusImpl.class);
        this.setModelPKClass(Long.TYPE);
    }

    public void cacheResult(Status status) {
        this.entityCache.putResult(this.entityCacheEnabled, StatusImpl.class, (Serializable)Long.valueOf(status.getPrimaryKey()), (Serializable)status);
        this.finderCache.putResult(this._finderPathFetchByUserId, new Object[]{status.getUserId()}, (Object)status);
        status.resetOriginalValues();
    }

    public void cacheResult(List<Status> statuses) {
        if (this._valueObjectFinderCacheListThreshold == 0 || this._valueObjectFinderCacheListThreshold > 0 && statuses.size() > this._valueObjectFinderCacheListThreshold) {
            return;
        }
        for (Status status : statuses) {
            if (this.entityCache.getResult(this.entityCacheEnabled, StatusImpl.class, (Serializable)Long.valueOf(status.getPrimaryKey())) == null) {
                this.cacheResult(status);
                continue;
            }
            status.resetOriginalValues();
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(StatusImpl.class);
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    public void clearCache(Status status) {
        this.entityCache.removeResult(this.entityCacheEnabled, StatusImpl.class, (Serializable)Long.valueOf(status.getPrimaryKey()));
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        this.clearUniqueFindersCache((StatusModelImpl)status, true);
    }

    public void clearCache(List<Status> statuses) {
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (Status status : statuses) {
            this.entityCache.removeResult(this.entityCacheEnabled, StatusImpl.class, (Serializable)Long.valueOf(status.getPrimaryKey()));
            this.clearUniqueFindersCache((StatusModelImpl)status, true);
        }
    }

    public void clearCache(Set<Serializable> primaryKeys) {
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (Serializable primaryKey : primaryKeys) {
            this.entityCache.removeResult(this.entityCacheEnabled, StatusImpl.class, primaryKey);
        }
    }

    protected void cacheUniqueFindersCache(StatusModelImpl statusModelImpl) {
        Object[] args = new Object[]{statusModelImpl.getUserId()};
        this.finderCache.putResult(this._finderPathCountByUserId, args, (Object)1L, false);
        this.finderCache.putResult(this._finderPathFetchByUserId, args, (Object)statusModelImpl, false);
    }

    protected void clearUniqueFindersCache(StatusModelImpl statusModelImpl, boolean clearCurrent) {
        Object[] args;
        if (clearCurrent) {
            args = new Object[]{statusModelImpl.getUserId()};
            this.finderCache.removeResult(this._finderPathCountByUserId, args);
            this.finderCache.removeResult(this._finderPathFetchByUserId, args);
        }
        if ((statusModelImpl.getColumnBitmask() & this._finderPathFetchByUserId.getColumnBitmask()) != 0L) {
            args = new Object[]{statusModelImpl.getOriginalUserId()};
            this.finderCache.removeResult(this._finderPathCountByUserId, args);
            this.finderCache.removeResult(this._finderPathFetchByUserId, args);
        }
    }

    public Status create(long statusId) {
        StatusImpl status = new StatusImpl();
        status.setNew(true);
        status.setPrimaryKey(statusId);
        return status;
    }

    public Status remove(long statusId) throws NoSuchStatusException {
        return this.remove(Long.valueOf(statusId));
    }

    public Status remove(Serializable primaryKey) throws NoSuchStatusException {
        Session session = null;
        try {
            session = this.openSession();
            Status status = (Status)session.get(StatusImpl.class, primaryKey);
            if (status == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchStatusException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            Status status2 = (Status)this.remove((BaseModel)status);
            return status2;
        }
        catch (NoSuchStatusException noSuchEntityException) {
            throw noSuchEntityException;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Status removeImpl(Status status) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)status)) {
                status = (Status)session.get(StatusImpl.class, status.getPrimaryKeyObj());
            }
            if (status != null) {
                session.delete((Object)status);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        if (status != null) {
            this.clearCache(status);
        }
        return status;
    }

    public Status updateImpl(Status status) {
        boolean isNew = status.isNew();
        if (!(status instanceof StatusModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(status.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler((Object)status);
                throw new IllegalArgumentException("Implement ModelWrapper in status proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom Status implementation " + status.getClass());
        }
        StatusModelImpl statusModelImpl = (StatusModelImpl)status;
        Session session = null;
        try {
            session = this.openSession();
            if (isNew) {
                session.save((Object)status);
                status.setNew(false);
            } else {
                status = (Status)session.merge((Object)status);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        if (!this._columnBitmaskEnabled) {
            this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        } else if (isNew) {
            Object[] args = new Object[]{statusModelImpl.getModifiedDate()};
            this.finderCache.removeResult(this._finderPathCountByModifiedDate, args);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindByModifiedDate, args);
            args = new Object[]{statusModelImpl.isOnline()};
            this.finderCache.removeResult(this._finderPathCountByOnline, args);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindByOnline, args);
            args = new Object[]{statusModelImpl.getModifiedDate(), statusModelImpl.isOnline()};
            this.finderCache.removeResult(this._finderPathCountByM_O, args);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindByM_O, args);
            this.finderCache.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindAll, FINDER_ARGS_EMPTY);
        } else {
            Object[] args;
            if ((statusModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByModifiedDate.getColumnBitmask()) != 0L) {
                args = new Object[]{statusModelImpl.getOriginalModifiedDate()};
                this.finderCache.removeResult(this._finderPathCountByModifiedDate, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByModifiedDate, args);
                args = new Object[]{statusModelImpl.getModifiedDate()};
                this.finderCache.removeResult(this._finderPathCountByModifiedDate, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByModifiedDate, args);
            }
            if ((statusModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByOnline.getColumnBitmask()) != 0L) {
                args = new Object[]{statusModelImpl.getOriginalOnline()};
                this.finderCache.removeResult(this._finderPathCountByOnline, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByOnline, args);
                args = new Object[]{statusModelImpl.isOnline()};
                this.finderCache.removeResult(this._finderPathCountByOnline, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByOnline, args);
            }
            if ((statusModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByM_O.getColumnBitmask()) != 0L) {
                args = new Object[]{statusModelImpl.getOriginalModifiedDate(), statusModelImpl.getOriginalOnline()};
                this.finderCache.removeResult(this._finderPathCountByM_O, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByM_O, args);
                args = new Object[]{statusModelImpl.getModifiedDate(), statusModelImpl.isOnline()};
                this.finderCache.removeResult(this._finderPathCountByM_O, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByM_O, args);
            }
        }
        this.entityCache.putResult(this.entityCacheEnabled, StatusImpl.class, (Serializable)Long.valueOf(status.getPrimaryKey()), (Serializable)status, false);
        this.clearUniqueFindersCache(statusModelImpl, false);
        this.cacheUniqueFindersCache(statusModelImpl);
        status.resetOriginalValues();
        return status;
    }

    public Status findByPrimaryKey(Serializable primaryKey) throws NoSuchStatusException {
        Status status = (Status)this.fetchByPrimaryKey(primaryKey);
        if (status == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchStatusException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return status;
    }

    public Status findByPrimaryKey(long statusId) throws NoSuchStatusException {
        return this.findByPrimaryKey(Long.valueOf(statusId));
    }

    public Status fetchByPrimaryKey(long statusId) {
        return (Status)this.fetchByPrimaryKey(Long.valueOf(statusId));
    }

    public List<Status> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<Status> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<Status> findAll(int start, int end, OrderByComparator<Status> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<Status> findAll(int start, int end, OrderByComparator<Status> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindAll;
                finderArgs = FINDER_ARGS_EMPTY;
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        }
        if (list == null) {
            StringBundler sb = null;
            String sql = null;
            if (orderByComparator != null) {
                sb = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                sb.append(_SQL_SELECT_STATUS);
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = sb.toString();
            } else {
                sql = _SQL_SELECT_STATUS;
                sql = sql.concat(" ORDER BY status.statusId ASC");
            }
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(finderPath, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (Status status : this.findAll()) {
            this.remove((BaseModel)status);
        }
    }

    public int countAll() {
        Long count = (Long)this.finderCache.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (BasePersistenceImpl)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(_SQL_COUNT_STATUS);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public Set<String> getBadColumnNames() {
        return _badColumnNames;
    }

    protected EntityCache getEntityCache() {
        return this.entityCache;
    }

    protected String getPKDBName() {
        return "statusId";
    }

    protected String getSelectSQL() {
        return _SQL_SELECT_STATUS;
    }

    protected Map<String, Integer> getTableColumnsMap() {
        return StatusModelImpl.TABLE_COLUMNS_MAP;
    }

    @Activate
    public void activate() {
        StatusModelImpl.setEntityCacheEnabled(this.entityCacheEnabled);
        StatusModelImpl.setFinderCacheEnabled(this.finderCacheEnabled);
        this._valueObjectFinderCacheListThreshold = GetterUtil.getInteger((String)PropsUtil.get((String)"value.object.finder.cache.list.threshold"));
        this._finderPathWithPaginationFindAll = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, StatusImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
        this._finderPathWithoutPaginationFindAll = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, StatusImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
        this._finderPathCountAll = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
        this._finderPathFetchByUserId = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, StatusImpl.class, FINDER_CLASS_NAME_ENTITY, "fetchByUserId", new String[]{Long.class.getName()}, 4L);
        this._finderPathCountByUserId = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUserId", new String[]{Long.class.getName()});
        this._finderPathWithPaginationFindByModifiedDate = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, StatusImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByModifiedDate", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByModifiedDate = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, StatusImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByModifiedDate", new String[]{Long.class.getName()}, 1L);
        this._finderPathCountByModifiedDate = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByModifiedDate", new String[]{Long.class.getName()});
        this._finderPathWithPaginationFindByOnline = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, StatusImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByOnline", new String[]{Boolean.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByOnline = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, StatusImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByOnline", new String[]{Boolean.class.getName()}, 2L);
        this._finderPathCountByOnline = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByOnline", new String[]{Boolean.class.getName()});
        this._finderPathWithPaginationFindByM_O = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, StatusImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByM_O", new String[]{Long.class.getName(), Boolean.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByM_O = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, StatusImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByM_O", new String[]{Long.class.getName(), Boolean.class.getName()}, 3L);
        this._finderPathCountByM_O = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByM_O", new String[]{Long.class.getName(), Boolean.class.getName()});
        StatusUtil.setPersistence((StatusPersistence)this);
    }

    @Deactivate
    public void deactivate() {
        StatusUtil.setPersistence(null);
        this.entityCache.removeCache(StatusImpl.class.getName());
        this.finderCache.removeCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    @Reference(target="(&(origin.bundle.symbolic.name=com.liferay.chat.service)(name=service))", unbind="-")
    public void setConfiguration(Configuration configuration) {
        super.setConfiguration(configuration);
        this._columnBitmaskEnabled = GetterUtil.getBoolean((String)configuration.get("value.object.column.bitmask.enabled.com.liferay.chat.model.Status"), (boolean)true);
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.chat.service)", unbind="-")
    public void setDataSource(DataSource dataSource) {
        super.setDataSource(dataSource);
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.chat.service)", unbind="-")
    public void setSessionFactory(SessionFactory sessionFactory) {
        super.setSessionFactory(sessionFactory);
    }
}

