/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.chat.service.impl;

import com.liferay.chat.internal.jabber.JabberUtil;
import com.liferay.chat.model.Entry;
import com.liferay.chat.model.Status;
import com.liferay.chat.service.base.StatusLocalServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;
import org.osgi.service.component.annotations.Component;

@Component(property={"model.class.name=com.liferay.chat.model.Status"}, service={AopService.class})
public class StatusLocalServiceImpl
extends StatusLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(StatusLocalServiceImpl.class);

    public List<Object[]> getAllStatuses(long companyId, long userId, long modifiedDate, int start, int end) {
        return this.statusFinder.findByModifiedDate(companyId, userId, modifiedDate, start, end);
    }

    public List<Object[]> getGroupStatuses(long userId, long modifiedDate, String[] groupNames, int start, int end) {
        return this.statusFinder.findByUsersGroups(userId, modifiedDate, groupNames, start, end);
    }

    public List<Object[]> getSocialStatuses(long userId, int type, long modifiedDate, int start, int end) {
        return this.getSocialStatuses(userId, new int[]{type}, modifiedDate, start, end);
    }

    public List<Object[]> getSocialStatuses(long userId, int[] types, long modifiedDate, int start, int end) {
        return this.statusFinder.findBySocialRelationTypes(userId, types, modifiedDate, start, end);
    }

    public Status getUserStatus(long userId) {
        Status status = this.statusPersistence.fetchByUserId(userId);
        if (status == null) {
            status = this.statusLocalService.updateStatus(userId, System.currentTimeMillis(), 1, 1, "", "", 1);
        }
        return status;
    }

    public Status updateStatus(long userId, long modifiedDate) {
        return this.updateStatus(userId, modifiedDate, -1, -1, null, null, -1);
    }

    public Status updateStatus(long userId, long modifiedDate, int online, int awake, String activePanelIds, String message, int playSound) {
        Status status;
        block13: {
            status = this.statusPersistence.fetchByUserId(userId);
            if (status == null) {
                long statusId = this.counterLocalService.increment();
                status = this.statusPersistence.create(statusId);
                status.setUserId(userId);
            }
            if (modifiedDate != -1L) {
                status.setModifiedDate(modifiedDate);
            }
            if (online != -1) {
                status.setOnline(online == 1);
            }
            if (awake != -1) {
                status.setAwake(awake == 1);
            }
            if (Validator.isNotNull((String)activePanelIds)) {
                try {
                    JSONObject activePanelIdsJSONObject = JSONFactoryUtil.createJSONObject((String)activePanelIds);
                    long openPanelId = activePanelIdsJSONObject.getLong("open");
                    List entries = this.entryPersistence.findByF_T(openPanelId, userId);
                    for (Entry entry : entries) {
                        entry.setFlag(1);
                        this.entryPersistence.update((BaseModel)entry);
                    }
                }
                catch (JSONException jsonException) {
                    _log.error((Object)("Unable to create a JSON object from " + activePanelIds), (Throwable)jsonException);
                }
                status.setActivePanelIds(activePanelIds);
            }
            if (message != null) {
                status.setMessage(message);
            }
            if (playSound != -1) {
                status.setPlaySound(playSound == 1);
            }
            try {
                status = (Status)this.statusPersistence.update((BaseModel)status);
            }
            catch (SystemException systemException) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("Add failed, fetch {userId=" + userId + "}"));
                }
                if ((status = this.statusPersistence.fetchByUserId(userId)) != null) break block13;
                throw systemException;
            }
        }
        JabberUtil.updateStatus(userId, online);
        return status;
    }
}

