/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.chat.service.impl;

import com.liferay.chat.internal.jabber.JabberUtil;
import com.liferay.chat.model.Entry;
import com.liferay.chat.service.base.EntryLocalServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.db.DBType;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;
import org.osgi.service.component.annotations.Component;

@Component(property={"model.class.name=com.liferay.chat.model.Entry"}, service={AopService.class})
public class EntryLocalServiceImpl
extends EntryLocalServiceBaseImpl {
    public Entry addEntry(long createDate, long fromUserId, long toUserId, String content) {
        List entries = this.entryFinder.findByEmptyContent(fromUserId, toUserId, 0, 5);
        for (Entry entry : entries) {
            this.entryPersistence.remove((BaseModel)entry);
        }
        if (Validator.isNull((String)content)) {
            content = "";
        } else {
            int contentMaxLength = 500;
            DB db = DBManagerUtil.getDB();
            if (db.getDBType() == DBType.SQLSERVER) {
                contentMaxLength = 442;
            }
            if (content.length() > contentMaxLength) {
                content = content.substring(0, contentMaxLength);
            }
        }
        long entryId = this.counterLocalService.increment();
        Entry entry = this.entryPersistence.create(entryId);
        entry.setCreateDate(createDate);
        entry.setFromUserId(fromUserId);
        entry.setToUserId(toUserId);
        entry.setContent(content);
        entry = (Entry)this.entryPersistence.update((BaseModel)entry);
        JabberUtil.sendMessage(fromUserId, toUserId, content);
        return entry;
    }

    public Entry addEntry(long fromUserId, long toUserId, String content) {
        long createDate = System.currentTimeMillis();
        return this.addEntry(createDate, fromUserId, toUserId, content);
    }

    public void deleteEntries(long userId) {
        this.entryPersistence.removeByFromUserId(userId);
        this.entryPersistence.removeByToUserId(userId);
    }

    public List<Entry> getNewEntries(long userId, long createDate, int start, int end) {
        return this.entryFinder.findByNew(userId, createDate, start, end);
    }

    public List<Entry> getOldEntries(long createDate, int start, int end) {
        return this.entryFinder.findByOld(createDate, start, end);
    }
}

