/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.chat.internal.model.listener;

import com.liferay.chat.internal.jabber.JabberUtil;
import com.liferay.chat.model.Status;
import com.liferay.chat.service.EntryLocalServiceUtil;
import com.liferay.chat.service.StatusLocalServiceUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.model.User;
import org.osgi.service.component.annotations.Component;

@Component(enabled=false, immediate=true, service={ModelListener.class})
public class UserModelListener
extends BaseModelListener<User> {
    private static final Log _log = LogFactoryUtil.getLog(UserModelListener.class);

    public void onAfterRemove(User user) {
        try {
            if (user != null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Removing chat entries and status for user " + user.getUserId()));
                }
                EntryLocalServiceUtil.deleteEntries((long)user.getUserId());
                Status status = StatusLocalServiceUtil.getUserStatus((long)user.getUserId());
                if (status != null) {
                    StatusLocalServiceUtil.deleteStatus((Status)status);
                }
            }
        }
        catch (Exception exception) {
            _log.error((Object)("Unable to remove chat entries and status for user " + user.getUserId()));
        }
    }

    public void onAfterUpdate(User user) {
        JabberUtil.updatePassword(user.getUserId(), user.getPasswordUnencrypted());
    }
}

