/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.chat.internal.jabber;

import com.liferay.chat.internal.configuration.ChatGroupServiceConfiguration;
import com.liferay.chat.internal.jabber.JabberUtil;
import com.liferay.chat.service.EntryLocalServiceUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.module.configuration.ConfigurationProviderUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import org.jivesoftware.smack.Chat;
import org.jivesoftware.smack.MessageListener;
import org.jivesoftware.smack.packet.Message;

public class JabberMessageListener
implements MessageListener {
    private static final Log _log = LogFactoryUtil.getLog(JabberMessageListener.class);
    private final ChatGroupServiceConfiguration _chatGroupServiceConfiguration;
    private final long _companyId;
    private final long _userId;

    public JabberMessageListener(long companyId, long userId) {
        this._companyId = companyId;
        this._userId = userId;
        this._chatGroupServiceConfiguration = this._getChatGroupServiceConfiguration();
    }

    public void processMessage(Chat chat, Message message) {
        try {
            String body = message.getBody();
            if (Validator.isNull((String)body)) {
                return;
            }
            String from = message.getFrom();
            if (StringUtil.equalsIgnoreCase((String)JabberUtil.getResource(from), (String)this._chatGroupServiceConfiguration.jabberResource())) {
                return;
            }
            long fromUserId = UserLocalServiceUtil.getUserIdByScreenName((long)this._companyId, (String)JabberUtil.getScreenName(from));
            EntryLocalServiceUtil.addEntry((long)fromUserId, (long)this._userId, (String)body);
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
        }
    }

    private ChatGroupServiceConfiguration _getChatGroupServiceConfiguration() {
        try {
            return (ChatGroupServiceConfiguration)ConfigurationProviderUtil.getCompanyConfiguration(ChatGroupServiceConfiguration.class, (long)this._companyId);
        }
        catch (ConfigurationException configurationException) {
            _log.error((Object)"Unable to load chat group service configuration", (Throwable)configurationException);
            return null;
        }
    }
}

