/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.chat.service.persistence.impl;

import aQute.bnd.annotation.ProviderType;
import com.liferay.chat.exception.NoSuchStatusException;
import com.liferay.chat.model.Status;
import com.liferay.chat.model.impl.StatusImpl;
import com.liferay.chat.model.impl.StatusModelImpl;
import com.liferay.chat.service.persistence.StatusPersistence;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

@ProviderType
public class StatusPersistenceImpl
extends BasePersistenceImpl<Status>
implements StatusPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = StatusImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_ALL = new FinderPath(StatusModelImpl.ENTITY_CACHE_ENABLED, StatusModelImpl.FINDER_CACHE_ENABLED, StatusImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL = new FinderPath(StatusModelImpl.ENTITY_CACHE_ENABLED, StatusModelImpl.FINDER_CACHE_ENABLED, StatusImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_COUNT_ALL = new FinderPath(StatusModelImpl.ENTITY_CACHE_ENABLED, StatusModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
    public static final FinderPath FINDER_PATH_FETCH_BY_USERID = new FinderPath(StatusModelImpl.ENTITY_CACHE_ENABLED, StatusModelImpl.FINDER_CACHE_ENABLED, StatusImpl.class, FINDER_CLASS_NAME_ENTITY, "fetchByUserId", new String[]{Long.class.getName()}, 4L);
    public static final FinderPath FINDER_PATH_COUNT_BY_USERID = new FinderPath(StatusModelImpl.ENTITY_CACHE_ENABLED, StatusModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUserId", new String[]{Long.class.getName()});
    private static final String _FINDER_COLUMN_USERID_USERID_2 = "status.userId = ?";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_MODIFIEDDATE = new FinderPath(StatusModelImpl.ENTITY_CACHE_ENABLED, StatusModelImpl.FINDER_CACHE_ENABLED, StatusImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByModifiedDate", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_MODIFIEDDATE = new FinderPath(StatusModelImpl.ENTITY_CACHE_ENABLED, StatusModelImpl.FINDER_CACHE_ENABLED, StatusImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByModifiedDate", new String[]{Long.class.getName()}, 1L);
    public static final FinderPath FINDER_PATH_COUNT_BY_MODIFIEDDATE = new FinderPath(StatusModelImpl.ENTITY_CACHE_ENABLED, StatusModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByModifiedDate", new String[]{Long.class.getName()});
    private static final String _FINDER_COLUMN_MODIFIEDDATE_MODIFIEDDATE_2 = "status.modifiedDate = ?";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_ONLINE = new FinderPath(StatusModelImpl.ENTITY_CACHE_ENABLED, StatusModelImpl.FINDER_CACHE_ENABLED, StatusImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByOnline", new String[]{Boolean.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_ONLINE = new FinderPath(StatusModelImpl.ENTITY_CACHE_ENABLED, StatusModelImpl.FINDER_CACHE_ENABLED, StatusImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByOnline", new String[]{Boolean.class.getName()}, 2L);
    public static final FinderPath FINDER_PATH_COUNT_BY_ONLINE = new FinderPath(StatusModelImpl.ENTITY_CACHE_ENABLED, StatusModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByOnline", new String[]{Boolean.class.getName()});
    private static final String _FINDER_COLUMN_ONLINE_ONLINE_2 = "status.online = ?";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_M_O = new FinderPath(StatusModelImpl.ENTITY_CACHE_ENABLED, StatusModelImpl.FINDER_CACHE_ENABLED, StatusImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByM_O", new String[]{Long.class.getName(), Boolean.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_M_O = new FinderPath(StatusModelImpl.ENTITY_CACHE_ENABLED, StatusModelImpl.FINDER_CACHE_ENABLED, StatusImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByM_O", new String[]{Long.class.getName(), Boolean.class.getName()}, 3L);
    public static final FinderPath FINDER_PATH_COUNT_BY_M_O = new FinderPath(StatusModelImpl.ENTITY_CACHE_ENABLED, StatusModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByM_O", new String[]{Long.class.getName(), Boolean.class.getName()});
    private static final String _FINDER_COLUMN_M_O_MODIFIEDDATE_2 = "status.modifiedDate = ? AND ";
    private static final String _FINDER_COLUMN_M_O_ONLINE_2 = "status.online = ?";
    @ServiceReference(type=EntityCache.class)
    protected EntityCache entityCache;
    @ServiceReference(type=FinderCache.class)
    protected FinderCache finderCache;
    private static final String _SQL_SELECT_STATUS = "SELECT status FROM Status status";
    private static final String _SQL_SELECT_STATUS_WHERE_PKS_IN = "SELECT status FROM Status status WHERE statusId IN (";
    private static final String _SQL_SELECT_STATUS_WHERE = "SELECT status FROM Status status WHERE ";
    private static final String _SQL_COUNT_STATUS = "SELECT COUNT(status) FROM Status status";
    private static final String _SQL_COUNT_STATUS_WHERE = "SELECT COUNT(status) FROM Status status WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "status.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No Status exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No Status exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(StatusPersistenceImpl.class);
    private static final Set<String> _badColumnNames = SetUtil.fromArray((Object[])new String[]{"online"});

    public Status findByUserId(long userId) throws NoSuchStatusException {
        Status status = this.fetchByUserId(userId);
        if (status == null) {
            StringBundler msg = new StringBundler(4);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("userId=");
            msg.append(userId);
            msg.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)msg.toString());
            }
            throw new NoSuchStatusException(msg.toString());
        }
        return status;
    }

    public Status fetchByUserId(long userId) {
        return this.fetchByUserId(userId, true);
    }

    public Status fetchByUserId(long userId, boolean retrieveFromCache) {
        Status status;
        Object[] finderArgs = new Object[]{userId};
        Object result = null;
        if (retrieveFromCache) {
            result = this.finderCache.getResult(FINDER_PATH_FETCH_BY_USERID, finderArgs, (BasePersistenceImpl)this);
        }
        if (result instanceof Status && userId != (status = (Status)result).getUserId()) {
            result = null;
        }
        if (result == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_SELECT_STATUS_WHERE);
            query.append(_FINDER_COLUMN_USERID_USERID_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(userId);
                List list = q.list();
                if (list.isEmpty()) {
                    this.finderCache.putResult(FINDER_PATH_FETCH_BY_USERID, finderArgs, (Object)list);
                } else {
                    Status status2 = (Status)list.get(0);
                    result = status2;
                    this.cacheResult(status2);
                }
            }
            catch (Exception e) {
                this.finderCache.removeResult(FINDER_PATH_FETCH_BY_USERID, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (Status)result;
    }

    public Status removeByUserId(long userId) throws NoSuchStatusException {
        Status status = this.findByUserId(userId);
        return (Status)this.remove((BaseModel)status);
    }

    public int countByUserId(long userId) {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_USERID;
        Object[] finderArgs = new Object[]{userId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_STATUS_WHERE);
            query.append(_FINDER_COLUMN_USERID_USERID_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(userId);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<Status> findByModifiedDate(long modifiedDate) {
        return this.findByModifiedDate(modifiedDate, -1, -1, null);
    }

    public List<Status> findByModifiedDate(long modifiedDate, int start, int end) {
        return this.findByModifiedDate(modifiedDate, start, end, null);
    }

    public List<Status> findByModifiedDate(long modifiedDate, int start, int end, OrderByComparator<Status> orderByComparator) {
        return this.findByModifiedDate(modifiedDate, start, end, orderByComparator, true);
    }

    public List<Status> findByModifiedDate(long modifiedDate, int start, int end, OrderByComparator<Status> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_MODIFIEDDATE;
            finderArgs = new Object[]{modifiedDate};
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_MODIFIEDDATE;
            finderArgs = new Object[]{modifiedDate, start, end, orderByComparator};
        }
        List<Status> list = null;
        if (retrieveFromCache && (list = (List<Status>)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (Status status : list) {
                if (modifiedDate == status.getModifiedDate()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            query.append(_SQL_SELECT_STATUS_WHERE);
            query.append(_FINDER_COLUMN_MODIFIEDDATE_MODIFIEDDATE_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY status.statusId ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(modifiedDate);
                if (!pagination) {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                this.cacheResult(list);
                this.finderCache.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public Status findByModifiedDate_First(long modifiedDate, OrderByComparator<Status> orderByComparator) throws NoSuchStatusException {
        Status status = this.fetchByModifiedDate_First(modifiedDate, orderByComparator);
        if (status != null) {
            return status;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("modifiedDate=");
        msg.append(modifiedDate);
        msg.append("}");
        throw new NoSuchStatusException(msg.toString());
    }

    public Status fetchByModifiedDate_First(long modifiedDate, OrderByComparator<Status> orderByComparator) {
        List<Status> list = this.findByModifiedDate(modifiedDate, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public Status findByModifiedDate_Last(long modifiedDate, OrderByComparator<Status> orderByComparator) throws NoSuchStatusException {
        Status status = this.fetchByModifiedDate_Last(modifiedDate, orderByComparator);
        if (status != null) {
            return status;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("modifiedDate=");
        msg.append(modifiedDate);
        msg.append("}");
        throw new NoSuchStatusException(msg.toString());
    }

    public Status fetchByModifiedDate_Last(long modifiedDate, OrderByComparator<Status> orderByComparator) {
        int count = this.countByModifiedDate(modifiedDate);
        if (count == 0) {
            return null;
        }
        List<Status> list = this.findByModifiedDate(modifiedDate, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public Status[] findByModifiedDate_PrevAndNext(long statusId, long modifiedDate, OrderByComparator<Status> orderByComparator) throws NoSuchStatusException {
        Status status = this.findByPrimaryKey(statusId);
        Session session = null;
        try {
            session = this.openSession();
            Status[] array = new StatusImpl[]{this.getByModifiedDate_PrevAndNext(session, status, modifiedDate, orderByComparator, true), status, this.getByModifiedDate_PrevAndNext(session, status, modifiedDate, orderByComparator, false)};
            Status[] statusArray = array;
            return statusArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Status getByModifiedDate_PrevAndNext(Session session, Status status, long modifiedDate, OrderByComparator<Status> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        query.append(_SQL_SELECT_STATUS_WHERE);
        query.append(_FINDER_COLUMN_MODIFIEDDATE_MODIFIEDDATE_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY status.statusId ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        qPos.add(modifiedDate);
        if (orderByComparator != null) {
            Object[] values;
            for (Object value : values = orderByComparator.getOrderByConditionValues((Object)status)) {
                qPos.add(value);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (Status)list.get(1);
        }
        return null;
    }

    public void removeByModifiedDate(long modifiedDate) {
        for (Status status : this.findByModifiedDate(modifiedDate, -1, -1, null)) {
            this.remove((BaseModel)status);
        }
    }

    public int countByModifiedDate(long modifiedDate) {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_MODIFIEDDATE;
        Object[] finderArgs = new Object[]{modifiedDate};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_STATUS_WHERE);
            query.append(_FINDER_COLUMN_MODIFIEDDATE_MODIFIEDDATE_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(modifiedDate);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<Status> findByOnline(boolean online) {
        return this.findByOnline(online, -1, -1, null);
    }

    public List<Status> findByOnline(boolean online, int start, int end) {
        return this.findByOnline(online, start, end, null);
    }

    public List<Status> findByOnline(boolean online, int start, int end, OrderByComparator<Status> orderByComparator) {
        return this.findByOnline(online, start, end, orderByComparator, true);
    }

    public List<Status> findByOnline(boolean online, int start, int end, OrderByComparator<Status> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_ONLINE;
            finderArgs = new Object[]{online};
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_ONLINE;
            finderArgs = new Object[]{online, start, end, orderByComparator};
        }
        List<Status> list = null;
        if (retrieveFromCache && (list = (List<Status>)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (Status status : list) {
                if (online == status.isOnline()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            query.append(_SQL_SELECT_STATUS_WHERE);
            query.append("status.online = ?");
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY status.statusId ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(online);
                if (!pagination) {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                this.cacheResult(list);
                this.finderCache.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public Status findByOnline_First(boolean online, OrderByComparator<Status> orderByComparator) throws NoSuchStatusException {
        Status status = this.fetchByOnline_First(online, orderByComparator);
        if (status != null) {
            return status;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("online=");
        msg.append(online);
        msg.append("}");
        throw new NoSuchStatusException(msg.toString());
    }

    public Status fetchByOnline_First(boolean online, OrderByComparator<Status> orderByComparator) {
        List<Status> list = this.findByOnline(online, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public Status findByOnline_Last(boolean online, OrderByComparator<Status> orderByComparator) throws NoSuchStatusException {
        Status status = this.fetchByOnline_Last(online, orderByComparator);
        if (status != null) {
            return status;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("online=");
        msg.append(online);
        msg.append("}");
        throw new NoSuchStatusException(msg.toString());
    }

    public Status fetchByOnline_Last(boolean online, OrderByComparator<Status> orderByComparator) {
        int count = this.countByOnline(online);
        if (count == 0) {
            return null;
        }
        List<Status> list = this.findByOnline(online, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public Status[] findByOnline_PrevAndNext(long statusId, boolean online, OrderByComparator<Status> orderByComparator) throws NoSuchStatusException {
        Status status = this.findByPrimaryKey(statusId);
        Session session = null;
        try {
            session = this.openSession();
            Status[] array = new StatusImpl[]{this.getByOnline_PrevAndNext(session, status, online, orderByComparator, true), status, this.getByOnline_PrevAndNext(session, status, online, orderByComparator, false)};
            Status[] statusArray = array;
            return statusArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Status getByOnline_PrevAndNext(Session session, Status status, boolean online, OrderByComparator<Status> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        query.append(_SQL_SELECT_STATUS_WHERE);
        query.append("status.online = ?");
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY status.statusId ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        qPos.add(online);
        if (orderByComparator != null) {
            Object[] values;
            for (Object value : values = orderByComparator.getOrderByConditionValues((Object)status)) {
                qPos.add(value);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (Status)list.get(1);
        }
        return null;
    }

    public void removeByOnline(boolean online) {
        for (Status status : this.findByOnline(online, -1, -1, null)) {
            this.remove((BaseModel)status);
        }
    }

    public int countByOnline(boolean online) {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_ONLINE;
        Object[] finderArgs = new Object[]{online};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_STATUS_WHERE);
            query.append("status.online = ?");
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(online);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<Status> findByM_O(long modifiedDate, boolean online) {
        return this.findByM_O(modifiedDate, online, -1, -1, null);
    }

    public List<Status> findByM_O(long modifiedDate, boolean online, int start, int end) {
        return this.findByM_O(modifiedDate, online, start, end, null);
    }

    public List<Status> findByM_O(long modifiedDate, boolean online, int start, int end, OrderByComparator<Status> orderByComparator) {
        return this.findByM_O(modifiedDate, online, start, end, orderByComparator, true);
    }

    public List<Status> findByM_O(long modifiedDate, boolean online, int start, int end, OrderByComparator<Status> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_M_O;
            finderArgs = new Object[]{modifiedDate, online};
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_M_O;
            finderArgs = new Object[]{modifiedDate, online, start, end, orderByComparator};
        }
        List<Status> list = null;
        if (retrieveFromCache && (list = (List<Status>)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (Status status : list) {
                if (modifiedDate == status.getModifiedDate() && online == status.isOnline()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            query.append(_SQL_SELECT_STATUS_WHERE);
            query.append(_FINDER_COLUMN_M_O_MODIFIEDDATE_2);
            query.append("status.online = ?");
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY status.statusId ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(modifiedDate);
                qPos.add(online);
                if (!pagination) {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                this.cacheResult(list);
                this.finderCache.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public Status findByM_O_First(long modifiedDate, boolean online, OrderByComparator<Status> orderByComparator) throws NoSuchStatusException {
        Status status = this.fetchByM_O_First(modifiedDate, online, orderByComparator);
        if (status != null) {
            return status;
        }
        StringBundler msg = new StringBundler(6);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("modifiedDate=");
        msg.append(modifiedDate);
        msg.append(", online=");
        msg.append(online);
        msg.append("}");
        throw new NoSuchStatusException(msg.toString());
    }

    public Status fetchByM_O_First(long modifiedDate, boolean online, OrderByComparator<Status> orderByComparator) {
        List<Status> list = this.findByM_O(modifiedDate, online, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public Status findByM_O_Last(long modifiedDate, boolean online, OrderByComparator<Status> orderByComparator) throws NoSuchStatusException {
        Status status = this.fetchByM_O_Last(modifiedDate, online, orderByComparator);
        if (status != null) {
            return status;
        }
        StringBundler msg = new StringBundler(6);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("modifiedDate=");
        msg.append(modifiedDate);
        msg.append(", online=");
        msg.append(online);
        msg.append("}");
        throw new NoSuchStatusException(msg.toString());
    }

    public Status fetchByM_O_Last(long modifiedDate, boolean online, OrderByComparator<Status> orderByComparator) {
        int count = this.countByM_O(modifiedDate, online);
        if (count == 0) {
            return null;
        }
        List<Status> list = this.findByM_O(modifiedDate, online, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public Status[] findByM_O_PrevAndNext(long statusId, long modifiedDate, boolean online, OrderByComparator<Status> orderByComparator) throws NoSuchStatusException {
        Status status = this.findByPrimaryKey(statusId);
        Session session = null;
        try {
            session = this.openSession();
            Status[] array = new StatusImpl[]{this.getByM_O_PrevAndNext(session, status, modifiedDate, online, orderByComparator, true), status, this.getByM_O_PrevAndNext(session, status, modifiedDate, online, orderByComparator, false)};
            Status[] statusArray = array;
            return statusArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Status getByM_O_PrevAndNext(Session session, Status status, long modifiedDate, boolean online, OrderByComparator<Status> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        query.append(_SQL_SELECT_STATUS_WHERE);
        query.append(_FINDER_COLUMN_M_O_MODIFIEDDATE_2);
        query.append("status.online = ?");
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY status.statusId ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        qPos.add(modifiedDate);
        qPos.add(online);
        if (orderByComparator != null) {
            Object[] values;
            for (Object value : values = orderByComparator.getOrderByConditionValues((Object)status)) {
                qPos.add(value);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (Status)list.get(1);
        }
        return null;
    }

    public void removeByM_O(long modifiedDate, boolean online) {
        for (Status status : this.findByM_O(modifiedDate, online, -1, -1, null)) {
            this.remove((BaseModel)status);
        }
    }

    public int countByM_O(long modifiedDate, boolean online) {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_M_O;
        Object[] finderArgs = new Object[]{modifiedDate, online};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_COUNT_STATUS_WHERE);
            query.append(_FINDER_COLUMN_M_O_MODIFIEDDATE_2);
            query.append("status.online = ?");
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(modifiedDate);
                qPos.add(online);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public StatusPersistenceImpl() {
        block2: {
            this.setModelClass(Status.class);
            try {
                Field field = BasePersistenceImpl.class.getDeclaredField("_dbColumnNames");
                field.setAccessible(true);
                HashMap<String, String> dbColumnNames = new HashMap<String, String>();
                dbColumnNames.put("online", "online_");
                field.set((Object)this, dbColumnNames);
            }
            catch (Exception e) {
                if (!_log.isDebugEnabled()) break block2;
                _log.debug((Object)e, (Throwable)e);
            }
        }
    }

    public void cacheResult(Status status) {
        this.entityCache.putResult(StatusModelImpl.ENTITY_CACHE_ENABLED, StatusImpl.class, (Serializable)Long.valueOf(status.getPrimaryKey()), (Serializable)status);
        this.finderCache.putResult(FINDER_PATH_FETCH_BY_USERID, new Object[]{status.getUserId()}, (Object)status);
        status.resetOriginalValues();
    }

    public void cacheResult(List<Status> statuses) {
        for (Status status : statuses) {
            if (this.entityCache.getResult(StatusModelImpl.ENTITY_CACHE_ENABLED, StatusImpl.class, (Serializable)Long.valueOf(status.getPrimaryKey())) == null) {
                this.cacheResult(status);
                continue;
            }
            status.resetOriginalValues();
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(StatusImpl.class);
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    public void clearCache(Status status) {
        this.entityCache.removeResult(StatusModelImpl.ENTITY_CACHE_ENABLED, StatusImpl.class, (Serializable)Long.valueOf(status.getPrimaryKey()));
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        this.clearUniqueFindersCache((StatusModelImpl)status, true);
    }

    public void clearCache(List<Status> statuses) {
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (Status status : statuses) {
            this.entityCache.removeResult(StatusModelImpl.ENTITY_CACHE_ENABLED, StatusImpl.class, (Serializable)Long.valueOf(status.getPrimaryKey()));
            this.clearUniqueFindersCache((StatusModelImpl)status, true);
        }
    }

    protected void cacheUniqueFindersCache(StatusModelImpl statusModelImpl) {
        Object[] args = new Object[]{statusModelImpl.getUserId()};
        this.finderCache.putResult(FINDER_PATH_COUNT_BY_USERID, args, (Object)1L, false);
        this.finderCache.putResult(FINDER_PATH_FETCH_BY_USERID, args, (Object)statusModelImpl, false);
    }

    protected void clearUniqueFindersCache(StatusModelImpl statusModelImpl, boolean clearCurrent) {
        Object[] args;
        if (clearCurrent) {
            args = new Object[]{statusModelImpl.getUserId()};
            this.finderCache.removeResult(FINDER_PATH_COUNT_BY_USERID, args);
            this.finderCache.removeResult(FINDER_PATH_FETCH_BY_USERID, args);
        }
        if ((statusModelImpl.getColumnBitmask() & FINDER_PATH_FETCH_BY_USERID.getColumnBitmask()) != 0L) {
            args = new Object[]{statusModelImpl.getOriginalUserId()};
            this.finderCache.removeResult(FINDER_PATH_COUNT_BY_USERID, args);
            this.finderCache.removeResult(FINDER_PATH_FETCH_BY_USERID, args);
        }
    }

    public Status create(long statusId) {
        StatusImpl status = new StatusImpl();
        status.setNew(true);
        status.setPrimaryKey(statusId);
        return status;
    }

    public Status remove(long statusId) throws NoSuchStatusException {
        return this.remove(Long.valueOf(statusId));
    }

    public Status remove(Serializable primaryKey) throws NoSuchStatusException {
        Session session = null;
        try {
            session = this.openSession();
            Status status = (Status)session.get(StatusImpl.class, primaryKey);
            if (status == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchStatusException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            Status status2 = (Status)this.remove((BaseModel)status);
            return status2;
        }
        catch (NoSuchStatusException nsee) {
            throw nsee;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Status removeImpl(Status status) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)status)) {
                status = (Status)session.get(StatusImpl.class, status.getPrimaryKeyObj());
            }
            if (status != null) {
                session.delete((Object)status);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        if (status != null) {
            this.clearCache(status);
        }
        return status;
    }

    public Status updateImpl(Status status) {
        boolean isNew = status.isNew();
        if (!(status instanceof StatusModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(status.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler((Object)status);
                throw new IllegalArgumentException("Implement ModelWrapper in status proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom Status implementation " + status.getClass());
        }
        StatusModelImpl statusModelImpl = (StatusModelImpl)status;
        Session session = null;
        try {
            session = this.openSession();
            if (status.isNew()) {
                session.save((Object)status);
                status.setNew(false);
            } else {
                status = (Status)session.merge((Object)status);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        if (!StatusModelImpl.COLUMN_BITMASK_ENABLED) {
            this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        } else if (isNew) {
            Object[] args = new Object[]{statusModelImpl.getModifiedDate()};
            this.finderCache.removeResult(FINDER_PATH_COUNT_BY_MODIFIEDDATE, args);
            this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_MODIFIEDDATE, args);
            args = new Object[]{statusModelImpl.isOnline()};
            this.finderCache.removeResult(FINDER_PATH_COUNT_BY_ONLINE, args);
            this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_ONLINE, args);
            args = new Object[]{statusModelImpl.getModifiedDate(), statusModelImpl.isOnline()};
            this.finderCache.removeResult(FINDER_PATH_COUNT_BY_M_O, args);
            this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_M_O, args);
            this.finderCache.removeResult(FINDER_PATH_COUNT_ALL, FINDER_ARGS_EMPTY);
            this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL, FINDER_ARGS_EMPTY);
        } else {
            Object[] args;
            if ((statusModelImpl.getColumnBitmask() & FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_MODIFIEDDATE.getColumnBitmask()) != 0L) {
                args = new Object[]{statusModelImpl.getOriginalModifiedDate()};
                this.finderCache.removeResult(FINDER_PATH_COUNT_BY_MODIFIEDDATE, args);
                this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_MODIFIEDDATE, args);
                args = new Object[]{statusModelImpl.getModifiedDate()};
                this.finderCache.removeResult(FINDER_PATH_COUNT_BY_MODIFIEDDATE, args);
                this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_MODIFIEDDATE, args);
            }
            if ((statusModelImpl.getColumnBitmask() & FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_ONLINE.getColumnBitmask()) != 0L) {
                args = new Object[]{statusModelImpl.getOriginalOnline()};
                this.finderCache.removeResult(FINDER_PATH_COUNT_BY_ONLINE, args);
                this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_ONLINE, args);
                args = new Object[]{statusModelImpl.isOnline()};
                this.finderCache.removeResult(FINDER_PATH_COUNT_BY_ONLINE, args);
                this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_ONLINE, args);
            }
            if ((statusModelImpl.getColumnBitmask() & FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_M_O.getColumnBitmask()) != 0L) {
                args = new Object[]{statusModelImpl.getOriginalModifiedDate(), statusModelImpl.getOriginalOnline()};
                this.finderCache.removeResult(FINDER_PATH_COUNT_BY_M_O, args);
                this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_M_O, args);
                args = new Object[]{statusModelImpl.getModifiedDate(), statusModelImpl.isOnline()};
                this.finderCache.removeResult(FINDER_PATH_COUNT_BY_M_O, args);
                this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_M_O, args);
            }
        }
        this.entityCache.putResult(StatusModelImpl.ENTITY_CACHE_ENABLED, StatusImpl.class, (Serializable)Long.valueOf(status.getPrimaryKey()), (Serializable)status, false);
        this.clearUniqueFindersCache(statusModelImpl, false);
        this.cacheUniqueFindersCache(statusModelImpl);
        status.resetOriginalValues();
        return status;
    }

    public Status findByPrimaryKey(Serializable primaryKey) throws NoSuchStatusException {
        Status status = this.fetchByPrimaryKey(primaryKey);
        if (status == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchStatusException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return status;
    }

    public Status findByPrimaryKey(long statusId) throws NoSuchStatusException {
        return this.findByPrimaryKey(Long.valueOf(statusId));
    }

    public Status fetchByPrimaryKey(Serializable primaryKey) {
        Serializable serializable = this.entityCache.getResult(StatusModelImpl.ENTITY_CACHE_ENABLED, StatusImpl.class, primaryKey);
        if (serializable == nullModel) {
            return null;
        }
        Status status = (Status)serializable;
        if (status == null) {
            Session session = null;
            try {
                session = this.openSession();
                status = (Status)session.get(StatusImpl.class, primaryKey);
                if (status != null) {
                    this.cacheResult(status);
                } else {
                    this.entityCache.putResult(StatusModelImpl.ENTITY_CACHE_ENABLED, StatusImpl.class, primaryKey, (Serializable)nullModel);
                }
            }
            catch (Exception e) {
                this.entityCache.removeResult(StatusModelImpl.ENTITY_CACHE_ENABLED, StatusImpl.class, primaryKey);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return status;
    }

    public Status fetchByPrimaryKey(long statusId) {
        return this.fetchByPrimaryKey(Long.valueOf(statusId));
    }

    public Map<Serializable, Status> fetchByPrimaryKeys(Set<Serializable> primaryKeys) {
        Session session;
        if (primaryKeys.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Serializable, Status> map = new HashMap<Serializable, Status>();
        if (primaryKeys.size() == 1) {
            Iterator<Serializable> iterator = primaryKeys.iterator();
            Serializable primaryKey = iterator.next();
            Status status = this.fetchByPrimaryKey(primaryKey);
            if (status != null) {
                map.put(primaryKey, status);
            }
            return map;
        }
        HashSet<Serializable> uncachedPrimaryKeys = null;
        for (Serializable serializable : primaryKeys) {
            Serializable serializable2 = this.entityCache.getResult(StatusModelImpl.ENTITY_CACHE_ENABLED, StatusImpl.class, serializable);
            if (serializable2 == nullModel) continue;
            if (serializable2 == null) {
                if (uncachedPrimaryKeys == null) {
                    uncachedPrimaryKeys = new HashSet<Serializable>();
                }
                uncachedPrimaryKeys.add(serializable);
                continue;
            }
            map.put(serializable, (Status)serializable2);
        }
        if (uncachedPrimaryKeys == null) {
            return map;
        }
        StringBundler query = new StringBundler(uncachedPrimaryKeys.size() * 2 + 1);
        query.append(_SQL_SELECT_STATUS_WHERE_PKS_IN);
        for (Serializable serializable : uncachedPrimaryKeys) {
            query.append(((Long)serializable).longValue());
            query.append(",");
        }
        query.setIndex(query.index() - 1);
        query.append(")");
        String string = query.toString();
        Session session2 = null;
        try {
            session = this.openSession();
            Query q = session.createQuery(string);
            for (Status status : q.list()) {
                map.put(status.getPrimaryKeyObj(), status);
                this.cacheResult(status);
                uncachedPrimaryKeys.remove(status.getPrimaryKeyObj());
            }
            for (Serializable serializable : uncachedPrimaryKeys) {
                this.entityCache.putResult(StatusModelImpl.ENTITY_CACHE_ENABLED, StatusImpl.class, serializable, (Serializable)nullModel);
            }
        }
        catch (Exception e) {
            try {
                throw this.processException(e);
            }
            catch (Throwable throwable) {
                this.closeSession(session2);
                throw throwable;
            }
        }
        this.closeSession(session);
        return map;
    }

    public List<Status> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<Status> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<Status> findAll(int start, int end, OrderByComparator<Status> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<Status> findAll(int start, int end, OrderByComparator<Status> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL;
            finderArgs = FINDER_ARGS_EMPTY;
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_ALL;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (retrieveFromCache) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        }
        if (list == null) {
            StringBundler query = null;
            String sql = null;
            if (orderByComparator != null) {
                query = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                query.append(_SQL_SELECT_STATUS);
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = query.toString();
            } else {
                sql = _SQL_SELECT_STATUS;
                if (pagination) {
                    sql = sql.concat(" ORDER BY status.statusId ASC");
                }
            }
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                if (!pagination) {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                this.cacheResult(list);
                this.finderCache.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (Status status : this.findAll()) {
            this.remove((BaseModel)status);
        }
    }

    public int countAll() {
        Long count = (Long)this.finderCache.getResult(FINDER_PATH_COUNT_ALL, FINDER_ARGS_EMPTY, (BasePersistenceImpl)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(_SQL_COUNT_STATUS);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(FINDER_PATH_COUNT_ALL, FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(FINDER_PATH_COUNT_ALL, FINDER_ARGS_EMPTY);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public Set<String> getBadColumnNames() {
        return _badColumnNames;
    }

    protected Map<String, Integer> getTableColumnsMap() {
        return StatusModelImpl.TABLE_COLUMNS_MAP;
    }

    public void afterPropertiesSet() {
    }

    public void destroy() {
        this.entityCache.removeCache(StatusImpl.class.getName());
        this.finderCache.removeCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }
}

