/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.chat.service.persistence.impl;

import com.liferay.chat.model.Entry;
import com.liferay.chat.model.impl.EntryImpl;
import com.liferay.chat.service.persistence.EntryFinder;
import com.liferay.chat.service.persistence.impl.EntryFinderBaseImpl;
import com.liferay.portal.dao.orm.custom.sql.CustomSQL;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.util.List;

public class EntryFinderImpl
extends EntryFinderBaseImpl
implements EntryFinder {
    public static final String FIND_BY_EMPTY_CONTENT = EntryFinder.class.getName() + ".findByEmptyContent";
    public static final String FIND_BY_NEW = EntryFinder.class.getName() + ".findByNew";
    public static final String FIND_BY_OLD = EntryFinder.class.getName() + ".findByOld";
    private static final String _CREATE_DATE_SQL = "(createDate > ?)";
    private static final String _FLAG_SQL = "(flag = ?)";
    @ServiceReference(type=CustomSQL.class)
    private CustomSQL _customSQL;

    public List<Entry> findByEmptyContent(long fromUserId, long toUserId, int start, int end) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), FIND_BY_EMPTY_CONTENT);
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addEntity("Chat_Entry", EntryImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(fromUserId);
            qPos.add(toUserId);
            List list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Entry> findByNew(long userId, long createDate, int start, int end) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), FIND_BY_NEW);
            if (createDate > 0L) {
                sql = StringUtil.replace((String)sql, (String)_FLAG_SQL, (String)_CREATE_DATE_SQL);
            }
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addEntity("Chat_Entry", EntryImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(userId);
            qPos.add(userId);
            if (createDate > 0L) {
                qPos.add(createDate);
            } else {
                qPos.add(0);
            }
            List list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Entry> findByOld(long createDate, int start, int end) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), FIND_BY_OLD);
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addEntity("Chat_Entry", EntryImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(createDate);
            List list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }
}

