/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.chat.internal.jabber;

import com.liferay.chat.internal.configuration.ChatGroupServiceConfiguration;
import com.liferay.chat.internal.jabber.JabberChatManagerListener;
import com.liferay.chat.internal.jabber.JabberMessageListener;
import com.liferay.chat.jabber.Jabber;
import com.liferay.chat.model.Status;
import com.liferay.chat.service.StatusLocalServiceUtil;
import com.liferay.chat.util.comparator.BuddyComparator;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ContactConstants;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jivesoftware.smack.AccountManager;
import org.jivesoftware.smack.Chat;
import org.jivesoftware.smack.ChatManager;
import org.jivesoftware.smack.ChatManagerListener;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.MessageListener;
import org.jivesoftware.smack.Roster;
import org.jivesoftware.smack.RosterEntry;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Presence;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.chat.configuration.ChatConfiguration"}, configurationPolicy=ConfigurationPolicy.OPTIONAL, enabled=false, immediate=true, service={Jabber.class})
public class JabberImpl
implements Jabber {
    private static final Log _log = LogFactoryUtil.getLog(JabberImpl.class);
    private ChatGroupServiceConfiguration _chatGroupServiceConfiguration;
    private ConnectionConfiguration _connectionConfiguration;
    private final Map<Long, Connection> _connections = new HashMap<Long, Connection>();
    private final Set<Long> _onlineUserIds = new HashSet<Long>();
    private UserLocalService _userLocalService;

    public void disconnect(long userId) {
        Connection connection = this.getConnection(userId);
        if (connection == null) {
            return;
        }
        connection.disconnect();
        this._connections.remove(userId);
        this._onlineUserIds.remove(userId);
    }

    public String getResource(String jabberId) {
        String resource = StringUtil.extractLast((String)jabberId, (String)"@");
        if ((resource = StringUtil.extractLast((String)resource, (String)"/")) == null) {
            return "";
        }
        return resource;
    }

    public String getScreenName(String jabberId) {
        return StringUtil.extractFirst((String)jabberId, (String)"@");
    }

    public List<Object[]> getStatuses(long companyId, long userId, List<Object[]> buddies) {
        try {
            Connection connection = this.getConnection(userId);
            if (connection == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("User " + userId + " is not connected to Jabber"));
                }
                return buddies;
            }
            ArrayList<Object[]> jabberBuddies = new ArrayList<Object[]>();
            jabberBuddies.addAll(buddies);
            Roster roster = connection.getRoster();
            Collection rosterEntries = roster.getEntries();
            if (this._chatGroupServiceConfiguration.jabberImportUserEnabled()) {
                for (Object[] buddy : buddies) {
                    String firstName = (String)buddy[1];
                    String lastName = (String)buddy[3];
                    String middleName = (String)buddy[5];
                    String screenName = (String)buddy[7];
                    String fullName = ContactConstants.getFullName((String)firstName, (String)middleName, (String)lastName);
                    String jabberId = this.getFullJabberId(screenName);
                    if (roster.contains(jabberId)) continue;
                    roster.createEntry(jabberId, fullName, null);
                }
            }
            BuddyComparator buddyComparator = new BuddyComparator(true);
            for (RosterEntry rosterEntry : rosterEntries) {
                Presence presence = roster.getPresence(rosterEntry.getUser());
                if (!presence.isAvailable()) continue;
                User user = this._userLocalService.getUserByScreenName(companyId, this.getScreenName(rosterEntry.getUser()));
                Object[] jabberBuddy = new Object[]{true, user.getFirstName(), user.getGroupId(), user.getLastName(), user.isMale(), user.getMiddleName(), user.getPortraitId(), user.getScreenName(), user.getUserId(), user.getUserUuid()};
                if (Collections.binarySearch(jabberBuddies, jabberBuddy, buddyComparator) >= 0) continue;
                jabberBuddies.add(jabberBuddy);
            }
            Collections.sort(jabberBuddies, buddyComparator);
            return jabberBuddies;
        }
        catch (Exception e) {
            _log.error((Object)"Unable to get Jabber buddies", (Throwable)e);
            return buddies;
        }
    }

    public void login(long userId, String password) {
        block10: {
            try {
                this.connect(userId, password);
            }
            catch (XMPPException xmppe1) {
                String message1 = xmppe1.getMessage();
                if (!Validator.isNotNull((String)message1) || !message1.contains("not-authorized")) break block10;
                if (!this._chatGroupServiceConfiguration.jabberImportUserEnabled()) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)("User " + userId + " cannot connect to Jabber"));
                    }
                    return;
                }
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Importing user " + userId + " because he cannot connect to Jabber"));
                }
                try {
                    this.importUser(userId, password);
                    this.connect(userId, password);
                }
                catch (XMPPException xmppe2) {
                    String message2 = xmppe2.getMessage();
                    if (message2.contains("conflict(409)")) {
                        _log.error((Object)StringBundler.concat((Object[])new Object[]{"User ", userId, " already exists but password is not ", "synchronized with Jabber"}));
                    }
                }
                catch (Exception e) {
                    _log.error((Object)e, (Throwable)e);
                }
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
        }
    }

    public void sendMessage(long fromUserId, long toUserId, String content) {
        try {
            String jabberId;
            if (Validator.isNull((String)content)) {
                return;
            }
            Connection connection = this.getConnection(fromUserId);
            if (connection == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)StringBundler.concat((Object[])new Object[]{"User ", fromUserId, " is not connected to Jabber and cannot send ", "messages"}));
                }
                return;
            }
            User toUser = this._userLocalService.getUser(toUserId);
            Roster roster = connection.getRoster();
            if (!roster.contains(jabberId = this.getJabberId(toUser.getScreenName()))) {
                return;
            }
            Iterator presences = roster.getPresences(jabberId);
            while (presences.hasNext()) {
                Presence presence = (Presence)presences.next();
                String from = presence.getFrom();
                String resource = this.getResource(from);
                if (StringUtil.equalsIgnoreCase((String)resource, (String)this._chatGroupServiceConfiguration.jabberResource())) continue;
                ChatManager chatManager = connection.getChatManager();
                JabberMessageListener messageListener = new JabberMessageListener(toUser.getCompanyId(), fromUserId);
                Chat chat = chatManager.createChat(from, (MessageListener)messageListener);
                try {
                    chat.sendMessage(content);
                }
                catch (XMPPException xmppe) {
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Object)("User " + fromUserId + " could not send message"), (Throwable)xmppe);
                }
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    public void updatePassword(long userId, String password) {
        if (!this._chatGroupServiceConfiguration.jabberImportUserEnabled() || password == null) {
            return;
        }
        Connection connection = this.getConnection(userId);
        if (connection == null) {
            return;
        }
        try {
            AccountManager accountManager = connection.getAccountManager();
            accountManager.changePassword(password);
        }
        catch (XMPPException xmppe) {
            _log.error((Object)("Unable to update user " + userId + " password"), (Throwable)xmppe);
        }
    }

    public void updateStatus(long userId, int online) {
        this.updateStatus(userId, online, null);
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._chatGroupServiceConfiguration = (ChatGroupServiceConfiguration)ConfigurableUtil.createConfigurable(ChatGroupServiceConfiguration.class, properties);
    }

    protected Connection connect() throws Exception {
        long userId = -1L;
        String password = null;
        return this.connect(userId, password);
    }

    protected Connection connect(long userId, String password) throws Exception {
        Connection connection = this.getConnection(userId);
        if (connection != null) {
            return connection;
        }
        connection = new XMPPConnection(this.getConnectionConfiguration());
        connection.connect();
        if (userId < 0L) {
            return connection;
        }
        User user = this._userLocalService.getUserById(userId);
        connection.login(user.getScreenName(), password, this._chatGroupServiceConfiguration.jabberResource());
        Status status = StatusLocalServiceUtil.getUserStatus((long)userId);
        if (status.isOnline()) {
            this.updateStatus(userId, 1, connection);
        }
        ChatManager chatManager = connection.getChatManager();
        JabberChatManagerListener chatMessageListener = new JabberChatManagerListener(user.getCompanyId(), userId);
        chatManager.addChatListener((ChatManagerListener)chatMessageListener);
        this._connections.put(userId, connection);
        return connection;
    }

    protected Connection getConnection(long userId) {
        return this._connections.get(userId);
    }

    protected ConnectionConfiguration getConnectionConfiguration() throws UnknownHostException {
        if (this._connectionConfiguration != null) {
            return this._connectionConfiguration;
        }
        String jabberHost = this._chatGroupServiceConfiguration.jabberHost();
        if (!Validator.isIPAddress((String)jabberHost)) {
            InetAddress inetAddress = InetAddress.getByName(jabberHost);
            jabberHost = inetAddress.getHostAddress();
        }
        this._connectionConfiguration = new ConnectionConfiguration(jabberHost, this._chatGroupServiceConfiguration.jabberPort(), this._chatGroupServiceConfiguration.jabberServiceName());
        this._connectionConfiguration.setSendPresence(false);
        SmackConfiguration.setLocalSocks5ProxyEnabled((boolean)this._chatGroupServiceConfiguration.jabberSock5ProxyEnabled());
        SmackConfiguration.setLocalSocks5ProxyPort((int)this._chatGroupServiceConfiguration.jabberSock5ProxyPort());
        return this._connectionConfiguration;
    }

    protected String getFullJabberId(String screenName) {
        String jabberId = this.getJabberId(screenName);
        return jabberId.concat("/").concat(this._chatGroupServiceConfiguration.jabberResource());
    }

    protected String getJabberId(String screenName) {
        return screenName.concat("@").concat(this._chatGroupServiceConfiguration.jabberResource());
    }

    protected void importUser(long userId, String password) throws Exception {
        Connection connection = this.connect();
        AccountManager accountManager = connection.getAccountManager();
        if (!accountManager.supportsAccountCreation()) {
            _log.error((Object)"Jabber server does not support account creation");
            return;
        }
        User user = this._userLocalService.getUserById(userId);
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("email", user.getEmailAddress());
        attributes.put("first", user.getFirstName());
        attributes.put("last", user.getLastName());
        attributes.put("name", user.getFullName());
        accountManager.createAccount(user.getScreenName(), password, attributes);
    }

    @Reference(unbind="-")
    protected void setUserLocalService(UserLocalService userLocalService) {
        this._userLocalService = userLocalService;
    }

    protected void updateStatus(long userId, int online, Connection connection) {
        try {
            if (connection == null && (connection = this.getConnection(userId)) == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("User " + userId + " is not connected to Jabber"));
                }
                return;
            }
            if (online == 1 && !this._onlineUserIds.contains(userId)) {
                Presence presence = new Presence(Presence.Type.available);
                connection.sendPacket((Packet)presence);
                this._onlineUserIds.add(userId);
            } else if (online == 0 && this._onlineUserIds.contains(userId)) {
                Presence presence = new Presence(Presence.Type.unavailable);
                connection.sendPacket((Packet)presence);
                this._onlineUserIds.remove(userId);
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }
}

