/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.chat.service.persistence.impl;

import com.liferay.chat.model.Status;
import com.liferay.chat.service.persistence.StatusPersistence;

import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;

import java.lang.reflect.Field;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/**
 * @author Brian Wing Shun Chan
 * @generated
 */
public class StatusFinderBaseImpl extends BasePersistenceImpl<Status> {
	public StatusFinderBaseImpl() {
		setModelClass(Status.class);

		try {
			Field field = BasePersistenceImpl.class.getDeclaredField(
					"_dbColumnNames");

			field.setAccessible(true);

			Map<String, String> dbColumnNames = new HashMap<String, String>();

			dbColumnNames.put("online", "online_");

			field.set(this, dbColumnNames);
		}
		catch (Exception e) {
			if (_log.isDebugEnabled()) {
				_log.debug(e, e);
			}
		}
	}

	@Override
	public Set<String> getBadColumnNames() {
		return getStatusPersistence().getBadColumnNames();
	}

	/**
	 * Returns the status persistence.
	 *
	 * @return the status persistence
	 */
	public StatusPersistence getStatusPersistence() {
		return statusPersistence;
	}

	/**
	 * Sets the status persistence.
	 *
	 * @param statusPersistence the status persistence
	 */
	public void setStatusPersistence(StatusPersistence statusPersistence) {
		this.statusPersistence = statusPersistence;
	}

	@BeanReference(type = StatusPersistence.class)
	protected StatusPersistence statusPersistence;
	private static final Log _log = LogFactoryUtil.getLog(StatusFinderBaseImpl.class);
}