/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.chat.internal.util;

import com.liferay.chat.internal.configuration.ChatGroupServiceConfiguration;
import com.liferay.chat.internal.jabber.JabberUtil;
import com.liferay.chat.service.StatusLocalServiceUtil;
import com.liferay.chat.util.BuddyFinder;
import com.liferay.chat.util.comparator.BuddyComparator;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Modified;

@Component(configurationPid={"com.liferay.chat.configuration.ChatConfiguration"}, configurationPolicy=ConfigurationPolicy.OPTIONAL, enabled=false, immediate=true, service={BuddyFinder.class})
public class DefaultBuddyFinderImpl
implements BuddyFinder {
    private ChatGroupServiceConfiguration _chatGroupServiceConfiguration;

    public List<Object[]> getBuddies(long companyId, long userId) {
        long modifiedDate = System.currentTimeMillis() - 60000L;
        ArrayList<Object[]> buddies = null;
        String buddyListStrategy = this._chatGroupServiceConfiguration.buddyListStrategy();
        if (buddyListStrategy.equals("all")) {
            buddies = StatusLocalServiceUtil.getAllStatuses((long)companyId, (long)userId, (long)modifiedDate, (int)0, (int)this._chatGroupServiceConfiguration.buddyListMaxBuddies());
        } else if (buddyListStrategy.equals("communities") || buddyListStrategy.equals("sites")) {
            buddies = StatusLocalServiceUtil.getGroupStatuses((long)userId, (long)modifiedDate, (String[])this._chatGroupServiceConfiguration.buddyListSiteExcludes(), (int)0, (int)this._chatGroupServiceConfiguration.buddyListMaxBuddies());
        } else if (buddyListStrategy.equals("friends") || buddyListStrategy.equals("social")) {
            buddies = StatusLocalServiceUtil.getSocialStatuses((long)userId, (int[])this._chatGroupServiceConfiguration.buddyListAllowedSocialRelationTypes(), (long)modifiedDate, (int)0, (int)this._chatGroupServiceConfiguration.buddyListMaxBuddies());
        } else if (buddyListStrategy.equals("communities,friends") || buddyListStrategy.equals("sites,social") || buddyListStrategy.equals("friends,sites")) {
            List groupBuddies = StatusLocalServiceUtil.getGroupStatuses((long)userId, (long)modifiedDate, (String[])this._chatGroupServiceConfiguration.buddyListSiteExcludes(), (int)0, (int)this._chatGroupServiceConfiguration.buddyListMaxBuddies());
            List socialBuddies = StatusLocalServiceUtil.getSocialStatuses((long)userId, (int[])this._chatGroupServiceConfiguration.buddyListAllowedSocialRelationTypes(), (long)modifiedDate, (int)0, (int)this._chatGroupServiceConfiguration.buddyListMaxBuddies());
            buddies = new ArrayList(groupBuddies.size() + socialBuddies.size());
            buddies.addAll(groupBuddies);
            BuddyComparator buddyComparator = new BuddyComparator(true);
            for (Object[] socialBuddy : socialBuddies) {
                if (Collections.binarySearch(groupBuddies, socialBuddy, buddyComparator) >= 0) continue;
                buddies.add(socialBuddy);
            }
            Collections.sort(buddies, buddyComparator);
        } else {
            buddies = new ArrayList<Object[]>();
        }
        return JabberUtil.getStatuses(companyId, userId, (List<Object[]>)buddies);
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._chatGroupServiceConfiguration = (ChatGroupServiceConfiguration)ConfigurableUtil.createConfigurable(ChatGroupServiceConfiguration.class, properties);
    }
}

