/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.changeset.model.impl;

import com.liferay.changeset.model.ChangesetEntry;
import com.liferay.changeset.service.ChangesetEntryLocalServiceUtil;

/**
 * The extended model base implementation for the ChangesetEntry service. Represents a row in the &quot;ChangesetEntry&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link ChangesetEntryImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see ChangesetEntryImpl
 * @see ChangesetEntry
 * @generated
 */
public abstract class ChangesetEntryBaseImpl
	extends ChangesetEntryModelImpl implements ChangesetEntry {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a changeset entry model instance should use the <code>ChangesetEntry</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			ChangesetEntryLocalServiceUtil.addChangesetEntry(this);
		}
		else {
			ChangesetEntryLocalServiceUtil.updateChangesetEntry(this);
		}
	}

}