/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.changeset.model.impl;

import com.liferay.changeset.model.ChangesetCollection;
import com.liferay.changeset.service.ChangesetCollectionLocalServiceUtil;

/**
 * The extended model base implementation for the ChangesetCollection service. Represents a row in the &quot;ChangesetCollection&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link ChangesetCollectionImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see ChangesetCollectionImpl
 * @see ChangesetCollection
 * @generated
 */
public abstract class ChangesetCollectionBaseImpl
	extends ChangesetCollectionModelImpl implements ChangesetCollection {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a changeset collection model instance should use the <code>ChangesetCollection</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			ChangesetCollectionLocalServiceUtil.addChangesetCollection(this);
		}
		else {
			ChangesetCollectionLocalServiceUtil.updateChangesetCollection(this);
		}
	}

}