/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.store.service.base;

import com.liferay.change.tracking.store.model.CTSContent;
import com.liferay.change.tracking.store.model.CTSContentDataBlobModel;
import com.liferay.change.tracking.store.service.CTSContentLocalService;
import com.liferay.change.tracking.store.service.persistence.CTSContentPersistence;
import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.petra.io.AutoDeleteFileInputStream;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.db.DBType;
import com.liferay.portal.kernel.dao.jdbc.CurrentConnectionUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DefaultActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.PersistedModel;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.BaseLocalService;
import com.liferay.portal.kernel.service.BaseLocalServiceImpl;
import com.liferay.portal.kernel.service.PersistedModelLocalService;
import com.liferay.portal.kernel.service.change.tracking.CTService;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.service.persistence.change.tracking.CTPersistence;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.File;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.io.InputStream;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.Connection;
import java.util.List;
import javax.sql.DataSource;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

public abstract class CTSContentLocalServiceBaseImpl
extends BaseLocalServiceImpl
implements AopService,
CTSContentLocalService,
IdentifiableOSGiService {
    protected CTSContentLocalService ctsContentLocalService;
    @Reference
    protected CTSContentPersistence ctsContentPersistence;
    @Reference
    protected CounterLocalService counterLocalService;
    private static final Log _log = LogFactoryUtil.getLog(CTSContentLocalServiceBaseImpl.class);
    @Reference
    protected File _file;
    private static final InputStream _EMPTY_INPUT_STREAM = new UnsyncByteArrayInputStream(new byte[0]);
    private boolean _useTempFile;

    @Indexable(type=IndexableType.REINDEX)
    public CTSContent addCTSContent(CTSContent ctsContent) {
        ctsContent.setNew(true);
        return (CTSContent)this.ctsContentPersistence.update((BaseModel)ctsContent);
    }

    @Transactional(enabled=false)
    public CTSContent createCTSContent(long ctsContentId) {
        return this.ctsContentPersistence.create(ctsContentId);
    }

    @Indexable(type=IndexableType.DELETE)
    public CTSContent deleteCTSContent(long ctsContentId) throws PortalException {
        return this.ctsContentPersistence.remove(ctsContentId);
    }

    @Indexable(type=IndexableType.DELETE)
    public CTSContent deleteCTSContent(CTSContent ctsContent) {
        return (CTSContent)this.ctsContentPersistence.remove((BaseModel)ctsContent);
    }

    public <T> T dslQuery(DSLQuery dslQuery) {
        return (T)this.ctsContentPersistence.dslQuery(dslQuery);
    }

    public int dslQueryCount(DSLQuery dslQuery) {
        Long count = (Long)this.dslQuery(dslQuery);
        return count.intValue();
    }

    public DynamicQuery dynamicQuery() {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        return DynamicQueryFactoryUtil.forClass(CTSContent.class, (ClassLoader)clazz.getClassLoader());
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery) {
        return this.ctsContentPersistence.findWithDynamicQuery(dynamicQuery);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end) {
        return this.ctsContentPersistence.findWithDynamicQuery(dynamicQuery, start, end);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end, OrderByComparator<T> orderByComparator) {
        return this.ctsContentPersistence.findWithDynamicQuery(dynamicQuery, start, end, orderByComparator);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery) {
        return this.ctsContentPersistence.countWithDynamicQuery(dynamicQuery);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery, Projection projection) {
        return this.ctsContentPersistence.countWithDynamicQuery(dynamicQuery, projection);
    }

    public CTSContent fetchCTSContent(long ctsContentId) {
        return this.ctsContentPersistence.fetchByPrimaryKey(ctsContentId);
    }

    public CTSContent getCTSContent(long ctsContentId) throws PortalException {
        return this.ctsContentPersistence.findByPrimaryKey(ctsContentId);
    }

    public ActionableDynamicQuery getActionableDynamicQuery() {
        DefaultActionableDynamicQuery actionableDynamicQuery = new DefaultActionableDynamicQuery();
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.ctsContentLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(CTSContent.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("ctsContentId");
        return actionableDynamicQuery;
    }

    public IndexableActionableDynamicQuery getIndexableActionableDynamicQuery() {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = new IndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setBaseLocalService((BaseLocalService)this.ctsContentLocalService);
        indexableActionableDynamicQuery.setClassLoader(this.getClassLoader());
        indexableActionableDynamicQuery.setModelClass(CTSContent.class);
        indexableActionableDynamicQuery.setPrimaryKeyPropertyName("ctsContentId");
        return indexableActionableDynamicQuery;
    }

    protected void initActionableDynamicQuery(ActionableDynamicQuery actionableDynamicQuery) {
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.ctsContentLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(CTSContent.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("ctsContentId");
    }

    public PersistedModel createPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return this.ctsContentPersistence.create(((Long)primaryKeyObj).longValue());
    }

    public PersistedModel deletePersistedModel(PersistedModel persistedModel) throws PortalException {
        if (_log.isWarnEnabled()) {
            _log.warn((Object)"Implement CTSContentLocalServiceImpl#deleteCTSContent(CTSContent) to avoid orphaned data");
        }
        return this.ctsContentLocalService.deleteCTSContent((CTSContent)persistedModel);
    }

    public BasePersistence<CTSContent> getBasePersistence() {
        return this.ctsContentPersistence;
    }

    public PersistedModel getPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return (PersistedModel)this.ctsContentPersistence.findByPrimaryKey(primaryKeyObj);
    }

    public List<CTSContent> getCTSContents(int start, int end) {
        return this.ctsContentPersistence.findAll(start, end);
    }

    public int getCTSContentsCount() {
        return this.ctsContentPersistence.countAll();
    }

    @Indexable(type=IndexableType.REINDEX)
    public CTSContent updateCTSContent(CTSContent ctsContent) {
        return (CTSContent)this.ctsContentPersistence.update((BaseModel)ctsContent);
    }

    public CTSContentDataBlobModel getDataBlobModel(Serializable primaryKey) {
        Session session = null;
        try {
            session = this.ctsContentPersistence.openSession();
            CTSContentDataBlobModel cTSContentDataBlobModel = (CTSContentDataBlobModel)session.get(CTSContentDataBlobModel.class, primaryKey);
            return cTSContentDataBlobModel;
        }
        catch (Exception exception) {
            throw this.ctsContentPersistence.processException(exception);
        }
        finally {
            this.ctsContentPersistence.closeSession(session);
        }
    }

    @Transactional(readOnly=true)
    public InputStream openDataInputStream(long ctsContentId) {
        try {
            CTSContentDataBlobModel CTSContentDataBlobModel2 = this.getDataBlobModel(Long.valueOf(ctsContentId));
            Blob blob = CTSContentDataBlobModel2.getDataBlob();
            if (blob == null) {
                return _EMPTY_INPUT_STREAM;
            }
            InputStream inputStream = blob.getBinaryStream();
            if (this._useTempFile) {
                inputStream = new AutoDeleteFileInputStream(this._file.createTempFile(inputStream));
            }
            return inputStream;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }

    @Activate
    protected void activate() {
        DB db = DBManagerUtil.getDB();
        if (db.getDBType() != DBType.DB2 && db.getDBType() != DBType.MYSQL && db.getDBType() != DBType.MARIADB) {
            this._useTempFile = true;
        }
    }

    @Deactivate
    protected void deactivate() {
    }

    public Class<?>[] getAopInterfaces() {
        return new Class[]{CTSContentLocalService.class, IdentifiableOSGiService.class, CTService.class, PersistedModelLocalService.class};
    }

    public void setAopProxy(Object aopProxy) {
        this.ctsContentLocalService = (CTSContentLocalService)aopProxy;
    }

    public String getOSGiServiceIdentifier() {
        return CTSContentLocalService.class.getName();
    }

    public CTPersistence<CTSContent> getCTPersistence() {
        return this.ctsContentPersistence;
    }

    public Class<CTSContent> getModelClass() {
        return CTSContent.class;
    }

    public <R, E extends Throwable> R updateWithUnsafeFunction(UnsafeFunction<CTPersistence<CTSContent>, R, E> updateUnsafeFunction) throws E {
        return (R)updateUnsafeFunction.apply((Object)this.ctsContentPersistence);
    }

    protected String getModelClassName() {
        return CTSContent.class.getName();
    }

    protected void runSQL(String sql) {
        DataSource dataSource = this.ctsContentPersistence.getDataSource();
        DB db = DBManagerUtil.getDB();
        Connection currentConnection = CurrentConnectionUtil.getConnection((DataSource)dataSource);
        try {
            if (currentConnection != null) {
                db.runSQL(currentConnection, new String[]{sql});
                return;
            }
            try (Connection connection = dataSource.getConnection();){
                db.runSQL(connection, new String[]{sql});
            }
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }
}

