/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.store.internal;

import com.liferay.document.library.kernel.store.Store;
import com.liferay.portal.change.tracking.store.CTStoreFactory;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapDictionaryBuilder;
import com.liferay.portal.kernel.util.PropsValues;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portlet.documentlibrary.store.DLStoreImpl;
import java.util.Dictionary;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(service={})
public class CTStoreRegistrator {
    @Reference
    private CTStoreFactory _ctStoreFactory;
    private ServiceTracker<Store, ServiceRegistration<?>> _serviceTracker;

    @Activate
    protected void activate(final BundleContext bundleContext) {
        this._serviceTracker = new ServiceTracker(bundleContext, Store.class, new ServiceTrackerCustomizer<Store, ServiceRegistration<?>>(){

            public ServiceRegistration<?> addingService(ServiceReference<Store> serviceReference) {
                if (GetterUtil.getBoolean((Object)serviceReference.getProperty("republished"))) {
                    return null;
                }
                String storeType = String.valueOf(serviceReference.getProperty("store.type"));
                if (GetterUtil.getBoolean((Object)serviceReference.getProperty("ct.aware"))) {
                    if (!StringUtil.equals((String)storeType, (String)PropsValues.DL_STORE_IMPL)) {
                        return null;
                    }
                    Store ctStore = (Store)bundleContext.getService(serviceReference);
                    DLStoreImpl.setStore((Store)ctStore);
                    return bundleContext.registerService(Store.class, (Object)ctStore, (Dictionary)HashMapDictionaryBuilder.put((Object)"default", (Object)true).put((Object)"republished", (Object)true).build());
                }
                Store ctStore = CTStoreRegistrator.this._ctStoreFactory.createCTStore((Store)bundleContext.getService(serviceReference), storeType);
                if (StringUtil.equals((String)storeType, (String)PropsValues.DL_STORE_IMPL)) {
                    DLStoreImpl.setStore((Store)ctStore);
                }
                return bundleContext.registerService(Store.class, (Object)ctStore, (Dictionary)HashMapDictionaryBuilder.put((Object)"ct.aware", (Object)true).put((Object)"default", () -> {
                    if (StringUtil.equals((String)storeType, (String)PropsValues.DL_STORE_IMPL)) {
                        return true;
                    }
                    return null;
                }).put((Object)"republished", (Object)true).put((Object)"store.type", (Object)storeType).build());
            }

            public void modifiedService(ServiceReference<Store> serviceReference, ServiceRegistration<?> serviceRegistration) {
            }

            public void removedService(ServiceReference<Store> serviceReference, ServiceRegistration<?> serviceRegistration) {
                serviceRegistration.unregister();
                bundleContext.ungetService(serviceReference);
            }
        });
        this._serviceTracker.open();
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTracker.close();
    }
}

