/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.store.internal;

import com.liferay.change.tracking.model.CTEntry;
import com.liferay.change.tracking.service.CTEntryLocalService;
import com.liferay.change.tracking.spi.exception.CTEventException;
import com.liferay.change.tracking.spi.listener.CTEventListener;
import com.liferay.change.tracking.store.model.CTSContent;
import com.liferay.change.tracking.store.service.CTSContentLocalService;
import com.liferay.document.library.kernel.store.Store;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.petra.lang.SafeCloseable;
import com.liferay.portal.kernel.change.tracking.CTCollectionThreadLocal;
import com.liferay.portal.kernel.change.tracking.sql.CTSQLModeThreadLocal;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Portal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={CTEventListener.class})
public class CTStoreCTEventListener
implements CTEventListener {
    private static final Log _log = LogFactoryUtil.getLog(CTStoreCTEventListener.class);
    @Reference
    private CTEntryLocalService _ctEntryLocalService;
    @Reference
    private CTSContentLocalService _ctsContentLocalService;
    @Reference
    private Portal _portal;
    private ServiceTrackerMap<String, Store> _serviceTrackerMap;

    public void onAfterPublish(long ctCollectionId) throws CTEventException {
        List ctEntries = this._ctEntryLocalService.getCTEntries(ctCollectionId, this._portal.getClassNameId(CTSContent.class.getName()));
        if (ctEntries.isEmpty()) {
            return;
        }
        ArrayList<CTEntry> deletedCTEnties = new ArrayList<CTEntry>();
        ArrayList<CTEntry> addOrModifiedCTEntries = new ArrayList<CTEntry>();
        for (CTEntry ctEntry : ctEntries) {
            if (ctEntry.getChangeType() == 1) {
                deletedCTEnties.add(ctEntry);
                continue;
            }
            addOrModifiedCTEntries.add(ctEntry);
        }
        if (!deletedCTEnties.isEmpty()) {
            try (SafeCloseable safeCloseable1 = CTSQLModeThreadLocal.setCTSQLModeWithSafeCloseable((CTSQLModeThreadLocal.CTSQLMode)CTSQLModeThreadLocal.CTSQLMode.CT_ONLY);
                 SafeCloseable safeCloseable2 = CTCollectionThreadLocal.setCTCollectionIdWithSafeCloseable((long)ctCollectionId);){
                for (CTEntry ctEntry : deletedCTEnties) {
                    CTSContent ctsContent = this._ctsContentLocalService.fetchCTSContent(ctEntry.getModelClassPK());
                    if (ctsContent != null) {
                        Store store = (Store)this._serviceTrackerMap.getService((Object)ctsContent.getStoreType());
                        store.deleteFile(ctsContent.getCompanyId(), ctsContent.getRepositoryId(), ctsContent.getPath(), ctsContent.getVersion());
                        continue;
                    }
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Object)("No change tracking store content found for model class PK " + ctEntry.getModelClassPK()));
                }
            }
        }
        if (!addOrModifiedCTEntries.isEmpty()) {
            try (SafeCloseable safeCloseable = CTCollectionThreadLocal.setProductionModeWithSafeCloseable();){
                for (CTEntry ctEntry : addOrModifiedCTEntries) {
                    CTSContent ctsContent = this._ctsContentLocalService.getCTSContent(ctEntry.getModelClassPK());
                    Store store = (Store)this._serviceTrackerMap.getService((Object)ctsContent.getStoreType());
                    store.addFile(ctsContent.getCompanyId(), ctsContent.getRepositoryId(), ctsContent.getPath(), ctsContent.getVersion(), this._ctsContentLocalService.openDataInputStream(ctsContent.getCtsContentId()));
                }
            }
            catch (PortalException portalException) {
                throw new CTEventException((Throwable)portalException);
            }
        }
    }

    public void onBeforeRemove(long ctCollectionId) throws CTEventException {
        List ctsContentIds = this._ctEntryLocalService.getExclusiveModelClassPKs(ctCollectionId, this._portal.getClassNameId(CTSContent.class.getName()));
        if (ctsContentIds.isEmpty()) {
            return;
        }
        try (SafeCloseable safeCloseable = CTCollectionThreadLocal.setProductionModeWithSafeCloseable();){
            Iterator iterator = ctsContentIds.iterator();
            while (iterator.hasNext()) {
                long ctsContentId = (Long)iterator.next();
                CTSContent ctsContent = this._ctsContentLocalService.fetchCTSContent(ctsContentId);
                if (ctsContent == null) continue;
                this._ctsContentLocalService.deleteCTSContent(ctsContent);
            }
        }
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, Store.class, (String)"store.type");
    }
}

