/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.change.tracking.store.model.impl;

import com.liferay.change.tracking.store.model.CTSContent;
import com.liferay.change.tracking.store.service.CTSContentLocalServiceUtil;

/**
 * The extended model base implementation for the CTSContent service. Represents a row in the &quot;CTSContent&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link CTSContentImpl}.
 * </p>
 *
 * @author Shuyang Zhou
 * @see CTSContentImpl
 * @see CTSContent
 * @generated
 */
public abstract class CTSContentBaseImpl
	extends CTSContentModelImpl implements CTSContent {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a cts content model instance should use the <code>CTSContent</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			CTSContentLocalServiceUtil.addCTSContent(this);
		}
		else {
			CTSContentLocalServiceUtil.updateCTSContent(this);
		}
	}

}