/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.store.service.impl;

import com.liferay.change.tracking.store.exception.NoSuchContentException;
import com.liferay.change.tracking.store.model.CTSContent;
import com.liferay.change.tracking.store.service.base.CTSContentLocalServiceBaseImpl;
import com.liferay.petra.io.StreamUtil;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.dao.jdbc.OutputBlob;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import java.sql.Blob;
import java.util.List;
import org.osgi.service.component.annotations.Component;

@Component(property={"model.class.name=com.liferay.change.tracking.store.model.CTSContent"}, service={AopService.class})
public class CTSContentLocalServiceImpl
extends CTSContentLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(CTSContentLocalServiceImpl.class);

    public CTSContent addCTSContent(long companyId, long repositoryId, String path, String version, String storeType, InputStream inputStream) {
        CTSContent ctsContent = this.ctsContentPersistence.fetchByC_R_P_V_S(companyId, repositoryId, path, version, storeType);
        if (ctsContent == null) {
            ctsContent = this.ctsContentPersistence.create(this.counterLocalService.increment());
            ctsContent.setCompanyId(companyId);
            ctsContent.setRepositoryId(repositoryId);
            ctsContent.setPath(path);
            ctsContent.setVersion(version);
            ctsContent.setStoreType(storeType);
        }
        OutputBlob outputBlob = this._toOutputBlob(inputStream);
        ctsContent.setData((Blob)outputBlob);
        ctsContent.setSize(outputBlob.length());
        return (CTSContent)this.ctsContentPersistence.update((BaseModel)ctsContent);
    }

    public void deleteCTSContent(long companyId, long repositoryId, String path, String version, String storeType) {
        CTSContent ctsContent = this.ctsContentPersistence.fetchByC_R_P_V_S(companyId, repositoryId, path, version, storeType);
        if (ctsContent != null) {
            this.ctsContentPersistence.remove((BaseModel)ctsContent);
        }
    }

    public void deleteCTSContentsByDirectory(long companyId, long repositoryId, String dirName, String storeType) {
        if (dirName.isEmpty()) {
            this.ctsContentPersistence.removeByC_R_S(companyId, repositoryId, storeType);
            return;
        }
        if (!dirName.endsWith("/")) {
            dirName = dirName.concat("/");
        }
        dirName = dirName.concat("%");
        this.ctsContentPersistence.removeByC_R_LikeP_S(companyId, repositoryId, dirName, storeType);
    }

    public CTSContent getCTSContent(long companyId, long repositoryId, String path, String version, String storeType) throws NoSuchContentException {
        if (version.isEmpty()) {
            List ctsContents = this.ctsContentPersistence.findByC_R_P_S(companyId, repositoryId, path, storeType, 0, 1, null);
            if (ctsContents == null || ctsContents.isEmpty()) {
                throw new NoSuchContentException(path);
            }
            return (CTSContent)ctsContents.get(0);
        }
        return this.ctsContentPersistence.findByC_R_P_V_S(companyId, repositoryId, path, version, storeType);
    }

    public List<CTSContent> getCTSContents(long companyId, long repositoryId, String path, String storeType) {
        return this.ctsContentPersistence.findByC_R_P_S(companyId, repositoryId, path, storeType);
    }

    public List<CTSContent> getCTSContentsByDirectory(long companyId, long repositoryId, String dirName, String storeType) {
        if (dirName.isEmpty()) {
            return this.ctsContentPersistence.findByC_R_S(companyId, repositoryId, storeType);
        }
        if (!dirName.endsWith("/")) {
            dirName = dirName.concat("/");
        }
        dirName = dirName.concat("%");
        return this.ctsContentPersistence.findByC_R_LikeP_S(companyId, repositoryId, dirName, storeType);
    }

    public boolean hasCTSContent(long companyId, long repositoryId, String path, String version, String storeType) {
        int count = 0;
        count = version.isEmpty() ? this.ctsContentPersistence.countByC_R_P_S(companyId, repositoryId, path, storeType) : this.ctsContentPersistence.countByC_R_P_V_S(companyId, repositoryId, path, version, storeType);
        return count > 0;
    }

    private OutputBlob _toOutputBlob(InputStream inputStream) {
        block8: {
            if (inputStream instanceof ByteArrayInputStream) {
                ByteArrayInputStream byteArrayInputStream = (ByteArrayInputStream)inputStream;
                return new OutputBlob(inputStream, (long)byteArrayInputStream.available());
            }
            if (inputStream instanceof com.liferay.petra.io.unsync.UnsyncByteArrayInputStream) {
                com.liferay.petra.io.unsync.UnsyncByteArrayInputStream unsyncByteArrayInputStream = (com.liferay.petra.io.unsync.UnsyncByteArrayInputStream)inputStream;
                return new OutputBlob((InputStream)unsyncByteArrayInputStream, (long)unsyncByteArrayInputStream.available());
            }
            if (inputStream instanceof UnsyncByteArrayInputStream) {
                UnsyncByteArrayInputStream unsyncByteArrayInputStream = (UnsyncByteArrayInputStream)inputStream;
                return new OutputBlob(inputStream, (long)unsyncByteArrayInputStream.available());
            }
            if (inputStream instanceof FileInputStream) {
                FileInputStream fileInputStream = (FileInputStream)inputStream;
                FileChannel fileChannel = fileInputStream.getChannel();
                try {
                    return new OutputBlob(inputStream, fileChannel.size());
                }
                catch (IOException ioException) {
                    if (!_log.isWarnEnabled()) break block8;
                    _log.warn((Object)"Unable to detect file size from file channel", (Throwable)ioException);
                }
            }
        }
        try {
            byte[] bytes = StreamUtil.toByteArray((InputStream)inputStream);
            com.liferay.petra.io.unsync.UnsyncByteArrayInputStream unsyncByteArrayInputStream = new com.liferay.petra.io.unsync.UnsyncByteArrayInputStream(bytes);
            return new OutputBlob((InputStream)unsyncByteArrayInputStream, (long)bytes.length);
        }
        catch (IOException ioException) {
            throw new SystemException((Throwable)ioException);
        }
    }
}

