/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.store.internal;

import com.liferay.change.tracking.exception.CTEventException;
import com.liferay.change.tracking.listener.CTEventListener;
import com.liferay.change.tracking.model.CTEntry;
import com.liferay.change.tracking.service.CTEntryLocalService;
import com.liferay.change.tracking.store.model.CTSContent;
import com.liferay.change.tracking.store.service.CTSContentLocalService;
import com.liferay.document.library.kernel.store.Store;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.petra.lang.SafeClosable;
import com.liferay.portal.change.tracking.sql.CTSQLModeThreadLocal;
import com.liferay.portal.kernel.change.tracking.CTCollectionThreadLocal;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={CTEventListener.class})
public class CTStoreCTEventListener
implements CTEventListener {
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private CTEntryLocalService _ctEntryLocalService;
    private long _ctsContentClassNameId;
    @Reference
    private CTSContentLocalService _ctsContentLocalService;
    private ServiceTrackerMap<String, Store> _storeServiceTrackerMap;

    public void onAfterPublish(long ctCollectionId) throws CTEventException {
        Throwable throwable;
        List ctEntries = this._ctEntryLocalService.getCTEntries(ctCollectionId, this._ctsContentClassNameId);
        if (ctEntries.isEmpty()) {
            return;
        }
        ArrayList<CTEntry> deletedCTEnties = new ArrayList<CTEntry>();
        ArrayList<CTEntry> addOrModifiedCTEntries = new ArrayList<CTEntry>();
        for (CTEntry ctEntry : ctEntries) {
            if (ctEntry.getChangeType() == 1) {
                deletedCTEnties.add(ctEntry);
                continue;
            }
            addOrModifiedCTEntries.add(ctEntry);
        }
        if (!deletedCTEnties.isEmpty()) {
            try {
                throwable = null;
                try (SafeClosable safeClosable1 = CTSQLModeThreadLocal.setCTSQLMode((CTSQLModeThreadLocal.CTSQLMode)CTSQLModeThreadLocal.CTSQLMode.CT_ONLY);
                     SafeClosable safeClosable2 = CTCollectionThreadLocal.setCTCollectionId((long)ctCollectionId);){
                    for (CTEntry ctEntry : deletedCTEnties) {
                        CTSContent ctsContent = this._ctsContentLocalService.getCTSContent(ctEntry.getModelClassPK());
                        Store store = (Store)this._storeServiceTrackerMap.getService((Object)ctsContent.getStoreType());
                        store.deleteFile(ctsContent.getCompanyId(), ctsContent.getRepositoryId(), ctsContent.getPath(), ctsContent.getVersion());
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (PortalException portalException) {
                throw new CTEventException((Throwable)portalException);
            }
        }
        if (!addOrModifiedCTEntries.isEmpty()) {
            try {
                throwable = null;
                try (SafeClosable safeClosable = CTCollectionThreadLocal.setCTCollectionId((long)0L);){
                    for (CTEntry ctEntry : addOrModifiedCTEntries) {
                        CTSContent ctsContent = this._ctsContentLocalService.getCTSContent(ctEntry.getModelClassPK());
                        Store store = (Store)this._storeServiceTrackerMap.getService((Object)ctsContent.getStoreType());
                        store.addFile(ctsContent.getCompanyId(), ctsContent.getRepositoryId(), ctsContent.getPath(), ctsContent.getVersion(), this._ctsContentLocalService.openDataInputStream(ctsContent.getCtsContentId()));
                    }
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            catch (PortalException portalException) {
                throw new CTEventException((Throwable)portalException);
            }
        }
    }

    public void onBeforeRemove(long ctCollectionId) throws CTEventException {
        List ctsContentIds = this._ctEntryLocalService.getExclusiveModelClassPKs(ctCollectionId, this._ctsContentClassNameId);
        if (ctsContentIds.isEmpty()) {
            return;
        }
        try (SafeClosable safeClosable = CTCollectionThreadLocal.setCTCollectionId((long)0L);){
            Iterator iterator = ctsContentIds.iterator();
            while (iterator.hasNext()) {
                long ctsContentId = (Long)iterator.next();
                CTSContent ctsContent = this._ctsContentLocalService.fetchCTSContent(ctsContentId);
                if (ctsContent == null) continue;
                this._ctsContentLocalService.deleteCTSContent(ctsContent);
            }
        }
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._ctsContentClassNameId = this._classNameLocalService.getClassNameId(CTSContent.class);
        this._storeServiceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, Store.class, (String)"store.type");
    }
}

