/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.store.internal;

import com.liferay.change.tracking.model.CTEntry;
import com.liferay.change.tracking.service.CTEntryLocalService;
import com.liferay.change.tracking.store.model.CTSContent;
import com.liferay.change.tracking.store.service.CTSContentLocalService;
import com.liferay.document.library.kernel.store.Store;
import com.liferay.document.library.kernel.util.DLUtil;
import com.liferay.petra.lang.SafeClosable;
import com.liferay.portal.kernel.change.tracking.CTCollectionThreadLocal;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class CTStore
implements Store {
    private final CTEntryLocalService _ctEntryLocalService;
    private final long _ctsContentClassNameId;
    private final CTSContentLocalService _ctsContentLocalService;
    private final Store _store;
    private final String _storeType;

    public CTStore(CTEntryLocalService ctEntryLocalService, long ctsContentClassNameId, CTSContentLocalService ctsContentLocalService, Store store, String storeType) {
        this._ctEntryLocalService = ctEntryLocalService;
        this._ctsContentClassNameId = ctsContentClassNameId;
        this._ctsContentLocalService = ctsContentLocalService;
        this._store = store;
        this._storeType = storeType;
    }

    public void addFile(long companyId, long repositoryId, String fileName, String versionLabel, InputStream is) throws PortalException {
        if (CTCollectionThreadLocal.isProductionMode()) {
            this._store.addFile(companyId, repositoryId, fileName, versionLabel, is);
        } else {
            this._ensureCTSContentIsLoaded(companyId, repositoryId, fileName, versionLabel);
            this._ctsContentLocalService.addCTSContent(companyId, repositoryId, fileName, versionLabel, this._storeType, is);
        }
    }

    public void deleteDirectory(long companyId, long repositoryId, String dirName) {
        if (CTCollectionThreadLocal.isProductionMode()) {
            this._store.deleteDirectory(companyId, repositoryId, dirName);
        } else {
            for (String fileName : this._store.getFileNames(companyId, repositoryId, dirName)) {
                for (String versionLabel : this._store.getFileVersions(companyId, repositoryId, fileName)) {
                    if (this._isCTSContentLoaded(companyId, repositoryId, fileName, versionLabel)) continue;
                    this._loadCTSContent(companyId, repositoryId, fileName, versionLabel);
                }
            }
        }
        this._ctsContentLocalService.deleteCTSContentsByDirectory(companyId, repositoryId, dirName, this._storeType);
    }

    public void deleteFile(long companyId, long repositoryId, String fileName, String versionLabel) {
        if (CTCollectionThreadLocal.isProductionMode()) {
            this._store.deleteFile(companyId, repositoryId, fileName, versionLabel);
        } else {
            this._ensureCTSContentIsLoaded(companyId, repositoryId, fileName, versionLabel);
        }
        this._ctsContentLocalService.deleteCTSContent(companyId, repositoryId, fileName, versionLabel, this._storeType);
    }

    public InputStream getFileAsStream(long companyId, long repositoryId, String fileName, String versionLabel) throws PortalException {
        if (!CTCollectionThreadLocal.isProductionMode() && this._isCTSContentLoaded(companyId, repositoryId, fileName, versionLabel)) {
            CTSContent ctsContent = this._ctsContentLocalService.getCTSContent(companyId, repositoryId, fileName, versionLabel, this._storeType);
            return this._ctsContentLocalService.openDataInputStream(ctsContent.getCtsContentId());
        }
        return this._store.getFileAsStream(companyId, repositoryId, fileName, versionLabel);
    }

    public String[] getFileNames(long companyId, long repositoryId, String dirName) {
        String[] fileNames = this._store.getFileNames(companyId, repositoryId, dirName);
        if (CTCollectionThreadLocal.isProductionMode()) {
            return fileNames;
        }
        Set<Long> deletedCTSContentIds = this._getDeletedCTSContentIds(CTCollectionThreadLocal.getCTCollectionId());
        if (deletedCTSContentIds == null) {
            HashSet<String> mergedFileNames = new HashSet<String>(Arrays.asList(fileNames));
            for (CTSContent ctsContent : this._ctsContentLocalService.getCTSContentsByDirectory(companyId, repositoryId, dirName, this._storeType)) {
                mergedFileNames.add(ctsContent.getPath());
            }
            return this._toSortedArray(mergedFileNames, null);
        }
        HashMap<String, Set> fileVersionsMap = new HashMap<String, Set>();
        for (String fileName2 : fileNames) {
            fileVersionsMap.put(fileName2, new HashSet<String>(Arrays.asList(this._store.getFileVersions(companyId, repositoryId, fileName2))));
        }
        for (CTSContent ctsContent : this._ctsContentLocalService.getCTSContentsByDirectory(companyId, repositoryId, dirName, this._storeType)) {
            fileVersionsMap.compute(ctsContent.getPath(), (fileName, fileVersions) -> {
                if (fileVersions == null) {
                    fileVersions = new HashSet<String>();
                }
                fileVersions.add(ctsContent.getVersion());
                return fileVersions;
            });
        }
        try (SafeClosable safeClosable = CTCollectionThreadLocal.setCTCollectionId((long)0L);){
            for (CTSContent ctsContent : this._ctsContentLocalService.getCTSContentsByDirectory(companyId, repositoryId, dirName, this._storeType)) {
                if (!deletedCTSContentIds.contains(ctsContent.getCtsContentId())) continue;
                fileVersionsMap.compute(ctsContent.getPath(), (fileName, fileVersions) -> {
                    fileVersions.remove(ctsContent.getVersion());
                    if (fileVersions.isEmpty()) {
                        return null;
                    }
                    return fileVersions;
                });
            }
        }
        return this._toSortedArray(fileVersionsMap.keySet(), null);
    }

    public long getFileSize(long companyId, long repositoryId, String fileName, String versionLabel) throws PortalException {
        if (!CTCollectionThreadLocal.isProductionMode() && this._isCTSContentLoaded(companyId, repositoryId, fileName, versionLabel)) {
            CTSContent ctsContent = this._ctsContentLocalService.getCTSContent(companyId, repositoryId, fileName, versionLabel, this._storeType);
            return ctsContent.getSize();
        }
        return this._store.getFileSize(companyId, repositoryId, fileName, versionLabel);
    }

    public String[] getFileVersions(long companyId, long repositoryId, String fileName) {
        String[] versions = this._store.getFileVersions(companyId, repositoryId, fileName);
        if (CTCollectionThreadLocal.isProductionMode()) {
            return versions;
        }
        HashSet<String> mergedVersions = new HashSet<String>(Arrays.asList(versions));
        for (CTSContent ctsContent : this._ctsContentLocalService.getCTSContents(companyId, repositoryId, fileName, this._storeType)) {
            mergedVersions.add(ctsContent.getVersion());
        }
        Set<Long> deletedCTSContentIds = this._getDeletedCTSContentIds(CTCollectionThreadLocal.getCTCollectionId());
        if (deletedCTSContentIds != null) {
            try (SafeClosable safeClosable = CTCollectionThreadLocal.setCTCollectionId((long)0L);){
                for (CTSContent ctsContent : this._ctsContentLocalService.getCTSContents(companyId, repositoryId, fileName, this._storeType)) {
                    if (!deletedCTSContentIds.contains(ctsContent.getCtsContentId())) continue;
                    mergedVersions.remove(ctsContent.getVersion());
                }
            }
        }
        return this._toSortedArray(mergedVersions, DLUtil::compareVersions);
    }

    public boolean hasFile(long companyId, long repositoryId, String fileName, String versionLabel) {
        if (!CTCollectionThreadLocal.isProductionMode()) {
            if (this._ctsContentLocalService.hasCTSContent(companyId, repositoryId, fileName, versionLabel, this._storeType)) {
                return true;
            }
            try (SafeClosable safeCloseable = CTCollectionThreadLocal.setCTCollectionId((long)0L);){
                if (this._ctsContentLocalService.hasCTSContent(companyId, repositoryId, fileName, versionLabel, this._storeType)) {
                    boolean bl = false;
                    return bl;
                }
            }
        }
        return this._store.hasFile(companyId, repositoryId, fileName, versionLabel);
    }

    private void _ensureCTSContentIsLoaded(long companyId, long repositoryId, String fileName, String versionLabel) {
        if (this._isCTSContentLoaded(companyId, repositoryId, fileName, versionLabel) || !this._store.hasFile(companyId, repositoryId, fileName, versionLabel)) {
            return;
        }
        this._loadCTSContent(companyId, repositoryId, fileName, versionLabel);
    }

    private Set<Long> _getDeletedCTSContentIds(long ctCollectionId) {
        HashSet<Long> deletedCTSContentIds = null;
        for (CTEntry ctEntry : this._ctEntryLocalService.getCTEntries(ctCollectionId, this._ctsContentClassNameId)) {
            if (ctEntry.getChangeType() != 1) continue;
            if (deletedCTSContentIds == null) {
                deletedCTSContentIds = new HashSet<Long>();
            }
            deletedCTSContentIds.add(ctEntry.getModelClassPK());
        }
        return deletedCTSContentIds;
    }

    private boolean _isCTSContentLoaded(long companyId, long repositoryId, String fileName, String versionLabel) {
        if (this._ctsContentLocalService.hasCTSContent(companyId, repositoryId, fileName, versionLabel, this._storeType)) {
            return true;
        }
        try (SafeClosable safeCloseable = CTCollectionThreadLocal.setCTCollectionId((long)0L);){
            boolean bl = this._ctsContentLocalService.hasCTSContent(companyId, repositoryId, fileName, versionLabel, this._storeType);
            return bl;
        }
    }

    private void _loadCTSContent(long companyId, long repositoryId, String fileName, String versionLabel) {
        try (InputStream inputStream = this._store.getFileAsStream(companyId, repositoryId, fileName, versionLabel);
             SafeClosable safeCloseable = CTCollectionThreadLocal.setCTCollectionId((long)0L);){
            this._ctsContentLocalService.addCTSContent(companyId, repositoryId, fileName, versionLabel, this._storeType, inputStream);
        }
        catch (Exception exception) {
            throw new SystemException("Unable to reload change tracking store content for deletion", (Throwable)exception);
        }
    }

    private String[] _toSortedArray(Collection<String> collection, Comparator<String> comparator) {
        String[] stringArray = collection.toArray(new String[0]);
        Arrays.sort(stringArray, comparator);
        return stringArray;
    }
}

