/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.change.tracking.model.impl;

import com.liferay.change.tracking.model.CTComment;
import com.liferay.change.tracking.model.CTCommentModel;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;

import java.io.Serializable;

import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the CTComment service. Represents a row in the &quot;CTComment&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>CTCommentModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link CTCommentImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see CTCommentImpl
 * @generated
 */
public class CTCommentModelImpl
	extends BaseModelImpl<CTComment> implements CTCommentModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a ct comment model instance should use the <code>CTComment</code> interface instead.
	 */
	public static final String TABLE_NAME = "CTComment";

	public static final Object[][] TABLE_COLUMNS = {
		{"mvccVersion", Types.BIGINT}, {"ctCommentId", Types.BIGINT},
		{"companyId", Types.BIGINT}, {"userId", Types.BIGINT},
		{"createDate", Types.TIMESTAMP}, {"modifiedDate", Types.TIMESTAMP},
		{"ctCollectionId", Types.BIGINT}, {"ctEntryId", Types.BIGINT},
		{"value", Types.CLOB}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("mvccVersion", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("ctCommentId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("ctCollectionId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("ctEntryId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("value", Types.CLOB);
	}

	public static final String TABLE_SQL_CREATE =
		"create table CTComment (mvccVersion LONG default 0 not null,ctCommentId LONG not null primary key,companyId LONG,userId LONG,createDate DATE null,modifiedDate DATE null,ctCollectionId LONG,ctEntryId LONG,value TEXT null)";

	public static final String TABLE_SQL_DROP = "drop table CTComment";

	public static final String ORDER_BY_JPQL =
		" ORDER BY ctComment.ctCommentId DESC";

	public static final String ORDER_BY_SQL =
		" ORDER BY CTComment.ctCommentId DESC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long CTCOLLECTIONID_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long CTENTRYID_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *		#getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long CTCOMMENTID_COLUMN_BITMASK = 4L;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setEntityCacheEnabled(boolean entityCacheEnabled) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setFinderCacheEnabled(boolean finderCacheEnabled) {
	}

	public CTCommentModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _ctCommentId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setCtCommentId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _ctCommentId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return CTComment.class;
	}

	@Override
	public String getModelClassName() {
		return CTComment.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<CTComment, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		for (Map.Entry<String, Function<CTComment, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<CTComment, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName, attributeGetterFunction.apply((CTComment)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<CTComment, Object>> attributeSetterBiConsumers =
			getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<CTComment, Object> attributeSetterBiConsumer =
				attributeSetterBiConsumers.get(attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(CTComment)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<CTComment, Object>>
		getAttributeGetterFunctions() {

		return AttributeGetterFunctionsHolder._attributeGetterFunctions;
	}

	public Map<String, BiConsumer<CTComment, Object>>
		getAttributeSetterBiConsumers() {

		return AttributeSetterBiConsumersHolder._attributeSetterBiConsumers;
	}

	private static class AttributeGetterFunctionsHolder {

		private static final Map<String, Function<CTComment, Object>>
			_attributeGetterFunctions;

		static {
			Map<String, Function<CTComment, Object>> attributeGetterFunctions =
				new LinkedHashMap<String, Function<CTComment, Object>>();

			attributeGetterFunctions.put(
				"mvccVersion", CTComment::getMvccVersion);
			attributeGetterFunctions.put(
				"ctCommentId", CTComment::getCtCommentId);
			attributeGetterFunctions.put("companyId", CTComment::getCompanyId);
			attributeGetterFunctions.put("userId", CTComment::getUserId);
			attributeGetterFunctions.put(
				"createDate", CTComment::getCreateDate);
			attributeGetterFunctions.put(
				"modifiedDate", CTComment::getModifiedDate);
			attributeGetterFunctions.put(
				"ctCollectionId", CTComment::getCtCollectionId);
			attributeGetterFunctions.put("ctEntryId", CTComment::getCtEntryId);
			attributeGetterFunctions.put("value", CTComment::getValue);

			_attributeGetterFunctions = Collections.unmodifiableMap(
				attributeGetterFunctions);
		}

	}

	private static class AttributeSetterBiConsumersHolder {

		private static final Map<String, BiConsumer<CTComment, Object>>
			_attributeSetterBiConsumers;

		static {
			Map<String, BiConsumer<CTComment, ?>> attributeSetterBiConsumers =
				new LinkedHashMap<String, BiConsumer<CTComment, ?>>();

			attributeSetterBiConsumers.put(
				"mvccVersion",
				(BiConsumer<CTComment, Long>)CTComment::setMvccVersion);
			attributeSetterBiConsumers.put(
				"ctCommentId",
				(BiConsumer<CTComment, Long>)CTComment::setCtCommentId);
			attributeSetterBiConsumers.put(
				"companyId",
				(BiConsumer<CTComment, Long>)CTComment::setCompanyId);
			attributeSetterBiConsumers.put(
				"userId", (BiConsumer<CTComment, Long>)CTComment::setUserId);
			attributeSetterBiConsumers.put(
				"createDate",
				(BiConsumer<CTComment, Date>)CTComment::setCreateDate);
			attributeSetterBiConsumers.put(
				"modifiedDate",
				(BiConsumer<CTComment, Date>)CTComment::setModifiedDate);
			attributeSetterBiConsumers.put(
				"ctCollectionId",
				(BiConsumer<CTComment, Long>)CTComment::setCtCollectionId);
			attributeSetterBiConsumers.put(
				"ctEntryId",
				(BiConsumer<CTComment, Long>)CTComment::setCtEntryId);
			attributeSetterBiConsumers.put(
				"value", (BiConsumer<CTComment, String>)CTComment::setValue);

			_attributeSetterBiConsumers = Collections.unmodifiableMap(
				(Map)attributeSetterBiConsumers);
		}

	}

	@Override
	public long getMvccVersion() {
		return _mvccVersion;
	}

	@Override
	public void setMvccVersion(long mvccVersion) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_mvccVersion = mvccVersion;
	}

	@Override
	public long getCtCommentId() {
		return _ctCommentId;
	}

	@Override
	public void setCtCommentId(long ctCommentId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_ctCommentId = ctCommentId;
	}

	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_createDate = createDate;
	}

	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_modifiedDate = modifiedDate;
	}

	@Override
	public long getCtCollectionId() {
		return _ctCollectionId;
	}

	@Override
	public void setCtCollectionId(long ctCollectionId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_ctCollectionId = ctCollectionId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCtCollectionId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("ctCollectionId"));
	}

	@Override
	public long getCtEntryId() {
		return _ctEntryId;
	}

	@Override
	public void setCtEntryId(long ctEntryId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_ctEntryId = ctEntryId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCtEntryId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("ctEntryId"));
	}

	@Override
	public String getValue() {
		if (_value == null) {
			return "";
		}
		else {
			return _value;
		}
	}

	@Override
	public void setValue(String value) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_value = value;
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), CTComment.class.getName(), getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public CTComment toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, CTComment>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		CTCommentImpl ctCommentImpl = new CTCommentImpl();

		ctCommentImpl.setMvccVersion(getMvccVersion());
		ctCommentImpl.setCtCommentId(getCtCommentId());
		ctCommentImpl.setCompanyId(getCompanyId());
		ctCommentImpl.setUserId(getUserId());
		ctCommentImpl.setCreateDate(getCreateDate());
		ctCommentImpl.setModifiedDate(getModifiedDate());
		ctCommentImpl.setCtCollectionId(getCtCollectionId());
		ctCommentImpl.setCtEntryId(getCtEntryId());
		ctCommentImpl.setValue(getValue());

		ctCommentImpl.resetOriginalValues();

		return ctCommentImpl;
	}

	@Override
	public CTComment cloneWithOriginalValues() {
		CTCommentImpl ctCommentImpl = new CTCommentImpl();

		ctCommentImpl.setMvccVersion(
			this.<Long>getColumnOriginalValue("mvccVersion"));
		ctCommentImpl.setCtCommentId(
			this.<Long>getColumnOriginalValue("ctCommentId"));
		ctCommentImpl.setCompanyId(
			this.<Long>getColumnOriginalValue("companyId"));
		ctCommentImpl.setUserId(this.<Long>getColumnOriginalValue("userId"));
		ctCommentImpl.setCreateDate(
			this.<Date>getColumnOriginalValue("createDate"));
		ctCommentImpl.setModifiedDate(
			this.<Date>getColumnOriginalValue("modifiedDate"));
		ctCommentImpl.setCtCollectionId(
			this.<Long>getColumnOriginalValue("ctCollectionId"));
		ctCommentImpl.setCtEntryId(
			this.<Long>getColumnOriginalValue("ctEntryId"));
		ctCommentImpl.setValue(this.<String>getColumnOriginalValue("value"));

		return ctCommentImpl;
	}

	@Override
	public int compareTo(CTComment ctComment) {
		int value = 0;

		if (getCtCommentId() < ctComment.getCtCommentId()) {
			value = -1;
		}
		else if (getCtCommentId() > ctComment.getCtCommentId()) {
			value = 1;
		}
		else {
			value = 0;
		}

		value = value * -1;

		if (value != 0) {
			return value;
		}

		return 0;
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof CTComment)) {
			return false;
		}

		CTComment ctComment = (CTComment)object;

		long primaryKey = ctComment.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return true;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return true;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_setModifiedDate = false;

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<CTComment> toCacheModel() {
		CTCommentCacheModel ctCommentCacheModel = new CTCommentCacheModel();

		ctCommentCacheModel.mvccVersion = getMvccVersion();

		ctCommentCacheModel.ctCommentId = getCtCommentId();

		ctCommentCacheModel.companyId = getCompanyId();

		ctCommentCacheModel.userId = getUserId();

		Date createDate = getCreateDate();

		if (createDate != null) {
			ctCommentCacheModel.createDate = createDate.getTime();
		}
		else {
			ctCommentCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			ctCommentCacheModel.modifiedDate = modifiedDate.getTime();
		}
		else {
			ctCommentCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		ctCommentCacheModel.ctCollectionId = getCtCollectionId();

		ctCommentCacheModel.ctEntryId = getCtEntryId();

		ctCommentCacheModel.value = getValue();

		String value = ctCommentCacheModel.value;

		if ((value != null) && (value.length() == 0)) {
			ctCommentCacheModel.value = null;
		}

		return ctCommentCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<CTComment, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<CTComment, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<CTComment, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply((CTComment)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, CTComment>
			_escapedModelProxyProviderFunction =
				ProxyUtil.getProxyProviderFunction(
					CTComment.class, ModelWrapper.class);

	}

	private long _mvccVersion;
	private long _ctCommentId;
	private long _companyId;
	private long _userId;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private long _ctCollectionId;
	private long _ctEntryId;
	private String _value;

	public <T> T getColumnValue(String columnName) {
		Function<CTComment, Object> function =
			AttributeGetterFunctionsHolder._attributeGetterFunctions.get(
				columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((CTComment)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("mvccVersion", _mvccVersion);
		_columnOriginalValues.put("ctCommentId", _ctCommentId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("userId", _userId);
		_columnOriginalValues.put("createDate", _createDate);
		_columnOriginalValues.put("modifiedDate", _modifiedDate);
		_columnOriginalValues.put("ctCollectionId", _ctCollectionId);
		_columnOriginalValues.put("ctEntryId", _ctEntryId);
		_columnOriginalValues.put("value", _value);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("mvccVersion", 1L);

		columnBitmasks.put("ctCommentId", 2L);

		columnBitmasks.put("companyId", 4L);

		columnBitmasks.put("userId", 8L);

		columnBitmasks.put("createDate", 16L);

		columnBitmasks.put("modifiedDate", 32L);

		columnBitmasks.put("ctCollectionId", 64L);

		columnBitmasks.put("ctEntryId", 128L);

		columnBitmasks.put("value", 256L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private CTComment _escapedModel;

}